## CARATTERISTICHE PRINCIPALI

Il componente Role Alert presenta le seguenti caratteristiche chiave:

* Funzionalità di accessibilità: il componente è progettato per essere utilizzato da utenti con disabilità
* Aspetti tecnici rilevanti:
 + Il componente utilizza la proprietà ARIA per fornire informazioni sugli elementi della pagina
 + Il componente può essere personalizzato tramite l'attributo `role`
* Caratteristiche di accessibilità: il componente è progettato per essere compatibile con le linee guida WCAG 2.1

## VARIANTI

Le varianti del componente Role Alert sono rappresentate dalle seguenti Stories:

* **Nome del componente**: Role Alert
 + Descrizione: Mostra un messaggio personalizzato agli utenti con disabilità
 + Caso d'uso: Utilizzare il componente per fornire informazioni importanti in modo accessibile
 + Breve descrizione: Il componente Role Alert è un elemento web progettato per mostrare messaggi personalizzati agli utenti con disabilità.

## BEST PRACTICES

Le raccomandazioni d'uso del componente Role Alert sono le seguenti:

* Utilizzare il componente per fornire informazioni importanti in modo accessibile
* Personalizzare il componente tramite l'attributo `role` per adattarlo alle esigenze specifiche dell'applicazione

## COMPONENTI CORRELATI

Il componente Role Alert non ha componenti associati diretti. Tuttavia, può essere utilizzato in combinazione con altri elementi della pagina per fornire un'esperienza utente più accessibile.

Nota: non sono presenti informazioni aggiuntive sul componente Role Alert oltre a quelle già descritte.

## OVERVIEW
`import { RoleAlertComponent } from '@inail/intranet-webkit/accessibility';` 

Il Role Alert è un componente che migliora l'esperienza dell'utente fornendo avvisi personalizzati e accessibili. È progettato per garantire che le informazioni importanti siano chiaramente comunicate agli utenti, inclusi quelli che utilizzano tecnologie assistive.

## API

<div class="table-responsive">
  <table class="table table-documentation">
    <thead>
      <tr>
        <th><strong>Campo</strong></th>
        <th><strong>Descrizione</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td><code>rolAlert</code></td>
        <td>Oggetto di tipo RoleAlertModel. Quando alert.back è valorizzato, viene utilizzato il binding [readerFocus]="alert.back". <a  href="?path=/docs/resources-models-rolealertmodel--docs">ActionItem</a>.
        </td>
      </tr>
    </tbody>
  </table>
</div>