## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Visualizzazione di etichette e valori
 + Gestione della dimensione del testo (Bootstrap size of the input detail)
* Aspetti tecnici rilevanti:
 + Utilizzo di un sistema di griglia per la gestione della posizione degli elementi
 + Possibilità di personalizzare l'aspetto tramite classi CSS
* Caratteristiche di accessibilità: N.D.

## VARIANTI

Il componente Input Detail presenta le seguenti varianti:

* **Default**: rappresentazione standard del componente, con etichetta e valore visualizzati in modo chiaro e conciso.
 + Caso d'uso: utilizzare quando si desidera mostrare informazioni di base senza aggiungere ulteriori dettagli.
* **Con descrizione**: variante che include una descrizione aggiuntiva per il valore.
 + Caso d'uso: utilizzare quando si desidera fornire contesto aggiuntivo per il valore visualizzato.

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente Input Detail quando si desidera mostrare informazioni di base in modo chiaro e conciso.
 + Evitare di utilizzare il componente per visualizzare grandi quantità di dati, poiché ciò potrebbe rendere difficile la lettura.
* Linee guida implementative:
 + Assicurarsi di utilizzare classi CSS coerenti per mantenere un aspetto uniforme nel progetto.
 + Utilizzare il sistema di griglia per gestire la posizione degli elementi in modo efficiente.

## COMPONENTI CORRELATI

Il componente Input Detail è correlato ai seguenti componenti:

* Componenti di form: il componente Input Detail può essere utilizzato all'interno di form per visualizzare informazioni di base.
* Componenti di tabella: il componente Input Detail può essere utilizzato per visualizzare dati in forma tabellare.

## OVERVIEW
<div class="table-responsive">`import { InputDetailComponent } from '@inail/internet-webkit/elements';`</div>
Componente custom che si usa per mostrare una label e un valore.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>label</code></td>
      <td>
        `@Input('label') set label(value: string) {}` <br />
        Campo di tipo string che imposta l'etichetta all' InputDetail.
      </td>
    </tr>
    <tr>
      <td><code>extId</code></td>
      <td>
          `@Input('ext-id') extId: string = composeUniqueId('.');` <br />
          "ID aggiunto all'InputDetail."
      </td>
    </tr>
    <tr>
      <td><code>value</code></td>
      <td>
          `@Input('value') value: any;` <br />
          Imposta il valore mostrato dall' InputDetail.
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
          `@Input() set size(pipes: string | BootstrapSize) {}` <br />
          Campo che imposta le dimensioni <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize</a> al componente.
      </td>
    </tr>
  </tbody>
</table>
</div>