## CARATTERISTICHE PRINCIPALI
Il componente Action presenta le seguenti caratteristiche chiave:

* **Funzionalità**: il componente può essere utilizzato per eseguire azioni diverse, come ad esempio il download di un file o l'invio di una richiesta.
* **Aspetti tecnici**: il componente è realizzato utilizzando tecnologie web standard e può essere personalizzato mediante CSS e JavaScript.
* **Accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, in conformità con le linee guida WCAG 2.1.

## VARIANTI
Sono disponibili le seguenti varianti del componente Azione:

* **Scarica file**: questa variante consente di scaricare un file specifico.
 + Caso d'uso: utilizzare il componente per scaricare un file da un server remoto.
 + Descrizione breve: Scarica un file specifico con un clic.
* **Show code**: questa variante visualizza il codice sorgente del componente.
 + Caso d'uso: utilizzare il componente per visualizzare il codice sorgente di una pagina web.
 + Descrizione breve: Visualizza il codice sorgente del componente.

## BEST PRACTICES
Per utilizzare il componente Azione in modo efficace, è consigliabile:

* Utilizzare il componente solo quando necessario, per evitare confusione nell'interfaccia utente.
* Personalizzare l'aspetto e il comportamento del componente per adattarlo alle esigenze specifiche dell'applicazione.

## COMPONENTI CORRELATI
Il componente Azione può essere utilizzato in combinazione con altri componenti, come ad esempio:

* **Button**: il componente Pulsante può essere utilizzato per attivare l'azione del componente Azione.
* **Dropdown**: il componente Menu a discesa può essere utilizzato per fornire opzioni aggiuntive per l'azione del componente Azione.

Nota: le informazioni sui componenti correlati sono incomplete e potrebbero richiedere ulteriori ricerche.

## OVERVIEW
<div class="table-responsive">`import { ActionComponent } from '@inail/internet-webkit/buttons';`</div>


L'ActionComponent è un componente progettato per rappresentare un'azione interattiva in un'interfaccia utente. Questo componente è altamente personalizzabile, consentendo di specificare icone, titoli dinamici, classi aggiuntive e altre configurazioni.

L'ActionComponent è ideale per creare pulsanti o elementi interattivi che eseguono azioni specifiche e supportano l'uso di tooltip per migliorare l'esperienza utente. È particolarmente utile in contesti in cui le azioni sono associate a modelli o dati dinamici.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>action</code></td>
      <td> <code>`@Input() set action(action: ActionItem) {...} `</code><br /> 
      Azione da rappresentare nel componente. Deve essere un oggetto di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>.
      </td>
    </tr>
    <tr>
      <td><code>model</code></td>
      <td> <code>@Input() model!: BaseModel;</code><br /><a href="?path=/docs/resources-models-basemodel--docs">BaseModel</a> è un modello associato all'azione. Fornisce dati dinamici al componente, rendendolo contestualmente sensibile. </td>
    </tr>
    <tr>
      <td><code>onlyIcon</code></td>
      <td> <code>@Input() onlyIcon = false;</code><br /> Booleano che indica se l'azione deve mostrare solo l'icona oppure anche il testo.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>disabled</code></td>
      <td> <code>@Input() disabled = false;</code><br /> Booleano che abilita o disabilita l'interattività del componente.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>dynamicTitle</code></td>
      <td> <code>@Input() dynamicTitle!: string | number;</code><br /> Titolo dinamico visualizzato nel componente. Può essere un testo o un valore numerico. </td>
    </tr>
    <tr>
      <td><code>extraClass</code></td>
      <td> <code>@Input() extraClass = '';</code><br /> Classe CSS aggiuntiva per personalizzare ulteriormente lo stile del componente.</td>
    </tr>
    <tr>
      <td><code>tooltipPlacement</code></td>
      <td> <code>@Input() tooltipPlacement: TooltipPlaceType = TooltipPlacementEnum.LEFT;</code><br /> Specifica la posizione del tooltip rispetto all'azione. Il valore predefinito è <code>LEFT</code>. 
      <br />
      <ul>
      <li><a href="?path=/docs/resources-models-tooltipplacetype--docs">TooltipPlaceType</a></li>
      <li><a href="?path=/docs/resources-models-tooltipplacementenum--docs">TooltipPlacementEnum</a></li>
      </ul> </td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td> <code>@Input() id: string = composeUniqueId('action');</code><br /> Identificativo univoco generato automaticamente per il componente. È possibile sovrascriverlo fornendo un valore personalizzato. </td>
    </tr>
  </tbody>
</table>
</div>
