## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Simple Table includono:

* Possibilità di definire le colonne e le righe della tabella
* Supporta la gestione dinamica dei dati tramite API REST.
* Possibilità di personalizzare l'aspetto della tabella

Gli aspetti tecnici rilevanti includono:

* Utilizzo di tecnologie web standard (HTML, CSS, JavaScript)
* Supporta la gestione dinamica dei dati tramite API REST.

Le caratteristiche di accessibilità includono:

* Supporto per la navigazione con tastiera
* Possibilità di personalizzare il colore e la dimensione del testo

## VARIANTI
Le varianti disponibili per il componente Simple Table includono:

* **Default**: la variante predefinita, che visualizza i dati in forma tabellare standard
* **Custom**: una variante personalizzabile, che consente di definire le colonne e le righe della tabella
* **Loading**: una variante che visualizza un'animazione di caricamento quando i dati non sono ancora disponibili

Per ogni variante, è possibile definire casi d'uso specifici, come ad esempio:

* Utilizzare la variante Default per visualizzare dati standard
* Utilizzare la variante Custom per personalizzare l'aspetto della tabella
* Utilizzare la variante Loading per gestire situazioni in cui i dati non sono ancora disponibili

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Simple Table includono:

* Utilizzare le varianti predefinite per semplificare la gestione dei dati
* Personalizzare l'aspetto della tabella solo quando necessario
* Utilizzare la gestione dei dati tramite API per garantire la scalabilità e la flessibilità

Le linee guida implementative includono:

* Utilizzare tecnologie web standard (HTML, CSS, JavaScript)
* Supporta la gestione dinamica dei dati tramite API REST.

Le pratiche da evitare includono:

* Non utilizzare codice non standard o proprietario
* Non personalizzare l'aspetto della tabella quando non necessario

## COMPONENTI CORRELATI
I componenti associati al componente Simple Table includono:

* **Componente Button**: utilizzato per gestire le azioni sulla tabella
* **Componente Input**: utilizzato per inserire dati nella tabella

Le relazioni con altri elementi includono:

* Utilizzo del componente Simple Table all'interno di una pagina web
* Integrazione con altri componenti per creare un'interfaccia utente completa


## OVERVIEW

<div class="table-responsive">`import { TableResultComponent } from '@inail/intranet-webkit/tables';`</div>

Componente custom usato per costruire tabelle. In questo caso, basta usare solo parti del componente del webkit per costruire una variazione semplice della tabella.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th><strong>Campo</strong></th>
	  <th><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>title</code></td>
	  <td>
		  `@Input() title!: string;` <br />
		  Titolo visualizzato sopra la tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>results</code></td>
	  <td>
		  `@Input('results') set manageResultInput(result: any[]) {}` <br />
		  Un array di oggetti che vengono mostrati sulla tabella come elementi. Per informazioni più approfondite fare riferimento alla documentazione di <a href="?path=/docs/resources-models-results--docs">results</a>
	  </td>
	</tr>
	<tr>
	  <td><code>tableStructure</code></td>
	  <td>
		  `@Input('structure') tableStructure: any[] = [];` <br />
		  Un array che costruisce la struttura della tabella. L' array contiene elementi <a href="?path=/docs/resources-models-tablefield--docs">TableField</a> che rappresentano le colonne, e facoltativamente, si può aggiungere un ultimo oggetto <a href="?path=/docs/resources-models-actionsfield--docs">ActionsField</a>  che rappresenta la colonna di azioni della tabella.
			`const tableStructure = [
  			new TableField('Colonna 1', true, 'NORMAL', 'name', false),
  			new TableField('Colonna 2', false, 'NORMAL', 'size', false),
  			new ActionsField('', [
  			  new ActionItem(
  			    'BUTTON.EDIT_STEP',
  			    (actions: ActionItem, item: any) => {
  			      action('onEdit')('');
  			    },
  			    ['pencil']
  			  ),
  			]),
];`
	  </td>
	</tr>
	<tr>
	  <td><code>bordered</code></td>
	  <td>
		  `@Input() bordered: true;` <br />
		  Booleano usato per mostrare/nascondere le divisioni delle righe e colonne della tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>stripped</code></td>
	  <td>
		  `@Input() stripped: true;` <br />
		  Booleano usato per applicare la classe CSS `table-striped`.
	  </td>
	</tr>
	<tr>
	  <td><code>bgWhite</code></td>
	  <td>
		  `@Input() bgWhite: true;` <br />
		  Booleano usato per impostare uno sfondo bianco quando impostato su `true` o trasparente quando impostato su `false`.
	  </td>
	</tr>
	<tr>
	  <td><code>loading</code></td>
	  <td>
		  `@Input() loading: false;` <br />
		  Booleano usato per mostrare un stato di caricamento dei dati sulla tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>hover</code></td>
	  <td>
		  `@Input() hover: true;` <br />
		  Booleano usato per abilitare l' effetto del passaggio del mouse sulle righe.
	  </td>
	</tr>
  </tbody>
</table>
</div>