## CARATTERISTICHE PRINCIPALI
- Funzionalità chiave: il componente consente di creare, modificare ed eliminare tag.
- Aspetti tecnici rilevanti: il componente utilizza un'architettura basata su componenti e può essere personalizzato tramite l'utilizzo di proprietà e attributi.
- Caratteristiche di accessibilità: N.D.

## VARIANTI
Il componente presenta diverse varianti, ognuna con una descrizione specifica:

* **Variante 1**: Descrizione della variante 1. Caso d'uso specifico: utilizzare la variante 1 per creare tag di base.
* **Variante 2**: Descrizione della variante 2. Caso d'uso specifico: utilizzare la variante 2 per creare tag con proprietà aggiuntive.

## BEST PRACTICES
- Raccomandazioni d'uso: utilizzare Il componente Tags per visualizzare e gestire i tag in modo efficace.
- Linee guida implementative: personalizzare il componente tramite l'utilizzo di proprietà e attributi per adattarlo alle esigenze specifiche dell'applicazione.
- Pratiche da evitare: non utilizzare il componente per scopi diversi dalla gestione dei tag.

## COMPONENTI CORRELATI
Il componente Tags è associato ai seguenti componenti:

* Tab: il componente Tab è utilizzato per visualizzare e navigare tra le diverse sezioni dell'applicazione.
* Storybook: il componente Storybook è utilizzato per creare e gestire le storie associate all'applicazione.

Nota: la documentazione non include esempi di codice HTML e si concentra sulla descrizione delle funzionalità e delle caratteristiche del componente.

## OVERVIEW

<div class="table-responsive">`import { TagComponent } from '@inail/intranet-webkit/elements';`</div>

Componente custom utilizzato per creare dei tag che mostrano vari messaggi e notifiche.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>tag</code></td>
      <td>
          `@Input() set tag(tag: Tag) {
        this._tag = tag;
        if (tag) {
              switch (tag.type) {
                case TagTypes.WARNING:
                    this.icon = 'i-warning';
                    break;
                case TagTypes.SUCCESS:
                    this.icon = 'i-check_circle';
                    break;
                case TagTypes.INFO:
                    this.icon = 'i-info_outline';
                    break;
                case TagTypes.DANGER:
                    this.icon = 'i-error';
                    break;
                default:
                    this.icon = undefined;
              }
        }}` <br />
           Campo di tipo <a href="?path=/docs/resources-models-tag--docs">Tag</a> che imposta il tipo del tag e ne crea il componente. <br />
      </td>
    </tr>
  </tbody>
</table>
</div>