const d=()=>{const e=document.createElement("div");e.className="row breadcrumbs internet-breadcrumb",e.ariaLabel="Breadcrumb";const n=document.createElement("ul");return n.className="breadcrumb visible-sm-block visible-md-block visible-lg-block",["Livello 1","Livello 2","Livello 3"].forEach(r=>{const t=document.createElement("li");if(r!=="Livello 3"){const i=document.createElement("a");i.href="#",i.textContent=r,i.addEventListener("click",function(s){s.preventDefault()}),t.appendChild(i)}else t.textContent=r;n.appendChild(t)}),e.appendChild(n),e},u=`La breadcrumb ("briciole di pane") é una tecnica di navigazione utilizzata nelle interfacce utente. Rappresenta il percorso gerarchico di<br/>link per giungere una data pagina all\\'interno di un sito web.<br/>É un elemento utile per tornare indietro e/o alla pagina iniziale del sito web.
`,p=`**PANORAMICA**  
- **Descrizione generale**: Il componente Breadcrumb fornisce un aiuto alla navigazione, mostrando la posizione corrente dell’utente all’interno della gerarchia del sito. Aiuta gli utenti a comprendere il loro contesto e a navigare facilmente verso livelli precedenti.
- **Funzionalità principali**: Visualizza una sequenza di link che rappresentano il percorso di navigazione dell'utente, permettendo un rapido ritorno a pagine precedenti.

**CASO D'USO**  
- **Scenari di utilizzo principali**: Particolarmente utile per siti web con strutture complesse o più livelli di informazioni.
- **Contesto di implementazione consigliato**: Da posizionare nella parte superiore della pagina, tipicamente sotto la barra di navigazione principale.
- **Posizionamento ideale nell'interfaccia**: Sotto la barra di navigazione principale, per fornire un contesto immediato all'utente.

**CARATTERISTICHE PRINCIPALI**  
- **Funzionalità chiave**:
  - Indicatori visivi: Utilizza una sequenza di link di testo separati da un indicatore visivo, solitamente un “/” o “>”.
  - Rappresentazione gerarchica: Ogni link rappresenta un passo nella gerarchia, permettendo agli utenti di risalire il percorso di navigazione.
  - Navigazione accessibile: Il componente segue gli standard di accessibilità, garantendo che tutti gli utenti, inclusi quelli che utilizzano screen reader, possano interagirvi facilmente.
- **Aspetti tecnici rilevanti**: Implementato come una lista ordinata o non ordinata, con elementi di lista che rappresentano ciascun livello di navigazione.
- **Caratteristiche di accessibilità**: Include attributi ARIA appropriati per gli utenti che navigano con tecnologie assistive.

**VARIANTI**  
- **Elenco e descrizione delle varianti disponibili**:
  - Breadcrumb base: Una semplice struttura di breadcrumb per casi d’uso standard.
  - Breadcrumb avanzato: Contiene funzionalità aggiuntive come tooltip o icone.
- **Casi d'uso specifici per ogni variante**:
  - Breadcrumb base: Adatto per siti con una struttura semplice.
  - Breadcrumb avanzato: Utile in contesti dove è necessario fornire informazioni aggiuntive o migliorare l'esperienza utente.

**PROPRIETÀ**  
- **Proprietà configurabili**:
  - \`items\`: Elenco di elementi breadcrumb, ciascuno contenente una proprietà \`label\` e \`link\`.
  - \`separator\`: Simbolo separatore personalizzabile tra gli elementi del breadcrumb.
  - \`aria-label\`: Utilizzato per l’accessibilità, per descrivere la navigazione breadcrumb.
- **Parametri disponibili**: Possibilità di definire stili personalizzati per adattarsi al design del sito.
- **Attributi per l'accessibilità**: Utilizzo di \`aria-current="page"\` per indicare la pagina corrente.

**DETTAGLI DI IMPLEMENTAZIONE**  
- **Struttura HTML**: Il breadcrumb utilizza una lista ordinata o non ordinata (\`<ol>\` o \`<ul>\`) con ogni elemento rappresentato come un elemento della lista (\`<li>\`).
- **Stile e CSS utilizzati**: Vengono utilizzate classi CSS personalizzate per garantire la coerenza con il linguaggio di design generale.
- **Variabili CSS disponibili e loro funzione**:
  - \`--breadcrumb-background-color\`: Colore di sfondo del breadcrumb.
  - \`--breadcrumb-text-color\`: Colore del testo degli elementi del breadcrumb.
  - \`--breadcrumb-separator-color\`: Colore del separatore tra gli elementi.
  - \`--breadcrumb-font-size\`: Dimensione del font del testo degli elementi.
  - \`--breadcrumb-padding\`: Spaziatura interna del breadcrumb.

**BEST PRACTICES**  
- **Raccomandazioni d'uso**:
  - Mantenere i breadcrumb semplici: Limitare il numero di livelli per evitare di sopraffare gli utenti.
  - Fornire contesto: I breadcrumb dovrebbero sempre iniziare dalla homepage per aiutare gli utenti a comprendere il punto di partenza.
- **Linee guida implementative**: Assicurarsi che i link siano facilmente cliccabili e che il separatore sia visivamente distinguibile.
- **Pratiche da evitare**: Evitare ridondanze: I breadcrumb non devono duplicare la navigazione principale, ma completarla.

**LINEE GUIDA PER L'ACCESSIBILITÀ**  
- **Requisiti di accessibilità**: I breadcrumb includono attributi ARIA appropriati per gli utenti che navigano con tecnologie assistive.
- **Supporto tastiera**: Assicurarsi che i link dei breadcrumb possano essere navigati tramite tastiera.
- **Configurazione screen reader**: Utilizzare \`aria-current="page"\` per la pagina corrente, per aiutare gli screen reader a fornire il contesto corretto.

**COMPONENTI CORRELATI**  
- **Componenti associati**: Barra di navigazione: La navigazione principale del sito web.
- **Relazioni con altri elementi**: Paginazione: Un componente utilizzato per navigare tra le pagine in una sequenza.
`,b={title:"Components/Breadcrumb e Menu Servizi Online/Breadcrumb",tags:["autodocs"],render:()=>d(),parameters:{docs:{description:{component:p},mdxPage:u}}},a={};var o,l,c;a.parameters={...a.parameters,docs:{...(o=a.parameters)==null?void 0:o.docs,source:{originalSource:"{}",...(c=(l=a.parameters)==null?void 0:l.docs)==null?void 0:c.source}}};const g=["Breadcrumb"];export{a as Breadcrumb,g as __namedExportsOrder,b as default};
