## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave: il componente consente di visualizzare informazioni aggiuntive in modo chiaro e conciso.
* Aspetti tecnici rilevanti: il componente è realizzato utilizzando tecnologie web standard (HTML, CSS, JavaScript).
* Caratteristiche di accessibilità: il componente rispetta le linee guida di accessibilità per i contenuti web.

## VARIANTI

Il componente "Box" presenta diverse varianti, ognuna con caratteristiche specifiche:

Variante 1: Box Standard

* Descrizione: visualizza un testo breve e un titolo.
* Casi d'uso: utilizzare per fornire informazioni aggiuntive su una pagina web.

Breve descrizione: "Box standard per la visualizzazione di informazioni brevi".

Variante 2: Box con Immagine

* Descrizione: visualizza un testo breve, un titolo e un'immagine.
* Casi d'uso: utilizzare per fornire informazioni visive aggiuntive su una pagina web.

Breve descrizione: "Box con immagine per la visualizzazione di contenuti multimediali".

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente per fornire informazioni aggiuntive che non sono essenziali per l'utilizzo della pagina.
 + Assicurarsi che il contenuto del box sia chiaro e conciso.
* Linee guida implementative:
 + Utilizzare un titolo e una descrizione chiari e concisi.
 + Scegliere un'immagine pertinente se si utilizza la variante con immagine.
* Pratiche da evitare:
 + Non utilizzare il componente per fornire informazioni essenziali per l'utilizzo della pagina.

## COMPONENTI CORRELATI

Il componente "Box" può essere utilizzato in combinazione con altri componenti, come ad esempio:

* Componente "Card": utilizzare per creare una visualizzazione più complessa dei contenuti.
* Componente "Lista": utilizzare per elencare più box con informazioni diverse.

Le relazioni con altri elementi includono:

* Utilizzo del componente Box all'interno di una pagina web per fornire informazioni aggiuntive
* Integrazione del componente Box con altri componenti per creare un'esperienza utente coerente.

## OVERVIEW
<div class="table-responsive">`import { BoxComponent } from '@inail/intranet-webkit/elements';`</div>

Componente personalizzato utilizzato per creare messaggi o contenuti informativi all'interno di una pagina web.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>title</code></td>
      <td>
        `@Input() title!: string;` <br />
        Input di tipo string che assegna il titolo al componente.
      </td>
    </tr>
    <tr>
      <td><code>description</code></td>
      <td>
          `@Input() description!: string;` <br />
          Input di tipo string che assegna la descrizione al componente.
      </td>
    </tr>
    <tr>
      <td><code>showSubtitle</code></td>
      <td>
          `@Input() showSubtitle = true;` <br />
          Input di tipo `Boolean` che decide se mostrare o no il sottotitolo (description).
      </td>
    </tr>
    <tr>
      <td><code>date</code></td>
      <td>
          `@Input() date!: DateModel;` <br />
          Oggetto di tipo DateModel. Viene usato per mostrare la data nel box.
      </td>
    </tr>
    <tr>
      <td><code>paddingClass</code></td>
      <td>
          `@Input() paddingClass!: string;` <br />
          Indica quale padding viene utilizzato nel componente.
      </td>
    </tr>
    <tr>
        <td><code>size</code></td>
        <td>
            `@Input() set size(pipes: string | BootstrapSize) {}` <br />
            Oggetto di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs"> BootstrapSize</a>, assegna i valori alle classi col- | col-sm- | col-md- | col-lg-.
        </td>
    </tr>
    <tr>
      <td><code>icon</code></td>
      <td>
          `@Input() icon!: string;` <br />
          Input di tipo string che imposta un' icona al box. La stringa si deve impostare in modo che si adatti al formato seguente <br /> `<span aria-hidden="true" class="icon i-{{ icon }}"></span>`
      </td>
    </tr>
    <tr>
      <td><code>i18n</code></td>
      <td>
          `@Input() i18n: any;` <br />
          Titolo secondario preso da i18n.
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>manageClick</code></td>
      <td>
        `@Output() manageClick = new EventEmitter();` <br />
        `EventEmitter` tramite il quale si può gestire la logica del click sul box.
      </td>
    </tr>
  </tbody>
</table>
</div>