# TooltipPlacementEnum

Documentazione dettagliata dell' enumerativo **TooltipPlacementEnum**, usato nei componenti di Internet Webkit v17. 
**TooltipPlacementEnum** definisce le posizioni possibili per il tooltip, come top, right, bottom e left.

## Implementazione
<div class="table-responsive">`import { TooltipPlacementEnum } from '@inail/internet-webkit/constants'`</div>
<br />


***Struttura:***
`enum TooltipPlacementEnum {
    TOP = "top",
    RIGHT = "right",
    BOTTOM = "bottom",
    LEFT = "left"
}
`

***Esempio d'uso:***
<br />
<div class="table-responsive">`tooltipPlacement: TooltipPlacementEnum.LEFT `</div>


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>TOP</code></td>
      <td>
        Posiziona il tooltip sopra l'elemento associato.
      </td>
    </tr>
    <tr>
      <td><code>RIGHT</code></td>
      <td>
       Posiziona il tooltip alla destra dell'elemento associato.
      </td>
    </tr>
    <tr>
      <td><code>BOTTOM</code></td>
      <td>
        Posiziona il tooltip sotto l'elemento associato.
      </td>
    </tr>
    <tr>
      <td><code>LEFT</code></td>
      <td>
        Posiziona il tooltip alla sinistra dell'elemento associato.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-buttons-action--action">Action</a>
<br/>
<a href="?path=/story/components-buttons-actions-dropdown--actions-dropdown">Action Dropdown</a>
<br/>
