## CARATTERISTICHE PRINCIPALI
- Funzionalità chiave: il componente Tooltip supporta la visualizzazione di testi descrittivi brevi e contestuali.
- Aspetti tecnici rilevanti: il componente è progettato per essere flessibile e adattabile a diverse esigenze di layout e design.
- Caratteristiche di accessibilità: il tooltip deve essere accessibile da tastiera e supportare screen reader, tramite attributi ARIA come aria-describedby.

## VARIANTI
- Elenco delle varianti disponibili:
  - Tooltip con descrizione breve
  - Tooltip con descrizione lunga
  - Tooltip con immagine
- Casi d'uso specifici per ogni variante:
  - Descrizione breve: utilizzata per fornire informazioni concise e immediate.
  - Descrizione lunga: utilizzata per fornire informazioni più dettagliate e contestuali.
  - Immagine: utilizzato per fornire una rappresentazione visiva dell'elemento descritto.

## BEST PRACTICES
- Raccomandazioni d'uso:
  + Utilizzare il componente Tooltip per fornire informazioni aggiuntive senza interrompere l'esperienza utente.
  + Posizionare il tooltip in modo che sia facilmente visibile e non copra altri elementi importanti dell'interfaccia.
- Linee guida implementative:
  + Utilizzare un linguaggio chiaro e conciso per le descrizioni.
  + Assicurarsi che il tooltip sia accessibile anche da tastiera.
- Pratiche da evitare:
  + Non utilizzare il componente Tooltip per fornire informazioni obbligatorie o critiche.

## COMPONENTI CORRELATI
- Componenti associati: N.D.
- Relazioni con altri elementi: Il componente Tooltip può essere utilizzato in combinazione con altri componenti come pulsanti, link e campi di testo.

## OVERVIEW
<div class="table-responsive">`import { InputTooltipComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente `InputTooltipComponent`  è progettato per fornire suggerimenti contestuali agli utenti tramite un tooltip interattivo. Supporta la visualizzazione di contenuti testuali o di template personalizzati, e offre opzioni di configurazione come il titolo, l'icona e le classi CSS aggiuntive. Grazie all'integrazione con Bootstrap, il tooltip può essere mostrato o nascosto dinamicamente in risposta alle azioni dell'utente.

## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>tooltip</code></td>
         <td>
            `Input() tooltip!: TooltipModel | 'template';` <br />
            Specifica il contenuto del tooltip, che può essere un modello di tooltip (`TooltipModel`) con testo o un template personalizzato per una maggiore flessibilità.
        </td>
      </tr>
      <tr>
         <td><code>tooltipTitle</code></td>
         <td>
            `@Input() tooltipTitle!: string;` <br />
            Definisce il titolo visualizzato all'interno del tooltip per fornire un'indicazione chiara del contenuto.
         </td>
      </tr>
       <tr>
         <td><code>extraClass</code></td>
         <td>
            `@Input() extraClass!: string;` <br />
            Permette di aggiungere classi CSS personalizzate per modificare l'aspetto del tooltip in base alle esigenze del progetto.
         </td>
      </tr>
       <tr>
         <td><code>icon</code></td>
         <td>
            `@Input() icon = 'info-circle';` <br />
            Specifica l'icona visualizzata accanto all'elemento per indicare la presenza di un tooltip.
         </td>
      </tr>
   </tbody>
</table>
</div>