## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del Pannello Espandibile includono:

* La gestione dello stato di espansione e compressione del contenuto
* La possibilità di personalizzare l'aspetto e il comportamento del componente tramite proprietà e attributi

Gli aspetti tecnici rilevanti includono:

* L'utilizzo di JavaScript per la gestione degli eventi e delle transizioni
* La compatibilità con diversi browser e dispositivi

Le caratteristiche di accessibilità includono:

* La possibilità di utilizzare tastiera e mouse per interagire con il componente
* La conformità agli WCAG 2.1 per l'accessibilità web

## VARIANTI

Sono disponibili le seguenti varianti del Pannello Espandibile:

* **Variante 1:** Pannello Espandibile di base, che include un titolo e un contenuto espandibile
	+ Casi d'uso specifici: utilizzo in pagine web per fornire informazioni supplementari agli utenti
	+ Breve descrizione: il pannello espandibile di base è ideale per fornire informazioni aggiuntive senza dover scorrere la pagina
* **Variante 2:** Pannello Espandibile con un placeholder, che include un titolo e un contenuto espandibile con un placeholder per il contenuto
	+ Casi d'uso specifici: utilizzo in pagine web per fornire informazioni supplementari agli utenti con la possibilità di personalizzare il contenuto
	+ Breve descrizione: il pannello espandibile con un placeholder è ideale per fornire informazioni aggiuntive e consentire all'utente di personalizzare il contenuto

## BEST PRACTICES

Le raccomandazioni d'uso del Pannello Espandibile includono:

* Utilizzare il componente in modo coerente e uniforme all'interno della pagina web
* Fornire un titolo chiaro e conciso per descrivere il contenuto espandibile

Le linee guida implementative includono:

* Utilizzare JavaScript per la gestione degli eventi e delle transizioni
* Utilizzare CSS per personalizzare l'aspetto del componente

Le pratiche da evitare includono:

* Utilizzare il componente in modo scorretto o incoerente all'interno della pagina web
* Non fornire un titolo chiaro e conciso per descrivere il contenuto espandibile

## COMPONENTI CORRELATI

Il Pannello Espandibile è associato ai seguenti componenti:

* **Accordion:** componente che consente di visualizzare e nascondere contenuto aggiuntivo in una struttura ad accordion
* **Tab:** componente che consente di visualizzare e nascondere contenuto aggiuntivo in una struttura a schede

Le relazioni con altri elementi includono:

* **Pagina web:** il Pannello Espandibile è utilizzato per fornire informazioni supplementari agli utenti all'interno della pagina web
* **Browser:** il Pannello Espandibile è compatibile con diversi browser e dispositivi

## OVERVIEW
<div class="table-responsive">`import { ExpandablePanelComponent } from "@inail/intranet-webkit/accordions";`</div>

Componente utilizzato per creare pannelli espandibili, che si integra con un elemento `<div>`, tramite il selettore `selector: 'div [data-inail-expandable-panel]'`.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        `@Input() id = composeUniqueId('panel');` <br />
        ID dell' expandable panel.
      </td>
    </tr>
    <tr>
      <td><code>accordion</code></td>
      <td>
        @Input() accordion!: TemplateRef<any> | null; <br />
        Oggetto di tipo TemplateRef che viene renderizzato nel pannello quando  isBox=false.
      </td>
    </tr>
    <tr>
      <td><code>panelTitle</code></td>
      <td>
        `@Input('panel-title') panelTitle!: string;` <br />
        Titolo del panel.
      </td>
    </tr>
    <tr>
      <td><code>panelContent</code></td>
      <td>
        @Input() panelContent!: `TemplateRef<any>`; <br />
        Oggetto di tipo TemplateRef che viene renderizzato come sezione extra nel pannello quando è valorizzato. La valorizzazione è facoltativa.
      </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td>
        `@Input() actions: ActionItem[] = [];` <br />
        Array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> valorizza l' input [actions] di un `<inail-actions-dropdown>` all' interno dell' HTML del componente.
      </td>
    </tr>
    <tr>
      <td><code>model</code></td>
      <td>
        `@Input() model: any;` <br />
        Oggetto di tipo <a href="?path=/docs/resources-models-basemodel--docs">BaseModel</a> che valorizza l'input [model] all' interno dell'HTML ExpandablePanel.
      </td>
    </tr>
    <tr>
      <td><code>editMode</code></td>
      <td>
        `@Input() editMode` <br />
        Quando valorizzato, questo input visualizza un inail-button con isLink impostato su true, che naviga a step.editMode se il valore è di tipo number, oppure a editMode(id) se il valore è di tipo Function.
      </td>
    </tr>
    <tr>
      <td><code>isBox</code></td>
      <td>
        `@Input() set isBox(val: boolean) {}` <br />
        Booleano che rende il pannello non espandibile quando è impostato su true.
      </td>
    </tr>
    <tr>
      <td><code>elementSizes</code></td>
      <td>
		`@Input() set elementSizes(s: ExpandablePanelElementSizes) {}` <br />
        Oggetto di tipo <a href="?path=/docs/resources-models-expandablepanelelementsizes--docs">ExpandablePanelElementSizes</a> che assegna le dimensioni Bootstrap agli elementi interni del pannello.
      </td>
    </tr>
    <tr>
      <td><code>isOpen</code></td>
      <td>
		`@Input() set isOpen(v: boolean) {}` <br />
        Booleano che gestisce l' apertura e la chiusura del pannello.
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Event</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
    <tr>
      <td><code>toggle</code></td>
      <td>
		`@Output() toggle = new EventEmitter<boolean>();` <br />
  		Un `EventEmitter` che emette un booleano per gestire l'apertura e la chiusura dell' `ExpandablePanel`. L'evento viene gestito internamente dal componente `ExpandablePanel` tramite la funzione. `utilityToggle()`.
  		`utilityToggle(forceValue?: boolean) {
      	if (!this.isBox) {
      	this._isOpen = forceValue == null ? !this.isOpen : forceValue;
      	this.toggle.emit(this.isOpen);
      }}`
      </td>
    </tr>
  </tbody>
</table>
</div>