const routes = {
  'home': 'pages/home.html',
  'designer': 'pages/designer.html',
  'developer': 'pages/developer.html',
  'certifier': 'pages/certifier.html',
  'brand': 'pages/brand.html',
  'archive': 'pages/archive.html'
};

function navigateTo(route) {
  window.location.hash = route;
}

async function loadPage() {
  window.scrollTo(0, 0);
  const route = location.hash.replace('#', '') || 'home';
  const file = routes[route] || 'pages/404.html';

  try {
    const response = await fetch(file);
    const html = await response.text();
    document.getElementById('contenutoprincipale').innerHTML = html;
  } catch (e) {
    document.getElementById('contenutoprincipale').innerHTML = '<h2>Errore nel caricamento della pagina</h2>';
  }
}

window.addEventListener('hashchange', loadPage);
window.addEventListener('load', () => {
  window.HeaderFooterJS.onLoad(x => {
    loadPage();
  });
});
