## CARATTERISTICHE PRINCIPALI
- **Funzionalità chiave**: Il Button può essere configurato per eseguire azioni specifiche quando viene cliccato.
- **Aspetti tecnici rilevanti**: Il Button supporta la gestione degli eventi, come ad esempio l'evento onClick.
- **Caratteristiche di accessibilità**: Il Button è progettato per essere accessibile, con opzioni per la personalizzazione dell'aspetto e del comportamento.

## VARIANTI
- **Elenco e descrizione delle varianti disponibili**:
 + Variante 1: Button standard
 + Variante 2: Button con icona sinistra
 + Variante 3: Button con icona destra
 + Variante 4: Button semplice (link)
- **Casi d'uso specifici per ogni variante**:
 + Variante 1: Utilizzare il Button standard quando si desidera un bottone di base senza icone.
 + Variante 2: Utilizzare il Button con icona sinistra quando si desidera aggiungere un'icona al bottone.
 + Variante 3: Utilizzare il Button con icona destra quando si desidera aggiungere un'icona al bottone, ma a destra del testo.
 + Variante 4: Utilizzare il Button semplice (link) quando si desidera creare un link che sembri un bottone.
- **Breve descrizione per ogni variante**:
 + Variante 1: Il Button standard è il tipo di bottone più comune e versatile.
 + Variante 2: Il Button con icona sinistra aggiunge un'icona al bottone, migliorando la sua visibilità.
 + Variante 3: Il Button con icona destra aggiunge un'icona al bottone, ma a destra del testo, creando un layout diverso.
 + Variante 4: Il Button semplice (link) è una variante leggera e semplice del bottone.

## BEST PRACTICES
- **Raccomandazioni d'uso**: Utilizzare il Button per rappresentare azioni o comandi importanti nell'applicazione.
- **Linee guida implementative**: Assicurarsi di configurare correttamente gli eventi e le proprietà del Button per garantire un comportamento coerente.
- **Pratiche da evitare**: Evitare di utilizzare troppi Button nella stessa pagina, poiché ciò può creare confusione per l'utente.

## COMPONENTI CORRELATI
- **Componenti associati**: Il Button è spesso utilizzato in combinazione con altri componenti, come ad esempio il Form o il Dialog.
- **Relazioni con altri elementi**: Il Button può essere utilizzato all'interno di un layout per creare un'interfaccia utente coerente e intuitiva.