$(document).ready(function () {
  const $tabs = $('[role="tab"]');
  const $panels = $('[role="tabpanel"]');

  // Inizializzazione tabindex per ogni gruppo di tab
  $('.exp-tabs').each(function () {
    const $groupTabs = $(this).find('[role="tab"]');
    // Imposta tabindex=0 solo sul primo tab del gruppo espandibile
    $groupTabs.attr('tabindex', '-1').first().attr('tabindex', '0');
  });

  // Stessa logica per i tab normali (non espandibili)
  const $normalTabGroups = $tabs.not('.exp-tabs [role="tab"]').closest('[role="tablist"]');
  $normalTabGroups.each(function () {
    const $groupTabs = $(this).find('[role="tab"]');
    $groupTabs.attr('tabindex', '-1').first().attr('tabindex', '0');
  });

  function isExpandableTab($tab) {
    // Verifica se è un tab espandibile (dentro .exp-tabs)
    return $tab.closest('.exp-tabs').length > 0;
  }

  function activateTab($tab) {
    const isExpandable = isExpandableTab($tab);

    if (isExpandable) {
      // Logica per tab espandibili con toggle
      const panelId = $tab.attr('aria-controls');
      const $targetPanel = $('#' + panelId);
      const isExpanded = $tab.attr('aria-expanded') === 'true';

      if (isExpanded) {
        // Chiudo il tab espandibile se è già aperto
        $tab
          .attr('aria-expanded', 'false')
          .attr('tabindex', '-1')
          .removeClass('active');

        $tab.find('a')
          .attr('aria-expanded', 'false')
          .attr('tabindex', '-1');

        $targetPanel
          .attr('aria-hidden', 'true')
          .removeClass('active');

        // 🔧 Fix: mantieni almeno un tab con tabindex=0
        const $siblings = $tab.closest('.exp-tabs').find('[role="tab"]');
        const $stillFocusable = $siblings.filter('[tabindex="0"]');

        if ($stillFocusable.length === 0) {
          // se nessun altro tab è focalizzabile, assegna tabindex=0 al primo
          $siblings.first().attr('tabindex', '0');
        }

        return;
      } else {
        // Chiudo tutti gli altri tab espandibili nello stesso gruppo
        const $expandableTabsInGroup = $tab.closest('.exp-tabs').find('[role="tab"]');
        $expandableTabsInGroup.each(function () {
          const $currentTab = $(this);
          const currentPanelId = $currentTab.attr('aria-controls');
          const $currentPanel = $('#' + currentPanelId);

          $currentTab
            .attr('aria-expanded', 'false')
            .attr('tabindex', '-1')
            .removeClass('active');

          $currentTab.find('a')
            .attr('aria-expanded', 'false')
            .attr('tabindex', '-1');

          $currentPanel
            .attr('aria-hidden', 'true')
            .removeClass('active');
        });

        // Apro il tab espandibile cliccato
        $tab
          .attr('aria-expanded', 'true')
          .attr('tabindex', '0')
          .addClass('active');

        $tab.find('a')
          .attr('aria-expanded', 'true')
          .attr('tabindex', '-1');

        $targetPanel
          .attr('aria-hidden', 'false')
          .addClass('active');
      }
    } else {
      // Logica per tab normali (comportamento standard)
      // Disattiva tutti i tab normali
      $tabs.not('.exp-tabs [role="tab"]').each(function () {
        const $currentTab = $(this);
        $currentTab
          .attr('aria-selected', 'false')
          .attr('tabindex', '-1')
          .removeClass('active');
      });

      // Nasconde tutti i pannelli dei tab normali
      $panels.not('.exp-tabs [role="tabpanel"]')
        .attr('aria-hidden', 'true')
        .removeClass('active');

      // Attiva il tab selezionato
      $tab
        .attr('aria-selected', 'true')
        .attr('tabindex', '0')
        .addClass('active')
        .focus();

      // Mostra il pannello associato
      const panelId = $tab.attr('aria-controls');
      if (panelId) {
        $('#' + panelId)
          .attr('aria-hidden', 'false')
          .addClass('active');
      }
    }
  }

  // Click con mouse - gestisce sia <li> che <a>
  $tabs.on('click', function (e) {
    e.preventDefault();
    e.stopPropagation();
    activateTab($(this));
  });

  // Click sui link dentro i tab espandibili
  $('.exp-tabs [role="tab"] a').on('click', function (e) {
    e.preventDefault();
    e.stopPropagation();
    activateTab($(this).parent('[role="tab"]'));
  });

  // Gestione tastiera
  $tabs.on('keydown', function (e) {
    const $currentTab = $(this);
    const isExpandable = isExpandableTab($currentTab);
    let $newTab;

    switch (e.key) {
      case 'ArrowRight':
      case 'Right': // Per compatibilità IE/Edge
        e.preventDefault();
        if (isExpandable) {
          // Naviga solo tra tab espandibili dello stesso gruppo
          const $expandableTabs = $currentTab.closest('.exp-tabs').find('[role="tab"]');
          const currentIndex = $expandableTabs.index($currentTab);
          $newTab = $expandableTabs.eq((currentIndex + 1) % $expandableTabs.length);
        } else {
          // Naviga solo tra tab normali
          const $normalTabs = $tabs.not('.exp-tabs [role="tab"]');
          const currentIndex = $normalTabs.index($currentTab);
          $newTab = $normalTabs.eq((currentIndex + 1) % $normalTabs.length);
        }
        $newTab.focus();
        break;

      case 'ArrowLeft':
      case 'Left':
        e.preventDefault();
        if (isExpandable) {
          // Naviga solo tra tab espandibili dello stesso gruppo
          const $expandableTabs = $currentTab.closest('.exp-tabs').find('[role="tab"]');
          const currentIndex = $expandableTabs.index($currentTab);
          $newTab = $expandableTabs.eq((currentIndex - 1 + $expandableTabs.length) % $expandableTabs.length);
        } else {
          // Naviga solo tra tab normali
          const $normalTabs = $tabs.not('.exp-tabs [role="tab"]');
          const currentIndex = $normalTabs.index($currentTab);
          $newTab = $normalTabs.eq((currentIndex - 1 + $normalTabs.length) % $normalTabs.length);
        }
        $newTab.focus();
        break;

      case 'Enter':
      case ' ':
        e.preventDefault();
        activateTab($currentTab);
        break;
    }
  });
});