## CARATTERISTICHE PRINCIPALI
Il componente Progress Bar presenta le seguenti caratteristiche principali:

* Funzionalità chiave: visualizzazione del livello di completamento
* Aspetti tecnici rilevanti: il componente può essere personalizzato mediante l'impostazione di proprietà come la larghezza, l'altezza e il colore della barra
* Caratteristiche di accessibilità: il componente è progettato per essere utilizzato da utenti con disabilità, in quanto fornisce un feedback visivo chiaro sullo stato di avanzamento

## VARIANTI
Il componente Progress Bar presenta le seguenti varianti:

* Una variante predefinita che visualizza una barra di avanzamento standard
* Una variante personalizzabile che consente all'utente di impostare la larghezza, l'altezza e il colore della barra

Casi d'uso specifici per ogni variante:

* La variante predefinita può essere utilizzata per visualizzare lo stato di avanzamento di un'operazione standard
* La variante personalizzabile può essere utilizzata per adattare la barra di avanzamento alle esigenze specifiche dell'applicazione

Breve descrizione per ogni variante:

* Variante predefinita: una barra di avanzamento standard che visualizza lo stato di completamento
* Variante personalizzabile: una barra di avanzamento personalizzabile che consente all'utente di impostare la larghezza, l'altezza e il colore

## BEST PRACTICES
Le seguenti sono alcune best practice per l'utilizzo del componente Progress Bar:

* Utilizzare il componente per fornire un feedback visivo chiaro sullo stato di avanzamento
* Personalizzare il componente per adattarlo alle esigenze specifiche dell'applicazione
* Evitare di utilizzare il componente in modo eccessivo o confuso

## COMPONENTI CORRELATI
Il componente Progress Bar può essere utilizzato in combinazione con altri componenti come:

* Button: per fornire un'azione che può essere eseguita quando la barra di avanzamento è completa
* Label: per fornire una descrizione del processo o dell'attività in corso

Relazioni con altri elementi:

* Il componente Progress Bar può essere utilizzato all'interno di un contenitore per fornire un feedback visivo sullo stato di avanzamento di un'operazione.

## OVERVIEW
<div class="table-responsive">`import { ProgressBarComponent } from '@inail/intranet-webkit/elements';`</div>

Componente personalizzato utilizzato per visualizzare una barra di progresso che indica il completamento di un processo, con diversi stati e stili visivi.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>label</code></td>
      <td>
          `@Input() label!: string;` <br />
          Campo di tipo stringa che imposta l'etichetta della ProgressBar.
      </td>
    </tr>
    <tr>
      <td><code>percent</code></td>
      <td>
          `@Input() percent!: number;` <br />
          Campo numerico che imposta la percentuale di completamento da visualizzare nella barra di progresso.
      </td>
    </tr>
    <tr>
      <td><code>status</code></td>
      <td>
          `@Input() status: undefined | 'error' | 'success' | 'warning';` <br />
          Campo che imposta lo stato della ProgressBar e modifica il colore di conseguenza.
      </td>
    </tr>
    <tr>
      <td><code>classProgress</code></td>
      <td>
          `@Input() classProgress!: ProgressBarPercent;` <br />
          Campo di tipo `ProgressBarPercent` che definisce il comportamento e l'aspetto della barra di progresso, utilizzando le costanti predefinite nella classe `ProgressBarPercent`. <br />
          `class ProgressBarPercent {
	public static PROGRESS_0 = new ProgressBarPercent(0);
	public static PROGRESS_25 = new ProgressBarPercent(25);
	public static PROGRESS_50 = new ProgressBarPercent(50);
	public static PROGRESS_75 = new ProgressBarPercent(75);
	public static PROGRESS_100_SUCCESS = new ProgressBarPercent(100, {status: 'success'});
	public static PROGRESS_100_ERROR = new ProgressBarPercent(100, {status: 'error'});

	public className: string;
	public success: boolean = false;

	public constructor(public value: number, opt?: { status?: 'error' | 'warning' | 'success', className?: string }) {
		        if (!opt || !opt.className) {
		        	this.className = 'bg-primary';
		        } else {
		        	this.className = opt.className;
		        }

		        if (opt && opt.status) {
		        	switch (opt.status) {
		        		case 'success':
		        			this.className = 'bg-success';
		        			break;
		        		case 'error':
		        			this.className = 'bg-danger';
		        			break;
		        		case 'warning':
		        			this.className = 'bg-warning';
		        			break;
		        	}
		        }
	}
}`
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
        `@Input()set size(pipes: string | BootstrapSize) {}` <br />
        Campo che imposta le dimensioni <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize</a> al componente.
      </td>
    </tr>
  </tbody>
</table>
</div>