# TableField

La classe **TableField** rappresenta un modello per definire i campi di una tabella. La sua struttura viene specificata attraverso un costruttore che accetta diversi parametri:

**TableField** viene utilizzato per costruire azioni custom tramite la struttura definita dal costruttore.

## Implementazione
<div class="table-responsive">`import { TableField} from '@inail/angular-core';`</div>
<br />

***Costruttore:***
`    constructor(
      label: string, 
      main: boolean, 
      fieldType: 'NORMAL' | 'NUMBER' | 'DATE' | 'PROGRESS' | 'STRING[]' | 'TRANSLATE', 
      propertyNameToUse: string, 
      sortable?: boolean, 
      dtoField?: string, 
      size?: any
  );
`

***Esempio d'uso:***
` const tableStructure = [
  new TableField('Colonna 1', true, 'NORMAL', 'name', false),
  new TableField('Colonna 2', false, 'NORMAL', 'size', false),
]`

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>label</code></td>
      <td>
        Una stringa obbligatoria che rappresenta l'etichetta del campo della tabella. È il nome visibile agli utenti.
      </td>
    </tr>
    <tr>
      <td><code>main</code></td>
      <td>
        Un valore booleano obbligatorio che indica se il campo è il principale nella tabella (ad esempio, la colonna primaria o più significativa).
      </td>
    </tr>
      <tr>
      <td><code>fieldType</code></td>
      <td>
        Un parametro obbligatorio che specifica il tipo di dato del campo. Può essere uno dei seguenti valori:
        <ul>
          <li>
            <code>NORMAL</code>: un campo generico.
          </li>
          <li>
           <code>NUMBER</code>: un campo numerico.
          </li>
          <li>
           <code>DATE</code>: un campo con dati di tipo data.
          </li>
          <li>
            <code>PROGRESS</code>: un campo che rappresenta un indicatore di progresso.
          </li>
          <li>
            <code>STRING[]</code>: un array di stringhe.
          </li>
          <li>
            <code>TRANSLATE</code>: un campo utilizzato per valori traducibili.
          </li>
        </ul>
        <code>fieldType = 'NORMAL' | 'NUMBER' | 'DATE' | 'PROGRESS' | 'STRING[]' | 'TRANSLATE'</code>
      </td>
    </tr>
    <tr>
      <td><code>propertyNameToUse</code></td>
      <td>
        Una stringa obbligatoria che rappresenta il nome della proprietà da utilizzare per mappare i dati.
      </td>
    </tr>
    <tr>
      <td><code>sortable</code></td>
      <td>
        Un valore booleano opzionale che specifica se il campo può essere ordinato all'interno della tabella.
      </td>
    </tr>
    <tr>
      <td><code>dtoField</code></td>
      <td>
        Una stringa opzionale che indica il nome del campo corrispondente in un Data Transfer Object (DTO).
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
        E' un parametro opzionale che rappresenta la dimensione del campo. Il tipo può variare a seconda
        delle esigenze.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br/>
<a href="?path=/story/components-table-simple--simple-table">Simple table</a>
<br/>
<a href="?path=/story/components-table-paginated--table-pagination">Paginated Table</a>
<br/>
<a href="?path=/story/components-form-tabellare--form-tabellare">Form Tabellare</a>