## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente sono:

* La possibilità di personalizzare il testo e le icone visualizzate sul pulsante
* La gestione degli eventi di clic e di cambiamento di stato
* La compatibilità con diverse tecnologie di accessibilità, come ARIA e screen reader

Gli aspetti tecnici rilevanti includono:

* L'utilizzo di HTML5 e CSS3 per la creazione del componente
* La gestione degli stati di disabilità e di caricamento tramite JavaScript

Le caratteristiche di accessibilità includono:

* La possibilità di utilizzare tasti di scelta rapida per attivare il pulsante
* La compatibilità con tecnologie di lettura dello schermo

## VARIANTI
Sono disponibili le seguenti varianti del componente:

### Variante 1: Pulsante di Azione Primario
Il pulsante di azione primario è utilizzato per eseguire l'azione principale all'interno di un'applicazione. È caratterizzato da un colore di sfondo blu e da un testo bianco.

* Caso d'uso: Utilizzare il pulsante di azione primario per eseguire l'azione di invio di un modulo.
* Descrizione breve: Pulsante di azione primario con colore di sfondo blu e testo bianco.

### Variante 2: Pulsante di Azione Secondario
Il pulsante di azione secondario è utilizzato per eseguire azioni secondarie all'interno di un'applicazione. È caratterizzato da un colore di sfondo grigio e da un testo nero.

* Caso d'uso: Utilizzare il pulsante di azione secondario per eseguire l'azione di annullamento di un modulo.
* Descrizione breve: Pulsante di azione secondario con colore di sfondo grigio e testo nero.

### Variante 3: Pulsante di Azione con Icona
Il pulsante di azione con icona è utilizzato per eseguire azioni specifiche all'interno di un'applicazione e visualizza un'icona al posto del testo. È caratterizzato da un colore di sfondo blu e da un'icona bianca.

* Caso d'uso: Utilizzare il pulsante di azione con icona per eseguire l'azione di condivisione di un contenuto.
* Descrizione breve: Pulsante di azione con icona e colore di sfondo blu.

## BEST PRACTICES
Le raccomandazioni d'uso del componente includono:

* Utilizzare il pulsante di azione primario per eseguire l'azione principale all'interno di un'applicazione.
* Utilizzare il pulsante di azione secondario per eseguire azioni secondarie all'interno di un'applicazione.
* Utilizzare il pulsante di azione con icona per eseguire azioni specifiche all'interno di un'applicazione e visualizzare un'icona al posto del testo.

Le linee guida implementative includono:

* Utilizzare HTML5 e CSS3 per la creazione del componente.
* Gestire gli eventi di clic e di cambiamento di stato tramite JavaScript.

Le pratiche da evitare includono:

* Utilizzare il pulsante di azione primario per eseguire azioni secondarie all'interno di un'applicazione.
* Utilizzare il pulsante di azione secondario per eseguire l'azione principale all'interno di un'applicazione.

## COMPONENTI CORRELATI
Il componente "Pulsante di Azione" è associato ai seguenti componenti:

* Form: Il pulsante di azione può essere utilizzato all'interno di un form per eseguire l'azione di invio.
* Lista: Il pulsante di azione può essere utilizzato all'interno di una lista per eseguire l'azione di selezione.

Le relazioni con altri elementi includono:

* Etichetta: Il pulsante di azione può essere utilizzato in combinazione con un'etichetta per fornire contesto all'utente.
* Icona: Il pulsante di azione può essere utilizzato in combinazione con un'icona per fornire ulteriori informazioni all'utente.