## CARATTERISTICHE PRINCIPALI

Il componente Tags presenta le seguenti caratteristiche chiave:

- Funzionalità di creazione di tag: il componente consente di creare nuovi tag e di mostrarli in modo visivo all'utente.
- Aspetti tecnici rilevanti: il componente è stato realizzato utilizzando tecnologie web standard e non richiede l'uso di librerie o framework aggiuntivi.
- Caratteristiche di accessibilità: il componente è stato progettato per essere accessibile a tutti gli utenti, indipendentemente dalle loro abilità.

## VARIANTI

Il componente Tags presenta le seguenti varianti:

- **Default**: la variante predefinita del componente, che consente di creare tag e mostrarli in modo visivo all'utente.
  - Caso d'uso: l'utente vuole inserire un nuovo tag per descrivere un contenuto.
  - Breve descrizione: il componente crea un nuovo tag con il testo inserito dall'utente e lo mostra in modo visivo.
- **N.D.**: non sono presenti altre varianti del componente.

## BEST PRACTICES

Le seguenti raccomandazioni d'uso possono aiutare a utilizzare al meglio Il componente Tags:

- Utilizzare il componente per creare tag che descrivono contenuti specifici.
- Assicurarsi di testare il componente con diverse combinazioni di input e output.

Le seguenti linee guida implementative possono aiutare a integrare il componente nella propria applicazione:

- Utilizzare le proprietà del componente per personalizzare l'aspetto e il comportamento dei tag.
- Assicurarsi di utilizzare gli eventi del componente per gestire le interazioni dell'utente.

Le seguenti pratiche da evitare possono aiutare a prevenire problemi comuni:

- Evitare di usare il componente per creare tag generici o irrilevanti rispetto al contenuto.
- Non modificare le proprietà del componente in modo arbitrario.

## COMPONENTI CORRELATI

Il componente Tags può essere utilizzato in combinazione con altri componenti per creare interfacce utente più complesse. Alcuni esempi di componenti correlati includono:

- **Tab**: il componente Tab può essere utilizzato per creare un'interfaccia utente a schede che include i tag creati con Il componente Tags.
- **N.D.**: non sono presenti altri componenti correlati.

## OVERVIEW

<div class="table-responsive">`import { TagComponent } from '@inail/intranet-webkit/elements';`</div>

Componente custom usato per creare dei tag che mostrano vari messaggi e notifiche.

## API

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>tag</code></td>
      <td>
          `@Input() set tag(tag: Tag) {
		this._tag = tag;
		if (tag) {
			  switch (tag.type) {
			  	case TagTypes.WARNING:
			  		this.icon = 'i-warning';
			  		break;
			  	case TagTypes.SUCCESS:
			  		this.icon = 'i-check_circle';
			  		break;
			  	case TagTypes.INFO:
			  		this.icon = 'i-info_outline';
			  		break;
			  	case TagTypes.DANGER:
			  		this.icon = 'i-error';
			  		break;
			  	default:
			  		this.icon = undefined;
			  }}}`
          Questo è un input di tipo <a href="?path=/docs/resources-models-tag--docs">Tag</a> che imposta il tipo del tag e crea il componente 
      </td>
    </tr>
  </tbody>
</table>
</div>