## CARATTERISTICHE PRINCIPALI
Il componente Form Section presenta le seguenti caratteristiche chiave:

* Funzionalità di raggruppamento: il componente consente di raggruppare campi e controlli relativi a una specifica categoria.
* Aspetti tecnici rilevanti: il componente utilizza una struttura HTML semantica per definire la sezione del form.
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile aiutando gli utenti con disabilità a navigare e compilare il form.

## VARIANTI
Il componente Form Section presenta le seguenti varianti:

* **Test della descrizione del form section**: questa variante presenta una descrizione dettagliata del componente.
* **INAIL Form Section**: questa variante è specificamente progettata per l'utilizzo nel contesto dell'INAIL.

Per ogni variante, i casi d'uso specifici sono:

* Utilizzare la variante "Test della descrizione del form section" quando si desidera fornire una descrizione dettagliata del componente.
* Utilizzare la variante "INAIL Form Section" quando si desidera utilizzare il componente nel contesto dell'INAIL.

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Form Section sono:

* Utilizzare il componente per raggruppare campi e controlli relativi a una specifica categoria.
* Fornire una descrizione dettagliata del componente quando necessario.
* Utilizzare la variante "INAIL Form Section" solo nel contesto dell'INAIL.

Le linee guida implementative sono:

* Utilizzare una struttura HTML semantica per definire la sezione del form.
* Assicurarsi che il componente sia accessibile aiutando gli utenti con disabilità a navigare e compilare il form.

Le pratiche da evitare sono:

* Non utilizzare il componente per raggruppare campi e controlli non relativi a una specifica categoria.
* Non omettere la descrizione dettagliata del componente quando necessario.

## COMPONENTI CORRELATI
Il componente Form Section è associato ai seguenti componenti:

* Form: il componente Form Section è una sezione di un form.
* Campi e controlli: il componente Form Section raggruppa campi e controlli relativi a una specifica categoria.

Le relazioni con altri elementi sono:

* Il componente Form Section può essere utilizzato all'interno di un form per organizzare i dati in modo logico e facile da utilizzare.
* Il componente Form Section può essere personalizzato per adattarsi alle esigenze specifiche dell'applicazione.


## OVERVIEW
<div class="table-responsive">`import { FormSectionComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente FormSectionComponent rappresenta una sezione di un modulo all'interno di un'applicazione Angular. Utilizza opzioni configurabili come title, name, formGroup e size, fornendo controlli personalizzati per esplorare le funzionalità del componente. Inoltre, incorpora moduli come WebkitModule e I18nModule per garantire compatibilità e localizzazione, mentre il layout è personalizzato tramite decoratori per presentare il componente in un contesto realistico.


## API
<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>title</code></td>
         <td>
            `@Input() title!: string;` <br />
            Titolo del form section.
         </td>
      </tr>
      <tr>
         <td><code>name</code></td>
         <td>
            `@Input() name = 'Form';` <br />
            Nome del form section.
         </td>
      </tr>
      <tr>
         <td><code>formGroup</code></td>
         <td>
            `@Input() formGroup: AbstractControl = new FormGroup({});` <br />
            Istanza FormGroup contenente controlli del modulo.
         </td>
      </tr>
      <tr>
         <td><code>size</code></td>
         <td>
            `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
            La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
         </td>
      </tr>
      <tr>
         <td><code>id</code></td>
         <td>
            `@Input() override id = composeUniqueId('form_section');` <br />
            La proprietà `id` nella classe `BasePageSection` rappresenta un identificatore univoco. Questo ID viene sovrascritto da BasePageSection.
         </td>
      </tr>
   </tbody>
</table>
</div>