## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave: il componente consente la selezione di una sola opzione tra un insieme di possibilità.
* Aspetti tecnici rilevanti: il componente è progettato per essere utilizzato all'interno di form e richiede l'uso di etichette e valori associati alle opzioni.
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile aiutando gli utenti con disabilità a navigare e selezionare le opzioni utilizzando la tastiera o altri dispositivi di input.

## VARIANTI

* **Input Radio**: questa variante rappresenta l'opzione standard del componente, che consente la selezione di una sola opzione tra un insieme di possibilità.
 + Caso d'uso: utilizzare quando è necessario fornire agli utenti una scelta binaria o multiple.
 + Descrizione breve: input radio per la selezione di una sola opzione.
* **Input Radio disabilitata**: questa variante rappresenta l'opzione del componente quando è disabilitata, non consentendo la selezione delle opzioni.
 + Caso d'uso: utilizzare quando è necessario mostrare le opzioni disponibili ma non consentire la selezione.
 + Descrizione breve: input radio disabilitata per mostrare le opzioni senza consentire la selezione.
* **Input Radio con errore**: questa variante rappresenta l'opzione del componente quando si verifica un errore, ad esempio se l'utente non ha selezionato alcuna opzione.
 + Caso d'uso: utilizzare quando è necessario mostrare un messaggio di errore per informare l'utente che la selezione non è valida.
 + Descrizione breve: input radio con errore per mostrare un messaggio di errore.
* **Input Radio con info**: questa variante rappresenta l'opzione del componente quando si desidera fornire ulteriori informazioni relative alle opzioni disponibili.
 + Caso d'uso: utilizzare quando è necessario fornire agli utenti ulteriori dettagli per aiutarli a prendere una decisione informata.
 + Descrizione breve: input radio con info per fornire ulteriori dettagli.

## BEST PRACTICES

* Utilizzare il componente Form Items Radio Button quando è necessario effettuare una scelta singola.
* Non utilizzare il componente per selezioni troppo lunghe o complesse. Per esempio, non può essere utilizzata un radio button per selezionare un paragrafo di testo.
* Assicurarsi di fornire etichette e valori associati alle opzioni per garantire l'accessibilità.
* Utilizzare la variante Input Radio disabilitata quando è necessario mostrare le opzioni disponibili ma non consentire la selezione.

## COMPONENTI CORRELATI

* Componenti di form: il componente Form Items Radio Button è spesso utilizzato all'interno di form per raccogliere informazioni dagli utenti.
* Etichette e valori associati: gli elementi etichetta e valore sono essenziali per garantire l'accessibilità del componente.