## CARATTERISTICHE PRINCIPALI

* **Funzionalità chiave**: La Tabella Responsiva offre funzionalità come l'ordinamento delle colonne, la possibilità di nascondere o visualizzare le colonne, e la gestione dei dati in modo responsivo.
* **Aspetti tecnici rilevanti**: Il componente utilizza tecniche di responsive design per adattarsi alle diverse risoluzioni dello schermo e dispositivi. Inoltre, è progettato per essere accessibile e conforme agli standard WCAG 2.1.
* **Caratteristiche di accessibilità**: La Tabella Responsiva include caratteristiche come la navigazione con tastiera, la gestione dei focus e la descrizione degli elementi tramite attributi ARIA.

## VARIANTI

* **Variante 1: Tabella Base**
	+ Descrizione: Questa variante rappresenta la forma di base della tabella, con funzionalità di ordinamento e visualizzazione delle colonne.
	+ Casi d'uso: Utilizzare questa variante per presentare dati semplici e non complessi.
* **Variante 2: Tabella con Filtraggio**
	+ Descrizione: Questa variante include la funzionalità di filtraggio dei dati, che consente agli utenti di selezionare specifiche colonne o righe per visualizzare solo i dati desiderati.
	+ Casi d'uso: Utilizzare questa variante per presentare grandi quantità di dati e fornire agli utenti la possibilità di filtrarli in modo efficiente.
* **Variante 3: Tabella con Azioni**
	+ Descrizione: Questa variante include la funzionalità di azioni aggiuntive, come l'eliminazione o la modifica dei dati, che possono essere eseguite direttamente dalla tabella.
	+ Casi d'uso: Utilizzare questa variante per presentare dati complessi e fornire agli utenti la possibilità di interagire con essi in modo più avanzato.

## BEST PRACTICES

* **Raccomandazioni d'uso**: Utilizzare la Tabella Responsiva per presentare dati tabellari complessi, ma evitare di utilizzarla per presentare grandi quantità di testo o immagini.
* **Linee guida implementative**: Assicurarsi di utilizzare gli attributi ARIA per descrivere gli elementi della tabella e fornire una buona esperienza utente per gli utenti con disabilità.
* **Pratiche da evitare**: Evitare di utilizzare la Tabella Responsiva per presentare dati non strutturati o non tabellari, poiché ciò può creare confusione e difficoltà per gli utenti.

## COMPONENTI CORRELATI

* **Componenti associati**: La Tabella Responsiva può essere utilizzata in combinazione con altri componenti come la Paginazione e il Filtraggio per fornire una soluzione completa per la gestione dei dati.
* **Relazioni con altri elementi**: La Tabella Responsiva è progettata per lavorare in armonia con gli altri elementi della pagina, come i pulsanti e le etichette, per fornire una esperienza utente coerente e accessibile.

## ACCESSIBILITA'
Usare le tabelle esclusivamente per dati tabellari, utilizzando gli attributi alt e caption, th, scope, tr e td; usare l'elemento `<caption>` per associare didascalie a tabelle di dati. Tutte le icone presenti nelle tabelle devono essere corredate di un testo alternativo sotto forma di tooltip accessibile sia con il mouse che da tastiera che ne descriva la funzionalità.

Tabelle con colonne ordinabili:
Si segnala un bug di accessbilità nella libreria datatables.js. Lo screen reader, interagendo con il pulsante di ordinamento, legge anche il `<title>` della pagina. Il focus sul pulsante viene quindi forzato tramite dataTablesEdit.js. Lo screen reader in alcuni casi ripete l'istruzione una seconda volta. Non è possibile correggere il bug in questa versione.

## CODICE
Per l'utilizzo di funzionalità complesse come l'ordinamento delle righe, la paginazione, la scelta del numero di elementi da visualizzare ed i filtri viene utilizzata la libreria JQuery DataTables. La relativa documentazione si trova a questo [link](https://datatables.net/).

Per un corretto funzionamento é necessario includere le librerie: dataTables.bootstrap.min.css, jquery.dataTables.min.js, dataTables.bootstrap.min.js e dataTablesEdit.js.
L'attivazione delle funzionalità e la definizione dei componenti nelle tabelle DataTables sono da impostare in dataTablesEdit.js.

La risoluzione per il comportamento responsive della TABELLA SEMPLICE RESPONSIVE ALTERNATIVA é fissata a 800px (punto di collasso). Per personalizzare tale valore é possibile modificare la query string relativa al tag `<table>` aggiungendo una nuova classe e sovrascrivendola con una nuova regola.
