## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente InputNumberComponent sono:

* L'utilizzo di un campo di testo per l'inserimento dei dati numerici
* La gestione degli eventi di input per validare e formattare i dati inseriti
* La possibilità di impostare un valore predefinito per il campo

Gli aspetti tecnici rilevanti del componente Input Number includono:

* L'utilizzo di HTML, CSS e JavaScript per la sua implementazione
* La compatibilità con diversi browser e dispositivi

Le caratteristiche di accessibilità del componente Input Number includono:

* La possibilità di utilizzare la tastiera per navigare e inserire dati
* La conformità agli standard WCAG 2.1 per l'accessibilità web

## VARIANTI

Le varianti disponibili per il componente Input Number sono:

* **Test della descrizione dell'input number**: una variante che include un testo descrittivo per aiutare gli utenti a comprendere lo scopo del campo.
* **INAIL Input Number**: una variante personalizzata con stile e layout specifici.

Casi d'uso specifici per ogni variante:

* **Test della descrizione dell'input number**: utilizzare questo tipo di variante quando è necessario fornire un contesto aggiuntivo agli utenti per aiutarli a comprendere lo scopo del campo.
* **INAIL Input Number**: utilizzare questo tipo di variante quando si desidera un layout e uno stile personalizzati.

Breve descrizione per ogni variante:

* **Test della descrizione dell'input number**: un campo di testo con una descrizione per aiutare gli utenti a comprendere lo scopo del campo.
* **INAIL Input Number**: un campo di testo personalizzato con stile e layout specifici.

## BEST PRACTICES

Raccomandazioni d'uso:

* Utilizzare il componente Input Number quando è necessario raccogliere dati numerici dagli utenti.
* Fornire contesto aggiuntivo agli utenti per aiutarli a comprendere lo scopo del campo.

Linee guida implementative:

* Utilizzare HTML, CSS e JavaScript per l'implementazione del componente.
* Assicurarsi che il componente sia accessibile e conforme agli standard WCAG 2.1.

Pratiche da evitare:

* Non utilizzare il componente Input Number per raccogliere dati non numerici.
* Evitare di utilizzare stili e layout personalizzati che possano compromettere l'accessibilità del componente.

## COMPONENTI CORRELATI

Componenti associati:

* Campo di testo
* Etichetta

Relazioni con altri elementi:

* Il componente Input Number può essere utilizzato in combinazione con altri componenti, come ad esempio i pulsanti o le liste a discesa, per creare form più complessi.

## OVERVIEW
<div class="table-responsive">`import { InputNumberComponent } from '@inail/intranet-webkit/form-controls';`</div>

Il componente `InputNumberComponent` è progettato per offrire un controllo numerico flessibile e configurabile.
Supporta funzionalità avanzate come messaggi di supporto, validazioni, tooltip e gestione di classi CSS personalizzate.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th><strong>Campo</strong></th>
	  <th><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>BaseInputComponent controls</code></td>
	  <td>
		`class InputNumberComponent extends BaseInputComponent` <br />
		La classe InputNumberComponent estende <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
	  </td>
	</tr>
	<tr>
		<td><code>size</code></td>
		<td>
		    `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
			La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
		</td>
	</tr>
  </tbody>
</table>
</div>