## OVERVIEW

`import { ActionsDropdownComponent } from '@inail/internet-webkit/buttons';`


L'ActionDropdownComponent è un componente che consente di visualizzare un menu a discesa di azioni personalizzabili. È particolarmente utile per gestire un elenco di operazioni associate a un elemento o a un contesto specifico, con un'interfaccia flessibile e facilmente configurabile.

Il componente supporta funzionalità avanzate come la limitazione del numero massimo di azioni visibili, l'aggiunta di classi personalizzate e la gestione dei tooltip, rendendolo un'ottima soluzione per contesti dinamici e complessi.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>isModal</code></td>
      <td> <code>@Input() isModal = false;</code><br /> Booleano che specifica se il componente è utilizzato all'interno di un contesto modale.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>tooltipPlacement</code></td>
      <td> <code>@Input() tooltipPlacement: TooltipPlaceType = TooltipPlacementEnum.LEFT;</code><br /> Specifica la posizione del tooltip rispetto all'azione. Il valore predefinito è <code>LEFT</code>. 
      <br />
      <ul>
      <li><a href="?path=/docs/resources-models-tooltipplacetype--docs">TooltipPlaceType</a></li>
      <li><a href="?path=/docs/resources-models-tooltipplacementenum--docs">TooltipPlacementEnum</a></li>
      </ul> </td>
    </tr>
    <tr>
    <tr>
      <td><code>id</code></td>
      <td> <code>@Input() id = composeUniqueId('action_dropdown');</code><br /> Identificativo univoco generato per il menu a discesa. Può essere personalizzato fornendo un valore specifico. </td>
    </tr>
    <tr>
      <td><code>model</code></td>
      <td> <code>@Input() model: any;</code><br /> Modello di dati associato al menu a discesa. Fornisce informazioni contestuali per personalizzare le azioni. </td>
    </tr>
    <tr>
      <td><code>maxAction</code></td>
      <td> <code>@Input() maxAction = 4;</code><br /> Numero massimo di azioni visibili nel menu prima di mostrare un'icona o un'opzione per visualizzare altre azioni.<br /> Valore predefinito: <code>4</code>. </td>
    </tr>
    <tr>
      <td><code>extraClass</code></td>
      <td> <code>@Input() extraClass!: string;</code><br /> Classe CSS aggiuntiva per personalizzare lo stile del menu a discesa. </td>
    </tr>
    <tr>
      <td><code>labeledMenu</code></td>
      <td> <code>@Input() labeledMenu = false;</code><br /> Booleano che indica se il menu a discesa include etichette descrittive accanto alle icone delle azioni.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td><code>@Input('actions') set calculateActionForRow(actionsInput: ActionItem[])  {...}</code><br /> Elenco di azioni configurabili per il menu a discesa. Le azioni vengono calcolate dinamicamente per ogni riga o contesto specifico.<br />
          <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. </td>
    </tr>
  </tbody>
</table>
</div>

<br />
<br />

<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
      <td><code>focusOut</code></td>
      <td> <code>@Output() focusOut = new EventEmitter&lt;null&gt;;</code><br /> Evento emesso quando il componente perde il focus. Può essere utilizzato per gestire comportamenti personalizzati durante l'interazione con il dropdown. </td>
    </tr>
 </tbody>
 </table>
 </div>
