# TooltipModel

Documentazione dettagliata dell'oggetto custom **TooltipModel**, usato nei componenti di Intranet Webkit v17. 
**TooltipModel** è una classe che definisce la struttura e le configurazioni di un tooltip, permettendo di personalizzarne il contenuto (testo o template), il titolo opzionale e i parametri per l'internazionalizzazione (i18n).

## Implementazione
<div class="table-responsive">`import {TooltipModel} from '@inail/intranet-webkit'`</div>
<br />

***Struttura:***
`constructor(
  content: string | TemplateRef<any>,
  opts?: TooltipModelOptions
)
`


***Esempio d'uso:***
<br />
`  tooltip: new TooltipModel(
    'This is a tooltip message', //content
    {
      title: 'Tooltip', //title
    }
  ) `

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>content</code></td>
      <td>
        Definisce il contenuto principale del tooltip. <br>
        Tipo:
        <ul>
          <li>
            string: Un semplice messaggio di testo da visualizzare nel tooltip.
          </li>
          <li>
            <code>TemplateRef&lt;any&gt;</code>: Permette di utilizzare un template Angular personalizzato per visualizzare dinamicamente il contenuto del tooltip.
          </li>
        </ul>
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Titolo opzionale del tooltip, che può fornire un contesto aggiuntivo o fungere da intestazione.
      </td>
    </tr>
    <tr>
      <td><code>i18params</code></td>
      <td>
        Parametro opzionale per l'internazionalizzazione (i18n).
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-form-form-controls-checkbox--checkbox">Checkbox</a>
<br/>
<a href="?path=/story/components-form-form-controls-combobox--combobox">Combobox</a>
<br/>
<a href="?path=/story/components-form-form-controls-currency--currency">Input Currency</a>
<br/>
<a href="?path=/story/components-form-form-controls-date--date">Input Date</a>
<br/>
<a href="?path=/story/components-form-form-controls-double-date--double-date">Input Double Date</a>
<br/>
<a href="?path=/story/components-form-form-controls-input--input">Input</a>
<br/>
<a href="?path=/story/components-form-form-controls-multiple-select--multiple-select">Multi Select</a>
<br/>
<a href="?path=/story/components-form-form-controls-number--input-number">Number</a>
<br/>
<a href="?path=/story/components-form-form-controls-number-interval--input-number-interval">Number Interval</a>
<br/>
<a href="?path=/story/components-form-form-controls-radio--radio">Radio</a>
<br/>
<a href="?path=/story/components-form-form-controls-select--select">Select</a>
<br/>
<a href="?path=/story/components-form-form-controls-single-checkbox--single-checkbox">Single Checkbox</a>
<br/>
<a href="?path=/story/components-form-form-controls-textarea--text-area">Text Area</a>
<br/>
<a href="?path=/story/components-form-form-sections-input-label--input-label">Label</a>
<br/>
<a href="?path=/story/components-form-form-sections-tooltip--tooltip">Tooltip</a>
<br/>
