## CARATTERISTICHE PRINCIPALI
- **Funzionalità chiave**: il componente Input consente agli utenti di inserire testo, selezionare opzioni da un elenco e visualizzare messaggi di aiuto o errori.
- **Aspetti tecnici rilevanti**: il componente Input utilizza proprietà come `value`, `size-input` e `externalClass` per personalizzare l'aspetto e il comportamento del campo di testo.
- **Caratteristiche di accessibilità**: il componente Input include proprietà come `labelSrOnly` e `asteriskReplacedToSR` per migliorare l'accessibilità per gli utenti con disabilità.

## VARIANTI
- **Variante 1: Input di base**: questa variante rappresenta un campo di testo standard senza opzioni aggiuntive.
- **Variante 2: Input con label**: questa variante include un'etichetta che descrive il campo di testo.
- **Variante 3: Input con messaggio di aiuto**: questa variante include un messaggio di aiuto che fornisce ulteriori informazioni sugli utenti.
- **Variante 4: Input con opzioni**: questa variante consente agli utenti di selezionare opzioni da un elenco.

## BEST PRACTICES
- **Raccomandazioni d'uso**: utilizzare il componente Input per raccogliere informazioni dagli utenti e fornire un' interfaccia utente per l'inserimento di testo.
- **Linee guida implementative**: utilizzare proprietà come `value` e `size-input` per personalizzare l'aspetto e il comportamento del campo di testo.
- **Pratiche da evitare**: non utilizzare il componente Input per scopi diversi dalla raccolta di informazioni dagli utenti.

## COMPONENTI CORRELATI
- **Componenti associati**: il componente Input può essere utilizzato in combinazione con altri componenti come Button e Select.
- **Relazioni con altri elementi**: il componente Input può essere utilizzato all'interno di form o moduli per raccogliere informazioni dagli utenti.


## OVERVIEW
<div class="table-responsive">`import { InputComponent } from '@inail/internet-webkit/form-controls';`</div>
Il componente InputComponent è un campo di input avanzato, progettato per garantire flessibilità, accessibilità e personalizzazione. Supporta funzionalità come la gestione dinamica delle validazioni con FormControl, il dimensionamento configurabile tramite opzioni Bootstrap e l'integrazione di tooltip contestuali per migliorare l'usabilità. Inoltre, offre strumenti per l'accessibilità, come il supporto ai lettori di schermo, e consente di personalizzare etichette e messaggi di errore per un'esperienza utente ottimale.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>maxlength</code></td>
      <td>
        `@Input() maxlength: any;` <br />
        Numero massimo di caratteri consentiti nell'input.
      </td>
    </tr>
    <tr>
      <td><code>externalClass</code></td>
      <td>
        `@Input() externalClass = '';` <br />
        Classe CSS esterna per lo stile personalizzato.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputComboboxComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>