## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Callback Button includono:

* **onClick**: un evento emitter output che gestisce il click event
* **buttonType**: un attributo che assegna il tipo di bottone (ad esempio, "button" o "submit")
* **size**: un attributo che assegna la dimensione del bottone (ad esempio, "md", "sm" o "lg")
* **color**: un attributo che assegna il colore del bottone (ad esempio, "primary", "secondary" o "success")

Gli aspetti tecnici rilevanti includono:

* La compatibilità con Angular e altri framework JavaScript
* La possibilità di personalizzare l'aspetto e il comportamento del bottone utilizzando CSS e classi aggiuntive

Le caratteristiche di accessibilità includono:

* La presenza di attributi ARIA per migliorare la fruibilità per gli utenti con disabilità
* La possibilità di configurare il bottone per soddisfare le esigenze di accessibilità specifiche

## VARIANTI

Le varianti disponibili del componente Callback Button includono:

* **Base**: la variante di base del bottone, senza personalizzazioni aggiuntive
* **Disabled**: una variante disabilitata del bottone, che non può essere cliccato
* **Link**: una variante del bottone che appare come un collegamento ipertestuale

Casi d'uso specifici per ogni variante includono:

* Utilizzare la variante Base per creare un bottone standard con funzionalità di base
* Utilizzare la variante Disabled per creare un bottone disabilitato che non può essere cliccato
* Utilizzare la variante Link per creare un bottone che appare come un collegamento ipertestuale

## BEST PRACTICES

Le raccomandazioni d'uso del componente Callback Button includono:

* Utilizzare il componente in contesti dove è necessario gestire le interazioni dell'utente in modo flessibile e personalizzabile
* Configurare il bottone per soddisfare le esigenze di accessibilità specifiche
* Utilizzare CSS e classi aggiuntive per personalizzare l'aspetto e il comportamento del bottone

Le linee guida implementative includono:

* Utilizzare il componente in combinazione con altri elementi dell' interfaccia utente per creare un'esperienza utente coerente
* Testare il componente per garantire che funzioni correttamente in diversi contesti e dispositivi

Le pratiche da evitare includono:

* Utilizzare il componente in modo non accessibile o non conforme alle linee guida di progettazione dell'interfaccia utente
* Evitare di pubblicare il componente senza test approfonditi

## COMPONENTI CORRELATI

I componenti associati al Callback Button includono:

* Altri elementi dell' interfaccia utente, come pulsanti e collegamenti ipertestuali
* Framework e librerie JavaScript che supportano la gestione delle interazioni dell'utente

Le relazioni con altri elementi includono:

* La possibilità di utilizzare il componente in combinazione con altri elementi per creare un'esperienza utente coerente
* La necessità di configurare il componente per lavorare correttamente con altri elementi e tecnologie.

## OVERVIEW
<div class="table-responsive">`import { CallbackButtonComponent } from '@inail/internet-webkit/buttons';`</div>

Il CallbackButtonComponent è un'estensione del componente ButtonComponent, progettata per gestire pulsanti che eseguono logiche personalizzate tramite callback. Questo componente eredita tutte le funzionalità di base del ButtonComponent, aggiungendo una gestione semplificata e ottimizzata per l'invocazione di funzioni di callback al clic del pulsante.

Il CallbackButtonComponent è ideale in contesti in cui è necessario associare rapidamente un'azione programmata a un pulsante senza gestire manualmente gli eventi nell'HTML o nel componente principale.


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
        <td><code>model</code></td>
        <td> <code>@Input() model!: BaseModel;</code><br /><a href="?path=/docs/resources-models-basemodel--docs">BaseModel</a> è un modello associato all'azione. Fornisce dati dinamici al componente, rendendolo contestualmente sensibile. </td>
      </tr>
    <tr>
      <td><code>extId</code></td>
      <td> <code>@Input('ext-id') extId: string = composeUniqueId();</code><br /> Identificativo esterno univoco generato automaticamente. Può essere personalizzato. </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td><code>_title = 'INSERT TITLE PROPERTY';</code><br /> <code>@Input() set title(title: string) {...}</code><br /> Titolo del pulsante. Viene utilizzato per generare un ID univoco sostituendo gli spazi con underscore.<br /> Valore di default: <code>'INSERT TITLE PROPERTY'</code>. </td>
    </tr>
    <tr>
      <td><code>id</code></td>
      <td> <code>@Input() id!: string;</code><br /> Identificativo personalizzato del pulsante. Può essere sovrascritto per fornire un valore specifico. </td>
    </tr>
    <tr>
      <td><code>icon</code></td>
      <td> <code>@Input() icon!: string | string[];</code><br /> Icona da visualizzare nel pulsante. Supporta stringhe o array di stringhe per configurazioni avanzate. </td>
    </tr>
    <tr>
      <td><code>iconRight</code></td>
      <td> <code>@Input('icon-right') iconRight!: string;</code><br /> Icona visualizzata sul lato destro del pulsante. </td>
    </tr>
    <tr>
      <td><code>isLink</code></td>
      <td> <code>@Input() isLink = false;</code><br /> Booleano che determina se il pulsante si comporta come un collegamento (link).<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>sizeButton</code></td>
      <td> <code>@Input('size') sizeButton = 'md';</code><br /> Dimensione del pulsante. Valori supportati: <code>'sm'</code>, <code>'md'</code>, <code>'lg'</code>.<br /> Valore predefinito: <code>'md'</code>. </td>
    </tr>
    <tr>
      <td><code>colorButton</code></td>
      <td> <code>@Input('color') colorButton = 'primary';</code><br /> Colore del pulsante. Valori supportati: <code>'primary'</code>, <code>'secondary'</code>, <code>'danger'</code>, ecc.<br /> Valore predefinito: <code>'primary'</code>. </td>
    </tr>
    <tr>
      <td><code>extClass</code></td>
      <td> <code>@Input('ext-class') extClass = '';</code><br /> Classe CSS aggiuntiva per personalizzare lo stile del pulsante. </td>
    </tr>
    <tr>
      <td><code>disabledButton</code></td>
      <td> <code>@Input('disabled') disabledButton!: boolean;</code><br /> Booleano che abilita o disabilita il pulsante: se impostato su <code>true</code>, il pulsante è disattivato. </td>
    </tr>
    <tr>
      <td><code>hideLabel</code></td>
      <td> <code>@Input() hideLabel = false;</code><br /> Booleano che determina se l'etichetta del pulsante viene nascosta.<br /> Valore predefinito: <code>false</code>. </td>
    </tr>
    <tr>
      <td><code>buttonType</code></td>
      <td> <code>@Input() buttonType = 'button';</code><br /> Tipo di pulsante HTML. Valori supportati: <code>'button'</code>, <code>'submit'</code>, <code>'reset'</code>.<br /> Valore predefinito: <code>'button'</code>. </td>
    </tr>
    <tr>
      <td><code>description</code></td>
      <td> <code>@Input() description: string | null = null;</code><br /> Descrizione opzionale per il pulsante, utile per tooltip o accessibilità. </td>
    </tr>
    <tr>
      <td><code>label</code></td>
      <td> <code>@Input() label: string | null = null;</code><br /> Etichetta del pulsante visualizzata accanto all'icona. </td>
    </tr>
  </tbody>
</table>
</div>

<br />
<br />

<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
  <tr>
      <td><code>onClick</code></td>
      <td> <code>@Output() onClick: EventEmitter&lt;Event&gt;;</code><br /> Evento emesso quando il pulsante viene cliccato. </td>
    </tr>
    <tr>
      <td><code>click</code></td>
      <td> <code>@Output() click: EventEmitter&lt;Event&gt; = new EventEmitter();</code><br /> Evento emesso al clic sul pulsante. Sinonimo di <code>onClick</code>. </td>
    </tr>
 </tbody>
 </table>
 </div>