"use strict";(self.webpackChunkcustom_webkit_material=self.webpackChunkcustom_webkit_material||[]).push([[7953],{"./src/stories/form/input-field.stories.ts":(__unused_webpack_module,__webpack_exports__,__webpack_require__)=>{__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{CampiInput:()=>CampiInput,CampiInputDisabled:()=>CampiInputDisabled,CampiInputError:()=>CampiInputError,CampiInputInfo:()=>CampiInputInfo,__namedExportsOrder:()=>__namedExportsOrder,default:()=>__WEBPACK_DEFAULT_EXPORT__});var _storybook_angular__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__("./node_modules/@storybook/angular/dist/index.mjs"),_app_form_campi_input_input_field_input_field_component__WEBPACK_IMPORTED_MODULE_1__=__webpack_require__("./src/app/form/campi-input/input-field/input-field.component.ts"),_angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_9__=__webpack_require__("./node_modules/@angular/platform-browser/fesm2022/animations.mjs"),_app_form_campi_input_disabled_input_field_disabled_input_field_component__WEBPACK_IMPORTED_MODULE_2__=__webpack_require__("./src/app/form/campi-input/disabled-input-field/disabled-input-field.component.ts"),_app_form_campi_input_error_input_field_error_input_field_component__WEBPACK_IMPORTED_MODULE_3__=__webpack_require__("./src/app/form/campi-input/error-input-field/error-input-field.component.ts"),_app_form_campi_input_tooltip_input_field_tooltip_input_field_component__WEBPACK_IMPORTED_MODULE_4__=__webpack_require__("./src/app/form/campi-input/tooltip-input-field/tooltip-input-field.component.ts"),_common_shared_Utilities__WEBPACK_IMPORTED_MODULE_10__=__webpack_require__("./src/common/shared/Utilities.ts"),_app_form_campi_input_input_field_number_input_field_number_component__WEBPACK_IMPORTED_MODULE_5__=__webpack_require__("./src/app/form/campi-input/input-field-number/input-field-number.component.ts"),_angular_common__WEBPACK_IMPORTED_MODULE_8__=__webpack_require__("./node_modules/@angular/common/fesm2022/common.mjs"),_app_form_campi_input_input_field_currency_input_field_currency_component__WEBPACK_IMPORTED_MODULE_6__=__webpack_require__("./src/app/form/campi-input/input-field-currency/input-field-currency.component.ts"),_app_form_campi_input_input_field_number_range_input_number_range_component__WEBPACK_IMPORTED_MODULE_7__=__webpack_require__("./src/app/form/campi-input/input-field-number-range/input-number-range.component.ts");const __WEBPACK_DEFAULT_EXPORT__={title:"Componenti/Form Items/Campi input",tags:["autodocs"],parameters:{note:[{id:0,title:"Mat Form Field: Configurazione Necessaria",subtitle:"Per garantire una corretta visualizzazione e il funzionamento del componente `mat-form-field`, è necessario configurare le seguenti proprietà:",noteList:["**appearance=\"fill\"**: Questo attributo imposta lo stile del campo in modo che riempia lo spazio disponibile, migliorando l'estetica e l'usabilità del form. L'impostazione fill consente di creare un bordo continuo che circonda il campo, rendendolo visivamente accattivante e coerente con altri campi simili.","**[floatLabel]=\"'always'\"**: Questa proprietà controlla il comportamento dell'etichetta del campo (label). Assegnando il valore 'always', l'etichetta rimane sempre visibile al di sopra del campo, anche quando il campo è vuoto. Questo aiuta a fornire chiarezza all'utente sul contenuto richiesto."]}],docMaterial:[{nome:"Form Field",url:"https://v17.material.angular.io/components/form-field/overview"},{nome:"Input",url:"https://v17.material.angular.io/components/input/overview"}],accessibility:"Una volta inserito del testo nel campo di input il placeholder scompare dalla schermata e non sarà più letto \ndallo screen reader, si consiglia quindi di non inserire nel placeholder informazioni indispensabili per l’utente e \ndi limitare il suo utilizzo all’inserimento di esempi. \nInoltre, si consiglia di inserire un placeholder solo se può essere realmente utile per l’utente. Per esempio, \ninserire un placeholder “Inserire il nome” dentro un campo “Nome” non è utile per l’utente e sarà ridondante \nper chi utilizza uno SR."},decorators:[(0,_storybook_angular__WEBPACK_IMPORTED_MODULE_0__.moduleMetadata)({declarations:[],imports:[_app_form_campi_input_input_field_input_field_component__WEBPACK_IMPORTED_MODULE_1__._,_angular_common__WEBPACK_IMPORTED_MODULE_8__.CurrencyPipe,_app_form_campi_input_disabled_input_field_disabled_input_field_component__WEBPACK_IMPORTED_MODULE_2__.C,_app_form_campi_input_error_input_field_error_input_field_component__WEBPACK_IMPORTED_MODULE_3__.i,_app_form_campi_input_tooltip_input_field_tooltip_input_field_component__WEBPACK_IMPORTED_MODULE_4__.V,_angular_platform_browser_animations__WEBPACK_IMPORTED_MODULE_9__.BrowserAnimationsModule,_app_form_campi_input_input_field_number_input_field_number_component__WEBPACK_IMPORTED_MODULE_5__.X,_angular_common__WEBPACK_IMPORTED_MODULE_8__.CommonModule,_app_form_campi_input_input_field_currency_input_field_currency_component__WEBPACK_IMPORTED_MODULE_6__.B,_app_form_campi_input_input_field_number_range_input_number_range_component__WEBPACK_IMPORTED_MODULE_7__.K]}),(Story,context)=>((0,_common_shared_Utilities__WEBPACK_IMPORTED_MODULE_10__.dK)(Story,context,1,["https://cdn.inailcloud.it/assets/inail/u.1.0/static-webkit/js/custom-webkit.js"],!1),Story()),(0,_storybook_angular__WEBPACK_IMPORTED_MODULE_0__.componentWrapperDecorator)(story=>`<main id="contenutoprincipale">${story}</main>`)]},CampiInput={name:"Campo di input con testo",argTypes:{etichetta:{control:"text",description:"Specifica l'etichetta visualizzata sopra l'input del testo",defaultValue:{summary:"Etichetta del campo"}}},args:{etichetta:"Etichetta del campo"},parameters:{transformersHtml:[{type:"replace",keyToReplace:"{{etichetta}}",stringToAdd:"{{etichetta}}",argName:"etichetta"}],htmlCode:'<div class="row">\n    <div class="col-sm-4">\n        <mat-form-field appearance="fill" [floatLabel]="\'always\'">\n            <div class="inail-mat-label-container">\n                <mat-label class="inail-mat-label" id="input1-label">{{etichetta}}\n                </mat-label>\n            </div>\n            <input matInput placeholder="Placeholder" type="text" aria-labelledby="input1-label">\n        </mat-form-field>\n    </div>\n</div>',tsCode:"import { Component, Input } from '@angular/core';\n        import {MatInputModule} from '@angular/material/input';\n        import {MatFormFieldModule} from '@angular/material/form-field';\n        @Component({\n          selector: 'app-input-field',\n          standalone: true,\n          imports: [MatFormFieldModule, MatInputModule],\n          templateUrl: './input-field.component.html',\n          styleUrl: './input-field.component.scss'\n        })\n        export class InputFieldComponent {\n        }\n        \n        "},render:args=>({props:args,template:"<app-input-field [etichetta]='etichetta'></app-input-field>"})},CampiInputDisabled={name:"Campo di input di testo disabilitato",argTypes:{etichetta:{control:"text",description:"Specifica l'etichetta visualizzata sopra l'input del testo",defaultValue:{summary:"Etichetta del campo"}},disabilitato:{control:"boolean",description:"Imposta l'input del testo come disabilitato",defaultValue:{summary:!0}}},args:{etichetta:"Etichetta del campo",disabilitato:!0},parameters:{transformersHtml:[{type:"replace",keyToReplace:"{{etichetta}}",stringToAdd:"{{etichetta}}",argName:"etichetta"}],transformersTs:[{type:"replace",keyToReplace:"{{disabilitato}}",stringToAdd:"{{disabilitato}}",argName:"disabilitato"}],htmlCode:'<div class="row">\n    <div class="col-sm-4">\n        <mat-form-field appearance="fill" [floatLabel]="\'always\'">\n            <div class="inail-mat-label-container">\n                <mat-label class="inail-mat-label" id="input2-label">{{etichetta}}\n                </mat-label>\n            </div>\n            <input matInput placeholder="Placeholder" [disabled]="disabilitato" aria-labelledby="input2-label">\n        </mat-form-field>\n    </div>\n</div>',tsCode:"import { Component, Input } from '@angular/core';\n        import { MatInputModule } from '@angular/material/input';\n        import { MatFormFieldModule } from '@angular/material/form-field';\n        \n        @Component({\n          selector: 'app-disabled-input-field',\n          standalone: true,\n          imports: [MatInputModule, MatFormFieldModule],\n          templateUrl: './disabled-input-field.component.html',\n          styleUrl: './disabled-input-field.component.scss'\n        })\n        export class DisabledInputFieldComponent {\n        disabilitato:boolean={{disabilitato}};\n        }\n        \n        "},render:args=>({props:args,template:"<app-disabled-input-field [etichetta]='etichetta' [disabilitato]='disabilitato'></app-disabled-input-field>"})},CampiInputError={name:"Campo di input di testo con errore",argTypes:{etichetta:{control:"text",description:"Specifica l'etichetta visualizzata sopra l'input del testo",defaultValue:{summary:"Etichetta del campo"}},inErrore:{control:"boolean",description:"Simula l'errore nell'input",defaultValue:{summary:!0}},messaggioErrore:{control:"text",description:"Visualizza un messaggio di errore sotto l'input del testo",defaultValue:{summary:"Messaggio d'errore"}}},args:{etichetta:"Etichetta del campo",inErrore:!0,messaggioErrore:"Messaggio d'errore"},render:args=>({props:args,template:"<app-error-input-field [etichetta]='etichetta' [inErrore]='inErrore' [messaggioErrore]='messaggioErrore'></app-error-input-field>"}),parameters:{transformersTs:[{type:"replace",keyToReplace:"{{messaggioErrore}}",stringToAdd:"{{messaggioErrore}}",argName:"messaggioErrore"}],transformersHtml:[{type:"replace",keyToReplace:"{{etichetta}}",stringToAdd:"{{etichetta}}",argName:"etichetta"}],htmlCode:'<div class="row">\n  <div class="col-sm-4">\n    <mat-form-field appearance="fill" [floatLabel]="\'always\'">\n      <div class="inail-mat-label-container">\n        <mat-label class="inail-mat-label" id="input3-label">{{etichetta}}\n        </mat-label>\n      </div>\n      <input matInput placeholder="Placeholder" [formControl]="email" required\n        type="text" aria-labelledby="input3-label">\n      @if (email.invalid) {\n      <mat-error>\n        <span>\n          <i class="fa-solid fa-circle-exclamation"></i>\n          {{messaggioErrore}}\n        </span><br>\n      </mat-error>\n      }\n    </mat-form-field>\n  </div>\n</div>',tsCode:"import { Component } from '@angular/core';\n          import { FormControl, FormGroup, FormsModule, ReactiveFormsModule, Validators } from '@angular/forms';\n        import { MatInputModule } from '@angular/material/input';\n        import { MatFormFieldModule } from '@angular/material/form-field';\n\n        @Component({\n          selector: 'app-error-input-field',\n          standalone: true,\n          imports: [MatFormFieldModule, MatInputModule, FormsModule, ReactiveFormsModule],\n          templateUrl: './error-input-field.component.html',\n          styleUrl: './error-input-field.component.scss'\n        })\n        export class ErrorInputFieldComponent {\n         messaggioErrore: string = \"{{messaggioErrore}}\";\n          email = new FormControl('',Validators.required);  \n        }\n        \n        "}},CampiInputInfo={name:"Campo di input con tasto di info",argTypes:{etichetta:{control:"text",description:"Specifica l'etichetta visualizzata sopra l'input del testo",defaultValue:{summary:"LABEL"}},info:{control:"boolean",description:"Mostra un'icona informativa accanto al input del testo",defaultValue:{summary:!0}},messaggioHelper:{control:"text",description:"Testo di aiuto visualizzato sotto l'input del testo",defaultValue:{summary:"Testo di aiuto"}},descrizioneTooltip:{control:"text",description:"Descrizione visualizzata all'interno del tooltip informativo",defaultValue:{summary:"Inserire un suggerimento o una descrizione relativa a questo campo."}}},args:{etichetta:"Etichetta del campo",info:!0,messaggioHelper:"Testo di aiuto",descrizioneTooltip:"Inserire un suggerimento o una descrizione relativa a questo campo."},parameters:{transformersTs:[{type:"replace",keyToReplace:"{{info}}",stringToAdd:"{{info}}",argName:"info"}],transformersHtml:[{type:"replace",keyToReplace:"{{etichetta}}",stringToAdd:"{{etichetta}}",argName:"etichetta"},{type:"replace",keyToReplace:"{{messaggioHelper}}",stringToAdd:"{{messaggioHelper}}",argName:"messaggioHelper"},{type:"replace",keyToReplace:"{{descrizioneTooltip}}",stringToAdd:"{{descrizioneTooltip}}",argName:"descrizioneTooltip"}],htmlCode:'<div class="row">\n    <div class="col-sm-4">\n        <mat-form-field appearance="fill" [floatLabel]="\'always\'">\n            <div class="inail-mat-label-container">\n                <mat-label class="inail-mat-label" id="input4-label">{{etichetta}}\n                </mat-label>\n                <span *ngIf="info" tabindex="0" class="fa fa-question-circle fa-lg" data-toggle="popover" role="button"\n                    aria-expanded="false" data-trigger="manual" \n                    [attr.data-content]="\'{{descrizioneTooltip}}\'"\n                    data-container="body" (click)="onTooltipClick($event)" aria-labelledby="input4-label">\n                </span>\n            </div>\n            <input matInput placeholder="Placeholder" type="text" aria-labelledby="input4-label">\n            <mat-hint class="inail-mat-hint-ht">{{messaggioHelper}}</mat-hint>\n        </mat-form-field>\n    </div>\n</div>',tsCode:"import { Component, Input } from '@angular/core';\n        import { MatInputModule } from '@angular/material/input';\n        import { MatFormFieldModule } from '@angular/material/form-field';\n        import { CommonModule } from '@angular/common';\n        \n        @Component({\n          selector: 'app-tooltip-input-field',\n          standalone: true,\n          imports: [MatInputModule, MatFormFieldModule, CommonModule],\n          templateUrl: './tooltip-input-field.component.html',\n          styleUrl: './tooltip-input-field.component.scss'\n        })\n        export class TooltipInputFieldComponent {\n        info: boolean = {{info}};\n        \n          onTooltipClick(event: MouseEvent): void {\n            event.stopPropagation();\n          }\n        \n        }\n        \n        "},render:args=>({props:args,template:"<app-tooltip-input-field [etichetta]='etichetta' [info]='info' [messaggioHelper]='messaggioHelper' [descrizioneTooltip]='descrizioneTooltip'></app-tooltip-input-field>"})},__namedExportsOrder=["CampiInput","CampiInputDisabled","CampiInputError","CampiInputInfo"];CampiInput.parameters={...CampiInput.parameters,docs:{...CampiInput.parameters?.docs,source:{originalSource:"{\n  name: \"Campo di input con testo\",\n  argTypes: {\n    etichetta: {\n      control: 'text',\n      description: \"Specifica l'etichetta visualizzata sopra l'input del testo\",\n      defaultValue: {\n        summary: \"Etichetta del campo\"\n      }\n    }\n  },\n  args: {\n    etichetta: 'Etichetta del campo'\n  },\n  parameters: {\n    transformersHtml: [{\n      type: 'replace',\n      keyToReplace: '{{etichetta}}',\n      stringToAdd: `{{etichetta}}`,\n      argName: 'etichetta'\n    }],\n    htmlCode: `<div class=\"row\">\n    <div class=\"col-sm-4\">\n        <mat-form-field appearance=\"fill\" [floatLabel]=\"'always'\">\n            <div class=\"inail-mat-label-container\">\n                <mat-label class=\"inail-mat-label\" id=\"input1-label\">{{etichetta}}\n                </mat-label>\n            </div>\n            <input matInput placeholder=\"Placeholder\" type=\"text\" aria-labelledby=\"input1-label\">\n        </mat-form-field>\n    </div>\n</div>`,\n    tsCode: `import { Component, Input } from '@angular/core';\n        import {MatInputModule} from '@angular/material/input';\n        import {MatFormFieldModule} from '@angular/material/form-field';\n        @Component({\n          selector: 'app-input-field',\n          standalone: true,\n          imports: [MatFormFieldModule, MatInputModule],\n          templateUrl: './input-field.component.html',\n          styleUrl: './input-field.component.scss'\n        })\n        export class InputFieldComponent {\n        }\n        \n        `\n  },\n  render: args => ({\n    props: args,\n    template: \"<app-input-field [etichetta]='etichetta'></app-input-field>\"\n  })\n}",...CampiInput.parameters?.docs?.source}}},CampiInputDisabled.parameters={...CampiInputDisabled.parameters,docs:{...CampiInputDisabled.parameters?.docs,source:{originalSource:"{\n  name: \"Campo di input di testo disabilitato\",\n  argTypes: {\n    etichetta: {\n      control: 'text',\n      description: \"Specifica l'etichetta visualizzata sopra l'input del testo\",\n      defaultValue: {\n        summary: \"Etichetta del campo\"\n      }\n    },\n    disabilitato: {\n      control: \"boolean\",\n      description: \"Imposta l'input del testo come disabilitato\",\n      defaultValue: {\n        summary: true\n      }\n    }\n  },\n  args: {\n    etichetta: 'Etichetta del campo',\n    disabilitato: true\n  },\n  parameters: {\n    transformersHtml: [{\n      type: 'replace',\n      keyToReplace: '{{etichetta}}',\n      stringToAdd: `{{etichetta}}`,\n      argName: 'etichetta'\n    }],\n    transformersTs: [{\n      type: 'replace',\n      keyToReplace: '{{disabilitato}}',\n      stringToAdd: `{{disabilitato}}`,\n      argName: 'disabilitato'\n    }],\n    htmlCode: `<div class=\"row\">\n    <div class=\"col-sm-4\">\n        <mat-form-field appearance=\"fill\" [floatLabel]=\"'always'\">\n            <div class=\"inail-mat-label-container\">\n                <mat-label class=\"inail-mat-label\" id=\"input2-label\">{{etichetta}}\n                </mat-label>\n            </div>\n            <input matInput placeholder=\"Placeholder\" [disabled]=\"disabilitato\" aria-labelledby=\"input2-label\">\n        </mat-form-field>\n    </div>\n</div>`,\n    tsCode: `import { Component, Input } from '@angular/core';\n        import { MatInputModule } from '@angular/material/input';\n        import { MatFormFieldModule } from '@angular/material/form-field';\n        \n        @Component({\n          selector: 'app-disabled-input-field',\n          standalone: true,\n          imports: [MatInputModule, MatFormFieldModule],\n          templateUrl: './disabled-input-field.component.html',\n          styleUrl: './disabled-input-field.component.scss'\n        })\n        export class DisabledInputFieldComponent {\n        disabilitato:boolean={{disabilitato}};\n        }\n        \n        `\n  },\n  render: args => ({\n    props: args,\n    template: \"<app-disabled-input-field [etichetta]='etichetta' [disabilitato]='disabilitato'></app-disabled-input-field>\"\n  })\n}",...CampiInputDisabled.parameters?.docs?.source}}},CampiInputError.parameters={...CampiInputError.parameters,docs:{...CampiInputError.parameters?.docs,source:{originalSource:"{\n  name: \"Campo di input di testo con errore\",\n  argTypes: {\n    etichetta: {\n      control: 'text',\n      description: \"Specifica l'etichetta visualizzata sopra l'input del testo\",\n      defaultValue: {\n        summary: \"Etichetta del campo\"\n      }\n    },\n    inErrore: {\n      control: \"boolean\",\n      description: \"Simula l'errore nell'input\",\n      defaultValue: {\n        summary: true\n      }\n    },\n    messaggioErrore: {\n      control: 'text',\n      description: \"Visualizza un messaggio di errore sotto l'input del testo\",\n      defaultValue: {\n        summary: \"Messaggio d'errore\"\n      }\n    }\n  },\n  args: {\n    etichetta: 'Etichetta del campo',\n    inErrore: true,\n    messaggioErrore: \"Messaggio d'errore\"\n  },\n  render: args => ({\n    props: args,\n    template: \"<app-error-input-field [etichetta]='etichetta' [inErrore]='inErrore' [messaggioErrore]='messaggioErrore'></app-error-input-field>\"\n  }),\n  parameters: {\n    transformersTs: [{\n      type: 'replace',\n      keyToReplace: '{{messaggioErrore}}',\n      stringToAdd: `{{messaggioErrore}}`,\n      argName: 'messaggioErrore'\n    }],\n    transformersHtml: [{\n      type: 'replace',\n      keyToReplace: '{{etichetta}}',\n      stringToAdd: `{{etichetta}}`,\n      argName: 'etichetta'\n    }],\n    htmlCode: `<div class=\"row\">\n  <div class=\"col-sm-4\">\n    <mat-form-field appearance=\"fill\" [floatLabel]=\"'always'\">\n      <div class=\"inail-mat-label-container\">\n        <mat-label class=\"inail-mat-label\" id=\"input3-label\">{{etichetta}}\n        </mat-label>\n      </div>\n      <input matInput placeholder=\"Placeholder\" [formControl]=\"email\" required\n        type=\"text\" aria-labelledby=\"input3-label\">\n      @if (email.invalid) {\n      <mat-error>\n        <span>\n          <i class=\"fa-solid fa-circle-exclamation\"></i>\n          {{messaggioErrore}}\n        </span><br>\n      </mat-error>\n      }\n    </mat-form-field>\n  </div>\n</div>`,\n    tsCode: `import { Component } from '@angular/core';\n          import { FormControl, FormGroup, FormsModule, ReactiveFormsModule, Validators } from '@angular/forms';\n        import { MatInputModule } from '@angular/material/input';\n        import { MatFormFieldModule } from '@angular/material/form-field';\n\n        @Component({\n          selector: 'app-error-input-field',\n          standalone: true,\n          imports: [MatFormFieldModule, MatInputModule, FormsModule, ReactiveFormsModule],\n          templateUrl: './error-input-field.component.html',\n          styleUrl: './error-input-field.component.scss'\n        })\n        export class ErrorInputFieldComponent {\n         messaggioErrore: string = \"{{messaggioErrore}}\";\n          email = new FormControl('',Validators.required);  \n        }\n        \n        `\n  }\n}",...CampiInputError.parameters?.docs?.source}}},CampiInputInfo.parameters={...CampiInputInfo.parameters,docs:{...CampiInputInfo.parameters?.docs,source:{originalSource:"{\n  name: \"Campo di input con tasto di info\",\n  argTypes: {\n    etichetta: {\n      control: 'text',\n      description: \"Specifica l'etichetta visualizzata sopra l'input del testo\",\n      defaultValue: {\n        summary: 'LABEL'\n      }\n    },\n    info: {\n      control: 'boolean',\n      description: \"Mostra un'icona informativa accanto al input del testo\",\n      defaultValue: {\n        summary: true\n      }\n    },\n    messaggioHelper: {\n      control: 'text',\n      description: \"Testo di aiuto visualizzato sotto l'input del testo\",\n      defaultValue: {\n        summary: 'Testo di aiuto'\n      }\n    },\n    descrizioneTooltip: {\n      control: 'text',\n      description: \"Descrizione visualizzata all'interno del tooltip informativo\",\n      defaultValue: {\n        summary: 'Inserire un suggerimento o una descrizione relativa a questo campo.'\n      }\n    }\n  },\n  args: {\n    etichetta: 'Etichetta del campo',\n    info: true,\n    messaggioHelper: 'Testo di aiuto',\n    descrizioneTooltip: 'Inserire un suggerimento o una descrizione relativa a questo campo.'\n  },\n  parameters: {\n    transformersTs: [{\n      type: 'replace',\n      keyToReplace: '{{info}}',\n      stringToAdd: `{{info}}`,\n      argName: 'info'\n    }],\n    transformersHtml: [{\n      type: 'replace',\n      keyToReplace: '{{etichetta}}',\n      stringToAdd: `{{etichetta}}`,\n      argName: 'etichetta'\n    }, {\n      type: 'replace',\n      keyToReplace: '{{messaggioHelper}}',\n      stringToAdd: `{{messaggioHelper}}`,\n      argName: 'messaggioHelper'\n    }, {\n      type: 'replace',\n      keyToReplace: '{{descrizioneTooltip}}',\n      stringToAdd: `{{descrizioneTooltip}}`,\n      argName: 'descrizioneTooltip'\n    }],\n    htmlCode: `<div class=\"row\">\n    <div class=\"col-sm-4\">\n        <mat-form-field appearance=\"fill\" [floatLabel]=\"'always'\">\n            <div class=\"inail-mat-label-container\">\n                <mat-label class=\"inail-mat-label\" id=\"input4-label\">{{etichetta}}\n                </mat-label>\n                <span *ngIf=\"info\" tabindex=\"0\" class=\"fa fa-question-circle fa-lg\" data-toggle=\"popover\" role=\"button\"\n                    aria-expanded=\"false\" data-trigger=\"manual\" \n                    [attr.data-content]=\"'{{descrizioneTooltip}}'\"\n                    data-container=\"body\" (click)=\"onTooltipClick($event)\" aria-labelledby=\"input4-label\">\n                </span>\n            </div>\n            <input matInput placeholder=\"Placeholder\" type=\"text\" aria-labelledby=\"input4-label\">\n            <mat-hint class=\"inail-mat-hint-ht\">{{messaggioHelper}}</mat-hint>\n        </mat-form-field>\n    </div>\n</div>`,\n    tsCode: `import { Component, Input } from '@angular/core';\n        import { MatInputModule } from '@angular/material/input';\n        import { MatFormFieldModule } from '@angular/material/form-field';\n        import { CommonModule } from '@angular/common';\n        \n        @Component({\n          selector: 'app-tooltip-input-field',\n          standalone: true,\n          imports: [MatInputModule, MatFormFieldModule, CommonModule],\n          templateUrl: './tooltip-input-field.component.html',\n          styleUrl: './tooltip-input-field.component.scss'\n        })\n        export class TooltipInputFieldComponent {\n        info: boolean = {{info}};\n        \n          onTooltipClick(event: MouseEvent): void {\n            event.stopPropagation();\n          }\n        \n        }\n        \n        `\n  },\n  render: args => ({\n    props: args,\n    template: \"<app-tooltip-input-field [etichetta]='etichetta' [info]='info' [messaggioHelper]='messaggioHelper' [descrizioneTooltip]='descrizioneTooltip'></app-tooltip-input-field>\"\n  })\n}",...CampiInputInfo.parameters?.docs?.source}}}}}]);