# CarouselConfig

Documentazione dettagliata del custom model **CarouselConfig**, usato nei componenti di Internet Webkit v17. 
**CarouselConfig** è una classe senza costruttore, i campi necessari sono gia valorizzati con i valori di default. Si utilizza per creare l'Input necessario `carouselConfig` del componente CarouselComponent, per costruire un carousel nell' UI.

## Implementazione
<div class="table-responsive">`import { CarouselConfig } from "@inail/internet-webkit/carousel"`</div>
<br />

***Struttura:***
`class CarouselConfig {
	dots = true;
	infinite = false;
	speed = 300;
	slidesToShow = 2;
	accessibility = false;
	slidesToScroll = 2;
	responsive: CarouselConfigResponsive[] = [{
		breakpoint: 1024,
		settings: {
			slidesToShow: 1,
			slidesToScroll: 1,
			infinite: this.infinite,
			dots: this.dots
		}
	}];
	prevArrow?: string;
	nextArrow?: string;
}`

***Esempio d'uso:***
<br />
`carouselConfig = new CarouselConfig()`

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>dots</code></td>
      <td>
        Booleano che mostra i tre puntini per segnare contenuto ancora da mostrare. Valore default true.
      </td>
    </tr>
    <tr>
      <td><code>infinite</code></td>
      <td>
        Booleano valorizzato a false. Decide se il carousel è scorribile all' infinito in entrambe direzioni.
      </td>
    </tr>
    <tr>
      <td><code>speed</code></td>
      <td>
        Campo numerico che imposta la velocità dell'animazione di scroll. Valore di default 300.
      </td>
    </tr>
    <tr>
      <td><code>slidesToShow</code></td>
      <td>
        Campo numerico che imposta il numero di slide visibili su ogni pagina del carousel. Valore default 2, che poi si imposta a 1 slide per pagina, nel momento in cui si attiva il breakpoint di <code>CarouselConfigResponsive</code>.
      </td>
    </tr>
    <tr>
      <td><code>responsive</code></td>
      <td>
        Campo di tipo <code>CarouselConfigResponsive</code> che imposta nuovi valori a certi campi di <code>CarouselConfig</code> nel parametro <code>settings</code> tipo <code>Partial`<CarouselConfig>`</code> quando il browser fa trigger il <code>breakpoint</code> di 1024px.
      </td>
    </tr>
    <tr>
      <td><code>prevArrow</code> <br /> <code>nextArrow</code></td>
      <td>
        Campi di tipo string non obbligatori che impostano i button e le label dei pulsanti del carousel tramite la funzione. <code>updateLabel()</code>. 
        <br />
        <code> <pre> private updateLabel() {
            const prevLabel = this.localizationService.instant('BUTTON.CAROUSEL_PREV');
            const nextLabel = this.localizationService.instant('BUTTON.CAROUSEL_NEXT');
            const nextArrow = `<button class="slick-next slick-arrow" aria-label="${nextLabel}" type="button" style="display: block;">${nextLabel}  </button>`
            const prevArrow = `<button class="slick-prev slick-arrow" aria-label="${prevLabel}" type="button" style="display: block;">${prevLabel}  </button>`
            return { prevArrow, nextArrow };
          } </pre> </code>
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-carousel--basic-carousel">Carousel</a>