## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Tab Expandibili includono:

* La creazione di più sezioni di contenuto espandibili
* La gestione della visualizzazione e dell'espansione delle sezioni di contenuto
* La possibilità di personalizzare l'aspetto e il comportamento del componente

Gli aspetti tecnici rilevanti del componente Tab Expandibili includono:

* L'utilizzo di HTML, CSS e JavaScript per la creazione e gestione del componente
* La compatibilità con diversi browser e dispositivi
* La possibilità di personalizzare il componente tramite l'uso di attributi e classi CSS

Le caratteristiche di accessibilità del componente Tab Expandibili includono:

* La conformità agli standard di accessibilità WCAG 2.1
* La possibilità di utilizzare la tastiera e altri dispositivi di input per la navigazione e interazione con il componente

## VARIANTI

Il componente Tab Expandibili dispone delle seguenti varianti:

* **Tab 1**: una variante predefinita del componente che include tre sezioni di contenuto espandibili
* **Tab 2**: una variante personalizzata del componente che include due sezioni di contenuto espandibili e un’interfaccia modificata

I casi d'uso specifici per ogni variante includono:

* Utilizzare la variante Tab 1 per creare un'interfaccia utente standard con tre sezioni di contenuto espandibili
* Utilizzare la variante Tab 2 per creare un'interfaccia utente personalizzata con due sezioni di contenuto espandibili e un'interfaccia utente modificata

## BEST PRACTICES

Le raccomandazioni d'uso del componente Tab Expandibili includono:

* Utilizzare il componente per gestire grandi quantità di informazioni all'interno di un'interfaccia utente
* Personalizzare l'aspetto e il comportamento del componente per adattarlo alle esigenze specifiche dell'applicazione

Le linee guida implementative del componente Tab Expandibili includono:

* Utilizzare HTML, CSS e JavaScript per la creazione e gestione del componente
* Seguire gli standard di accessibilità WCAG 2.1 per garantire l'accessibilità del componente

Le pratiche da evitare nell'uso del componente Tab Expandibili includono:

* Non utilizzare il componente per gestire piccole quantità di informazioni all'interno di un'interfaccia utente
* Non personalizzare eccessivamente l'aspetto e il comportamento del componente, in quanto ciò potrebbe compromettere la sua accessibilità

## COMPONENTI CORRELATI

Il componente Tab Expandibili è associato ai seguenti componenti:

* **Accordion**: un componente che consente di visualizzare e gestire più sezioni di contenuto in modo espandibile
* **Tab**: un componente che consente di visualizzare e gestire più sezioni di contenuto in modo tabellare

Le relazioni con altri elementi del componente Tab Expandibili includono:

* La possibilità di utilizzare il componente all'interno di un'interfaccia utente più ampia
* La possibilità di integrare il componente con altri componenti e librerie per creare soluzioni personalizzate

## OVERVIEW
 <div class="table-responsive">`import { ExpandableTabsComponent } from '@inail/internet-webkit/tabs';`</div>
 
 Il componente ExpandableTabsComponent rappresenta un set di schede espandibili configurabili in Angular. Consente di definire dinamicamente un array di schede (tabs), con contenuti personalizzati associati a ciascuna scheda tramite template, e supporta la gestione dello stato attivo della scheda corrente tramite l'input activeTab. Inoltre, emette un evento (tabChanged) ogni volta che l'utente cambia la scheda attiva, rendendolo altamente interattivo e adatto per scenari dinamici.
 
 Il componente è altamente configurabile e supporta proprietà, eventi e opzioni per gestire scenari complessi, migliorando l'esperienza utente e l'accessibilità
 
 ## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th style="width: 20%"><strong>Campo</strong></th>
         <th style="width: 80%"><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>id</code></td>
         <td> <code> @Input() id!: string;</code><br /> Identificativo univoco per la Expandable Tabs. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
      </tr>
      <tr>
         <td><code>tabs</code></td>
         <td>
            `@Input() tabs: ExpandableTab[] = [];` <br />
            Array di oggetti che rappresentano le schede che verranno visualizzate. <br />
            Tipo di oggetto <a href = "?path=/docs/resources-models-expandabletab--docs">ExpandableTab</a>
         </td>
      </tr>
      <tr>
         <td><code>activeTab</code></td>
         <td>
            `@Input() activeTab!: ExpandableTab;` <br />
            Rappresenta il tab attualmente attivo (espanso).
            <br />
            Tipo di oggetto <a href = "?path=/docs/resources-models-expandabletab--docs">ExpandableTab</a>
         </td>
      </tr>
      <tr>
         <td><code>size</code></td>
         <td>
            `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
            La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
         </td>
      </tr>
   </tbody>
</table>
</div>

<br/>

<div class="table-responsive">
  <table class="table">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Event</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>tabChanged</code></td>
	  <td>
		`@Output() tabChanged = new EventEmitter<ExpandableTabsEvent>();` <br />
		Event emitter che gestisce l'evento onChangeTab($event).
	  </td>
	</tr>
  </tbody>
</table>
</div>