/* $(document).ready(function () {
    // Gestisce i dropdown manualmente
    $(".dropdown").each(function () {
        var $dropdown = $(this);
        var $button = $dropdown.find(".dropdown-toggle");
        var $menu = $dropdown.find(".dropdown-menu");
        var $items = $menu.find(".dropdown-item");

        $button.on("click", function (event) {
            event.stopPropagation();
            toggleDropdown($menu);
            $items.first().focus(); // Focus sul primo elemento quando il dropdown si apre
        });

        $(document).on("click", function () {
            closeAllDropdowns();
        });

        $menu.on("keydown", function (event) {
            event.stopPropagation(); // Impedisce la chiusura del dropdown
            var $focusedItem = $(document.activeElement);
            switch (event.key) {
                case "ArrowUp":
                    event.preventDefault();
                    var nextItem = $focusedItem.next(".dropdown-item");
                    if (nextItem.length) {
                        nextItem.focus();
                    } else {
                        $items.first().focus(); // Torna al primo elemento se si è all'ultimo
                    }
                    break;
                case "ArrowDown":
                    event.preventDefault();
                    var prevItem = $focusedItem.prev(".dropdown-item");
                    if (prevItem.length) {
                        prevItem.focus();
                    } else {
                        $items.last().focus(); // Torna all'ultimo elemento se si è al primo
                    }
                    break;
                case "Escape":
                    closeAllDropdowns();
                    $button.focus();
                    break;
            }
        });
    });

    function toggleDropdown($menu) {
        var isOpen = $menu.hasClass("show");
        closeAllDropdowns();
        if (!isOpen) {
            $menu.addClass("show").show();
        }
    }

    function closeAllDropdowns() {
        $(".dropdown-menu.show").removeClass("show").hide();
    }
}); */

$(document).ready(function () {
    $(".dropdown").each(function () {
        var $dropdown = $(this);
        var $button = $dropdown.find(".dropdown-toggle");
        var $menu = $dropdown.find(".dropdown-menu");
        var $items = $menu.find(".dropdown-item");

        $button.on("click", function (event) {
            event.stopPropagation();
            toggleDropdown($button, $menu);
            $items.first().focus();
        });

        $(document).on("click", function () {
            closeAllDropdowns();
        });

        $dropdown.on("focusout", function (event) {
            if (!$dropdown.has(event.relatedTarget).length) {
                closeAllDropdowns();
            }
        });

        $menu.on("keydown", function (event) {
            event.stopPropagation();
            var $focusedItem = $(document.activeElement);

            if (!$focusedItem.hasClass('dropdown-item')) {
                return;
            }

            var $allItems = $menu.find('.dropdown-item');
            var currentIndex = $allItems.index($focusedItem);

            switch (event.key) {
                case "ArrowUp":
                    event.preventDefault();
                    var prevIndex = currentIndex > 0 ? currentIndex - 1 : $allItems.length - 1;
                    $allItems.eq(prevIndex).focus();
                    break;

                case "ArrowDown":
                    event.preventDefault();
                    var nextIndex = currentIndex < $allItems.length - 1 ? currentIndex + 1 : 0;
                    $allItems.eq(nextIndex).focus();
                    break;

                case "Escape":
                    closeAllDropdowns();
                    $button.focus();
                    break;
            }
        });
    });

    function toggleDropdown($button, $menu) {
        var isOpen = $menu.hasClass("show");
        closeAllDropdowns();
        if (!isOpen) {
            $menu.addClass("show").show();
            $button.attr("aria-expanded", "true"); // ✅ Annuncia "aperto"
        } else {
            $button.attr("aria-expanded", "false");
        }
    }

    function closeAllDropdowns() {
        $(".dropdown-menu.show").each(function () {
            $(this).removeClass("show").hide();
            $(this).prev(".dropdown-toggle").attr("aria-expanded", "false"); // ✅ Annuncia "chiuso"
        });
    }
});




