## CARATTERISTICHE PRINCIPALI
Le caratteristiche principali del componente Notice includono:

*   **Funzionalità chiave**: il componente supporta la visualizzazione di messaggi di testo e può essere personalizzato con vari stili e layout.
*   **Aspetti tecnici rilevanti**: il componente è stato progettato per essere flessibile e facile da utilizzare, con un'interfaccia semplice e intuitiva.
*   **Caratteristiche di accessibilità**: il componente rispetta le linee guida di accessibilità standard e può essere utilizzato da utenti con disabilità.

## VARIANTI
Il componente Notice offre diverse varianti per adattarsi a differenti esigenze:

*   **Variante 1: Messaggio di testo**: visualizza un messaggio di testo semplice.
*   **Variante 2: Avviso importante**: visualizza un avviso importante con un'icona di attenzione.
*   Descrizioni per ogni variante:
    *   Variante 1: "Visualizza un messaggio di testo semplice."
    *   Variante 2: "Visualizza un avviso importante con un'icona di attenzione."

## BEST PRACTICES
Per utilizzare il componente Notice in modo efficace, si consiglia di:

*   Utilizzare il componente per visualizzare messaggi importanti o avvisi.
*   Personalizzare il componente con stili e layout appropriati per l'applicazione.
*   Evitare di utilizzare il componente per visualizzare informazioni non rilevanti.

## COMPONENTI CORRELATI
Componenti associati:

* ButtonComponent: può essere utilizzato in combinazione con il NoticeComponent per fornire azioni aggiuntive all'utente
* DialogComponent: può essere utilizzato per visualizzare messaggi più dettagliati o complessi

Relazioni con altri elementi:

* Il NoticeComponent può essere utilizzato all'interno di una pagina web o di un'applicazione mobile per fornire informazioni importanti all'utente

## OVERVIEW
<div class="table-responsive">`import { NoticeComponent } from '@inail/intranet-webkit/elements';`</div>

Componente personalizzato utilizzato per visualizzare messaggi di diverso tipo, come avvisi, errori o informazioni, a seconda della situazione.

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Campo</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>type</code></td>
      <td>
        `@Input() type: 'success' | 'danger' | 'warning' | 'info' = 'info';` <br />
        Campo di tipo stringa che imposta il tipo di notice, modificando anche lo stile visivo del componente.
      </td>
    </tr>
    <tr>
      <td><code>message</code></td>
      <td>
          `@Input() message: string = 'Message';` <br />
          Messaggio che viene mostrato nel notice.
      </td>
    </tr>
    <tr>
      <td><code>i18n</code></td>
      <td>
          `@Input() i18n: any;` <br />
          Parametri di traduzione i18n per il messaggio. <br />
          `{{ message | translate: i18n }}`
      </td>
    </tr>
    <tr>
      <td><code>closable</code></td>
      <td>
          `@Input() closable = false;` <br />
          Booleano che, quando impostato su true, consente all'utente di chiudere il notice tramite un pulsante mostrato condizionalmente.
      </td>
    </tr>
    <tr>
      <td><code>extClass</code></td>
      <td>
          `@Input() extClass!: string;` <br />
         Campo di tipo stringa che aggiunge una classe CSS personalizzata al componente.
      </td>
    </tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>close</code></td>
      <td>
        `@Output() close = new EventEmitter();` <br />
        `EventEmitter` tramite il quale è possibile gestire la chiusura del componente quando`closable è impostato su true.
      </td>
    </tr>
  </tbody>
</table>
</div>