## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Esecuzione di azioni specifiche quando il pulsante viene cliccato
 + Personalizzazione dell'aspetto e del comportamento del pulsante
* Aspetti tecnici rilevanti:
 + Utilizza un meccanismo di callback per eseguire le azioni specifiche
 + Supporta la personalizzazione attraverso l'utilizzo di proprietà e attributi
* Caratteristiche di accessibilità:
 N.D.

## VARIANTI

Le varianti disponibili per il componente Callback Button includono:

* **Default**: La variante predefinita del pulsante, che esegue un'azione specifica quando viene cliccato.
 + Caso d'uso: Utilizzare la variante Default per creare un pulsante di base che esegua un'azione specifica.
 + Descrizione breve: Il pulsante di base che esegue un'azione specifica quando viene cliccato.

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il componente Callback Button per creare pulsanti che eseguano azioni specifiche
 + Personalizzare l'aspetto e il comportamento del pulsante per adattarlo alle esigenze dell'applicazione
* Linee guida implementative:
 + Utilizzare un meccanismo di callback per eseguire le azioni specifiche
 + Supportare la personalizzazione attraverso l'utilizzo di proprietà e attributi
* Pratiche da evitare:
 N.D.

## COMPONENTI CORRELATI

Il componente Callback Button può essere utilizzato in combinazione con altri componenti, come ad esempio:

* **Form**: Il componente Form può essere utilizzato per creare moduli di input che interagiscono con il pulsante Callback Button.
* **Lista**: Il componente Lista può essere utilizzato per visualizzare i risultati delle azioni eseguite dal pulsante Callback Button.

## OVERVIEW
<div class="table-responsive">`import { CallbackButtonComponent } from '@inail/intranet-webkit/buttons';`</div>

Il CallbackButtonComponent è un'estensione del componente ButtonComponent, progettata per gestire pulsanti che eseguono logiche personalizzate tramite callback. Questo componente eredita tutte le funzionalità di base del ButtonComponent, aggiungendo una gestione semplificata e ottimizzata per l'invocazione di funzioni di callback al clic del pulsante.

Il CallbackButtonComponent è ideale in contesti in cui è necessario associare rapidamente un'azione programmata a un pulsante senza gestire manualmente gli eventi nell'HTML o nel componente principale.


## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
        <td><code>model</code></td>
        <td> <code>@Input() model!: BaseModel;</code><br /><a href="?path=/docs/resources-models-basemodel--docs">BaseModel</a> è un modello associato all'azione. Fornisce dati dinamici al componente, rendendolo contestualmente sensibile. </td>
    </tr>
    <tr>
      <td><code>ButtonComponent controls</code></td>
      <td>
        `class CallbackButtonComponent extends ButtonComponent` <br />
        La classe CallbackButtonComponent estende <a href="?path=/docs/components-buttons-button--docs">ButtonComponent</a>, ereditando le sue funzionalità.
      </td>
    </tr>
  </tbody>
</table>
</div>
