# ActionsField

Documentazione dettagliata dell' oggetto custom  **ActionsField**, usato nei componenti di Internet Webkit v17. 
**ActionsField** è un array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. Viene usato per costruire la colonna delle azioni nelle tabelle.

## Implementazione
<div class="table-responsive">`import { ActionsField } from '@inail/internet-webkit'`</div>
<br />

***Struttura:***
`constructor(label: string,
  actions: ActionItem[],
  canActionShowed?: (model: any, action: ActionItem) => boolean,
  size?: any)`

***Esempio d'uso:***
` actionsField = new ActionsField('', [
    new ActionItem(
      'BUTTON.EDIT_STEP',
      (actions: ActionItem, item: any) => {
        action('onEdit')(
          'This is after clicked onEdit ${JSON.stringify(item, null, 2)}'
        );
      },
      ['pencil']
    ),
    new ActionItem(
      'TITLE.DELETE_USER',
      (actions: ActionItem, item: any) => {
        action('onDelete')(
          'This is after clicked onDelete ${JSON.stringify(item, null, 2)}'
        );
      },
      ['trash']
    ),
 ])`

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>label</code></td>
      <td>
        Campo di tipo string che definisce l'etichetta del `ActionsField`.
      </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td>
        Campo array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. Crea il array di pulsanti che verrano visualizzati nella colonna azioni.
      </td>
    </tr>
    <tr>
      <td><code>canActionShowed</code></td>
      <td>
        Funzione che ritorna un booleano e puo prendere come argomenti un model e un object di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-table-simple--simple-table">Simple and Paginated Tables</a>
