# AdvancedTab

Documentazione dettagliata dell'oggetto custom  **AdvancedTab**, usato nei componenti di Intranet Webkit v17. 
**AdvancedTab** viene utilizzato per creare un tab con piu attributi del <a href="?path=/docs/resources-models-tab--docs">Tab semplice</a>.

## Implementazione
<div class="table-responsive">`import { AdvancedTab } from '@inail/intranet-webkit/tabs';`</div>
<br />

***Struttura:***
`constructor(
	id: number,
	title: string,
	hasError: boolean,
	disable: boolean,
	templateNo: any,
	options: AdvancedTabOptions = {}
) {
  super(id, title, hasError, disable, templateNo);
	this.icon = options.icon;
}`

***Esempio d'uso:***
`new AdvancedTab(1, 'TITLE.TAB_1', false, false, 1)`

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        Campo numerico che assegna un ID al tab.
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
        Campo di tipo `string` che imposta il titolo del tab creato.
      </td>
    </tr>
    <tr>
      <td><code>hasError</code></td>
      <td>
        Booleano che, quando è impostato a `true`, mostra un errore nel tab.
      </td>
    </tr>
    <tr>
      <td><code>disable</code></td>
      <td>
        Booleano che, quando è impostato su `true`, disabilita il tab.
      </td>
    </tr>
    <tr>
      <td><code>templateNo</code></td>
      <td>
        Campo che imposta l' index (partendo da 1) del template visualizzato nel tab corrente. I template sono in un array di `TemplateRef` che contiene referenze a degli `<ng-template #id>`, dove l' `#id` serve come referenza per l' input `[templates]="[id]"`.
      </td>
    </tr>
    <tr>
      <td><code>options</code></td>
      <td>
        Oggetto di tipo `AdvancedTabOptions`. Questa è un'interfaccia semplice, che contiene un solo campo di tipo stringa per impostare un'icona nel tab creato tramite la classe  `AdvancedTab`.
        `interface AdvancedTabOptions {
	      icon?: string;
}`
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-tabs-tabs--tabs">Tabs</a>
