## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Combobox includono:

* La gestione delle opzioni: il componente può gestire un elenco di opzioni che possono essere visualizzate all'utente
* La filtrazione delle opzioni: il componente consente di filtrare le opzioni tramite la digitazione di caratteri
* La selezione del valore: il componente consente di selezionare un valore dall'elenco

Gli aspetti tecnici rilevanti includono:

* La gestione degli eventi: il componente può gestire gli eventi di selezione e di cambiamento del valore
* La compatibilità con i browser: il componente deve essere compatibile con diversi browser e dispositivi

Le caratteristiche di accessibilità includono:

* La possibilità di utilizzare la tastiera per navigare tra le opzioni
* La possibilità di utilizzare gli screen reader per leggere le opzioni

## VARIANTI
Sono disponibili tre varianti del componente Combobox:

* **Combobox standard**: questa variante visualizza un elenco di opzioni e consente all'utente di selezionare un valore
* **Combobox disabilitata**: questa variante visualizza un elenco di opzioni, ma non consente la selezione del valore
* **Combobox con tasto info**: questa variante visualizza un elenco di opzioni e include un tasto che fornisce ulteriori informazioni sull'opzione selezionata

Casi d'uso specifici per ogni variante:

* Combobox standard: utilizzato quando si vuole fornire all'utente la possibilità di selezionare un valore da un elenco di opzioni
* Combobox disabilitata: utilizzato quando si vuole visualizzare un elenco di opzioni, ma non si vuole consentire la selezione del valore
* Combobox con tasto info: utilizzato quando si vuole fornire all'utente ulteriori informazioni sull'opzione selezionata

## BEST PRACTICES
Raccomandazioni d'uso:

* Utilizzare il componente Combobox quando si vuole fornire all'utente la possibilità di selezionare un valore da un elenco di opzioni
* Utilizzare la variante Combobox standard quando si vuole fornire all'utente la possibilità di selezionare un valore da un elenco di opzioni
* Utilizzare la variante Combobox disabilitata quando si vuole visualizzare un elenco di opzioni, ma non si vuole consentire la selezione del valore

Linee guida implementative:

* Assicurarsi che il componente sia compatibile con diversi browser e dispositivi
* Assicurarsi che il componente sia accessibile agli utenti con disabilità

Pratiche da evitare:

* Non utilizzare il componente Combobox quando non è necessario fornire all'utente la possibilità di selezionare un valore da un elenco di opzioni
* Non utilizzare la variante Combobox disabilitata quando si vuole consentire la selezione del valore

## COMPONENTI CORRELATI
Il componente Combobox può essere utilizzato in combinazione con altri componenti, come ad esempio:

* **Componente di input**: il componente Combobox può essere utilizzato per fornire un elenco di opzioni per l'input dell'utente
* **Componente di selezione**: il componente Combobox può essere utilizzato per fornire un elenco di opzioni per la selezione dell'utente

Relazioni con altri elementi:

* Il componente Combobox può essere utilizzato all'interno di una pagina web o di un'applicazione mobile
* Il componente Combobox può essere utilizzato in combinazione con altri componenti per creare un'interfaccia utente completa.

## ACCESSIBILITA'
La label deve essere associata all’input tramite l’attributo `for`.
Qualora label e input non siano direttamente collegati nel DOM (es. separati da contenitori), utilizzare `aria-labelledby` (valorizzato con l’ID del contenitore della label) per garantire la corretta associazione per le tecnologie assistive.
Esempio:
`<label id="x">
<input aria-labelledby="x"></input>
</label>`
`