$(document).ready(function () {
  const HIDDEN_ATTR = "aria-hidden";

  // Intercetta la creazione fisica del tooltip
  $(document).on("inserted.bs.tooltip", "[data-tooltip-hidden='true']", function () {
    const $el = $(this);
    const tooltipId = $el.attr("aria-describedby");
    if (!tooltipId) return;

    const $tooltip = $("#" + tooltipId);

    // Nascondi il tooltip al lettore di schermo *subito*
    $tooltip.attr(HIDDEN_ATTR, "true");
    $tooltip.find(".tooltip-inner").attr(HIDDEN_ATTR, "true");

    // Rimuovi aria-describedby *immediatamente*
    $el.removeAttr("aria-describedby");
  });
});
