/*
**
**  INAIL - Webkit 6.1.0
**
*/
function updateSRonly(idTabella){
		var sortedCol = $('#'+idTabella).dataTable().fnSettings().aaSorting[0][0];
		var sortedDir = $('#'+idTabella).dataTable().fnSettings().aaSorting[0][1];
		var colNumber = sortedCol+1;
		
		$('#'+idTabella).dataTable().find('th:eq('+sortedCol+') .sr-only').remove();
		
		if(sortedDir=="asc"){
			$('#'+idTabella).dataTable().find('th:eq('+sortedCol+')').removeClass('decrescente').attr('aria-label', 'Colonna '+colNumber+' ordinata in ordine crescente, attiva per ordinare in ordine decrescente');
		}else if(sortedDir=="desc"){
			$('#'+idTabella).dataTable().find('th:eq('+sortedCol+')').removeClass('crescente').attr('aria-label', 'Colonna '+colNumber+' ordinata in ordine decrescente, attiva per ordinare in ordine crescente');	
		}
		
		
		
		if($('#'+idTabella).hasClass('ordinata')){
		
			setTimeout(function(){
				$('#'+idTabella).find('th:eq('+sortedCol+')').focus();
			},50);
			setTimeout(function(){
				$('#'+idTabella).find('th:eq('+sortedCol+')').blur();
			},60);
			setTimeout(function(){
				$('#'+idTabella).find('th:eq('+sortedCol+')').focus();
			},250);
		}
		
		$('#'+idTabella).addClass('ordinata');
		//console.log('#'+idTabella);
	}

$(document).ready(function() {
	
	
	
	$.extend( true, $.fn.dataTable.defaults, {

		// PARAMETRI PER TUTTE LE TABELLE
		"language": {
			"sEmptyTable":     "Nessun risultato trovato",
			"sInfo":           "Vista da _START_ a _END_ di _TOTAL_ elementi",
			"sInfoEmpty":      "0 elementi presenti",
			"sInfoFiltered":   "(filtrati da _MAX_ elementi totali)",
			"sInfoPostFix":    "",
			"sInfoThousands":  ".",
			"sLengthMenu":     "Visualizza _MENU_ elementi",
			"sLoadingRecords": "Caricamento...",
			"sProcessing":     "Elaborazione...",
			"sSearch":         "Cerca:",
			"sZeroRecords":    "La ricerca non ha portato alcun risultato.",
			"oPaginate": {
				"sFirst":      "Inizio",
				"sPrevious":   "Precedente",
				"sNext":       "Successivo",
				"sLast":       "Fine"
			},
			"oAria": {
				"sSortAscending":  " ordinata in ordine decrescente, attiva per ordinare in ordine crescente",
				"sSortDescending": " ordinata in ordine crescente, attiva per ordinare in ordine decrescente"
			}
		}
	});



//ARIA-HIDDEN PER TH VUOTI e TH senza ordinamento
$('.table th').each(function(){
	if($(this).is(':empty')){
		$(this).attr('aria-hidden', 'true');
	}
});


//TOOLTIP ACCESSIBILI PER LINK IN TABELLA
$('.table .linkDettagli').each(function(){
	var textTooltip = $(this).text();
	$(this).attr('data-original-title', 'Vai a '+textTooltip);
	$(this).attr('data-toggle', 'tooltip');
});
$('.table td a[role="button"]').not('.noTooltip').each(function(){
	var titleTooltip = $(this).attr('title');
	$(this).attr('data-original-title', titleTooltip);
	$(this).attr('data-toggle', 'tooltip');
});



	

	/* SPECIFICHE TABELLA 1 */
    $('#tabella-1').DataTable( {

		/* TO ENABLE DISABLE TABLE OPTIONS: https://datatables.net/reference/option/ */
        "paging":   true,
        "ordering": true,
        "info":     false,
        "serverside": false,
		"fnDrawCallback": function() {
			var idTabella = $(this).attr('id');
				updateSRonly(idTabella);
			},
        "dom": '<"top"r>t<"bottom"fp>',
		"oLanguage": {
            "sLengthMenu": "Elementi per  pagina _MENU_",
            "oPaginate": {
                "sPrevious": " ",
                "sNext": " "
            }
        },
        "searching": false,
		"columnDefs": [
			{ "width": "17%", "targets": 0 },
			{ "width": "17%", "targets": 1, "orderable": false },
			{ "width": "17%", "targets": 2, "orderable": false },
			{ "width": "23%", "targets": 3, "orderable": false },
			{ "width": "26%", "targets": 4, "orderable": false }
		]
    });

	/* FINE SPECIFICHE TABELLA 1 */




	/* SPECIFICHE TABELLA ACCORDION */

    var tableAccordion = $('#tabella-2').DataTable( {
        "ordering": true,
        "info":     false,
        "searching": false,
        "paging":   false,
        "serverside": false,
		"fnDrawCallback": function() {
			var idTabella = $(this).attr('id');
			updateSRonly(idTabella);
			jQuery('#tabella-2 tbody').removeAttr('role').removeAttr('aria-multiselectable');
		},
        "dom": '<"top"rl>t<"bottom"fp>',
		"columnDefs": [
			{ "width": "20%", "targets": 0 },
			{ "width": "20%", "targets": 1, "orderable": false },
			{ "width": "40%", "targets": 2, "orderable": false },
			{ "width": "20%", "targets": 3, "orderable": false }
		]
    } );

    $('#tabella-2 tbody').on('click', 'td.td-icons button.tabIndex-input', function (e) {
		expandTable( $(this) , tableAccordion , formatGeneric1 );

		//INIZIALIZZAZIONE DEL DATEPICKER
		//(necessaria per elementi aggiunti al dom dopo il caricamento della pagina)
		jQuery('#tabella-2  .date input').datepicker({
            format: "dd/mm/yyyy",
            weekStart: 1,
            todayBtn: "linked",
            language: "it",
            todayHighlight: true
        });
		
		//SPOSTA IL FOCUS SUL CAMPO INPUT AL CLICK SULL'ICONA DEL CALENDARIO
		//(l'evento focus apre il calendario)
		$(".datePicker .fa.fa-calendar").click(function() {
			$(this).prev().focus();
		});
	});



	/* FINE SPECIFICHE TABELLA 2 */



	/* SPECIFICHE TABELLA STATUS */

    var tableStatus = $('#tab-status').DataTable( {
        "paging":   false,
        "ordering": true,
        "info":     false,
        "serverside": false,
		"fnDrawCallback": function() {
			var idTabella = $(this).attr('id');
				updateSRonly(idTabella);
			},
        "dom": 'rt<"bottom"flp>',
        "searching": false,
		"columnDefs": [
			{ "targets": 0, "orderable": false },
			{ "targets": 1, "orderable": false },
			{ "targets": 2 },
			{ "targets": 3, "orderable": false }
		]
    });

    $('#tab-status tbody').on('click', 'button.tabIndex-input', function (e) {
		expandTable( $(this) , tableStatus , formatGenerico4 );
		$('[data-toggle="tooltip"]').tooltip();
		
    });

	/* FINE SPECIFICHE TABELLA STATUS */

	$( "table.accordionTab" ).parents(".dataTables_wrapper.form-inline").removeClass('form-inline');


	/* SPECIFICHE TABELLA CHECKBOX */

	// Array holding selected row IDs
	var rows_selected = [];

	var table = $('#tabella-3').DataTable({
		"paging":   true,
        "ordering": true,
        "info":     false,
        "serverside": false,
        "dom": '<"top"rl>t<"bottom"fp>',
        "oLanguage": {
            "sLengthMenu": "Elementi per pagina _MENU_",
            "oPaginate": {
                "sPrevious": " ",
                "sNext": " "
            }
        },
        "searching": false,
        'columnDefs': [
        {
			'targets': 0,
			'searchable':false,
			'orderable':false,
			'className': 'sorting_1',
		},
		{
			'targets': 1,
		},
		{
			'targets': 2,
			'orderable':false
		},
		{
			'targets': 3,
			'orderable':false
		},
		],
		'order': [1, 'asc'],
		'rowCallback': function(row, data, dataIndex) {

			// Get row ID
			var rowId = data[0];

			// If row ID is in the list of selected row IDs
			if($.inArray(rowId, rows_selected) !== -1) {
				$(row).find('input[type="checkbox"]').prop('checked', true);
				$(row).addClass('selected');
			}
		},
		"fnDrawCallback": function() {
			var idTabella = $(this).attr('id');
				updateSRonly(idTabella);
			}
	});

	// Handle click on checkbox
	$('#tabella-3 tbody').on('click', 'input[type="checkbox"]', function(e) {
		var $row = $(this).closest('tr');

		// Get row data
		var data = table.row($row).data();

		// Get row ID
		var rowId = data[0];

		// Determine whether row ID is in the list of selected row IDs
		var index = $.inArray(rowId, rows_selected);

		// If checkbox is checked and row ID is not in list of selected row IDs
		if(this.checked && index === -1){
			rows_selected.push(rowId);

		// Otherwise, if checkbox is not checked and row ID is in list of selected row IDs
		} else if (!this.checked && index !== -1){
			rows_selected.splice(index, 1);
		}

		if(this.checked){
			$row.addClass('selected');
		} else {
			$row.removeClass('selected');
		}

		// Update state of "Select all" control
		updateDataTableSelectAllCtrl(table);

		// Prevent click event from propagating to parent
		e.stopPropagation();
	});

	// Handle click on table cells with checkboxes
	$('#tabella-3').on('click', 'tbody input[type="checkbox"], thead input[id="check_all"]', function(e){
		$(this).parent().find('input[type="checkbox"]').trigger('click');
	});

	// Handle click on "Select all" control
	$('#tabella-3 thead input[id="check_all"]').on('click', function(e){
		if(this.checked){
			$('#tabella-3 tbody input[type="checkbox"]:not(:checked)').trigger('click');
		} else {
			$('#tabella-3 tbody input[type="checkbox"]:checked').trigger('click');
		}

		// Prevent click event from propagating to parent
		e.stopPropagation();
	});

	// Handle table draw event
	table.on('draw', function(){
		// Update state of "Select all" control
		updateDataTableSelectAllCtrl(table);
	});
	$('input#check_1.primoCheck').focusin(function(){
		$(this).parent().parent().parent().parent().find('th').attr('aria-hidden', 'true');
	});
	$('input#check_1.primoCheck').focusout(function(){
		$(this).parent().parent().parent().parent().find('th').attr('aria-hidden', 'false');
	});

	/* FINE SPECIFICHE TABELLA CHECKBOX */


	/* TAB INDEX PER LE CELLE VUOTE */
	$('th.sorting').each(function(){
		var contentutoTh = $(this).html();
		if(contentutoTh==""){
			//$(this).attr('tabindex', '-1');
			//$(this).removeAttr('aria-label');
		}
	});
	/* FINE TAB INDEX PER LE CELLE VUOTE */


	/*012019 Accessibilità */
    $('.dataTables_paginate > ul > li.paginate_button > a').prop('title', 'vai alla pagina');
	//$('.dataTables_paginate > ul.pagination').wrap('<nav aria-label="Paginazione tabella">', '</nav>');
	//$('.dataTables_paginate > nav').attr('aria-label', 'Paginazione tabella');
	$('ul.pagination').wrap('<nav aria-label="Paginazione tabella"></nav>');

    /*26/10/2020  Accessibilità*/  
    var accessibilePaginationHandler = function(){ 
    	 $('.dataTables_paginate > ul > li.paginate_button.previous').each(function(index){
    		 if($(this).hasClass("disabled")){
        		 $(this).attr("aria-hidden", "true");
        		 $(this).find("a").attr("title", "Nessun elemento di paginazione precedente").attr("tabindex", "-1");   			 
    		 }
    		 else{
        		 $(this).attr("aria-hidden", "false");
        		 $(this).find("a").attr("title", "Vai alla pagina precedente").attr("tabindex", "0");   		 
    		 }
    	 })    	 
    	 $('.dataTables_paginate > ul > li.paginate_button.next').each(function(index){
    		 if($(this).hasClass("disabled")){
        		 $(this).attr("aria-hidden", "true");
        		 $(this).find("a").attr("title", "Nessun elemento di paginazione successivo").attr("tabindex", "-1");   			 
    		 }
    		 else{
        		 $(this).attr("aria-hidden", "false");
        		 $(this).find("a").attr("title", "Vai alla pagina successiva").attr("tabindex", "0");   		 
    		 }
    	 }) 
    }
  
  accessibilePaginationHandler();
  
  $('.dataTable').on( 'draw.dt', function () {
	  accessibilePaginationHandler();
	  $('[data-toggle="tooltip"]').tooltip();
  });
  /* ***************************************************** */

} );

/************ FINE $(document).ready() ************/




/* DEFINIZIONI DI FUNZIONE */

function expandTable(table , tableName, tableFunc) {
	
	// leggo se esiste una riga aperta
    var rowOpen = table.parents("tbody").data("rowOpen");
	// se esiste
    if (rowOpen) {
		//  e se è diversa dalla stessa cliccata precedentemente la nascondo
        if ( rowOpen.tableOpen !=  "table_" + table.index() )
			rowOpen.child.hide();
    }

    var trTable = table.closest('tr');
    var rowTable = tableName.row( trTable );
    var spanTable = table.parent().parent().find('button.tabIndex-input');
    rowTable.tableOpen = "table_" + table.index();

    table.parents("tbody").data("rowOpen" , rowTable);
    var collapsedRow = table.parents("tbody").find(".shown");

    if(collapsedRow.length > 0 ){
        collapsedRow.find("button.tabIndex-input").addClass('fa-angle-down');
        collapsedRow.find("button.tabIndex-input").removeClass('fa-angle-up').attr('aria-expanded', 'false');
        collapsedRow.removeClass('shown');
    }

    if ( rowTable.child.isShown() ) {
        // This row is already open - close it
        rowTable.child.hide();
        trTable.removeClass('shown');
        trTable.find('.fa-angle-up').removeClass('fa-angle-up').addClass('fa-angle-down');
    }
    else {
        // Open this row
        rowTable.child( tableFunc(rowTable.data()) ).show();
        trTable.addClass('shown');
        trTable.find('.fa-angle-down').removeClass('fa-angle-down').addClass('fa-angle-up').attr('aria-expanded', 'true');
    }

	    
}

/* INIZIALIZIO IL CALENDARIO EVENTI */
		jQuery('.date input').datepicker({
                        format: "dd/mm/yyyy",
                        weekStart: 1,
                        todayBtn: "linked",
                        language: "it",
                        todayHighlight: true
            });

            $('.date input').on('change', function(){
                        $('.datepicker').hide();
            });
// Updates "Select all" control in a data table (Checkbox table)
function updateDataTableSelectAllCtrl(table){
   var $table             = table.table().node();
   var $chkbox_all        = $('tbody input[type="checkbox"]', $table);
   var $chkbox_checked    = $('tbody input[type="checkbox"]:checked', $table);
   var chkbox_select_all  = $('thead input[id="check_all"]', $table).get(0);

   // If none of the checkboxes are checked
   if($chkbox_checked.length === 0){
      chkbox_select_all.checked = false;
      if('indeterminate' in chkbox_select_all){
         chkbox_select_all.indeterminate = false;
      }

   // If all of the checkboxes are checked
   } else if ($chkbox_checked.length === $chkbox_all.length){
      chkbox_select_all.checked = true;
      if('indeterminate' in chkbox_select_all){
         chkbox_select_all.indeterminate = false;
      }

   // If some of the checkboxes are checked
   } else {
      chkbox_select_all.checked = true;
      if('indeterminate' in chkbox_select_all){
         chkbox_select_all.indeterminate = true;
      }
   }
}

/* FINE DEFINIZIONI DI FUNZIONE */



/* FORMAT TABELLE ACCORDION */
//Scegliere fra le sottostanti quella che rispecchia il format desiderato, duplicarla e personalizzare la nuova a piacimento

//Format tabella accordion generiche
function formatGeneric1 ( d ) {
    // `d` is the original data object for the row

    return'<div>'+
	'<form action="#" class="row form-grey pop" id="form-generico1" name="Nome form">'+
	   '<fieldset class="row">'+
		  '<legend class="sr-only">Prima sezione</legend>'+
		  '<div class="row">'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-4">'+
				'<label class="control-label" for="input-2-1">Input 1</label>'+
				'<input type="text" class="form-control" id="input-2-1" placeholder="Inserisci testo" value="valore 1" >'+
			 '</div>'+
			 '<div class="form-inline date-range col-xs-12 col-sm-12 col-md-9 col-lg-8">'+
			   '<p>Periodo</p>'+
			   '<div class="date datePicker">'+
				  '<div class="form-group">'+
					 '<div class="input-relative">'+
						'<label class="control-label" for="form-data-5">Dal</label>'+
						'<input id="form-data-5" class="form-control" title="GG/MM/AAAA" placeholder="GG/MM/AAAA" type="text" >'+
						'<em class="fa fa-calendar" title="Calendario"></em>'+
					 '</div>'+
				  '</div>'+
				  '<div class="form-group">'+
					 '<div class="input-relative">'+
						'<label class="control-label" for="form-data-6">al</label>'+
						'<input id="form-data-6" class="form-control" title="GG/MM/AAAA" placeholder="GG/MM/AAAA" type="text" >'+
						'<em class="fa fa-calendar" title="Calendario"></em>'+
					 '</div>'+
				  '</div>'+
			   '</div>'+
			'</div>'+
		  '</div>'+
		  '<div class="row">'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-3">'+
				'<label class="control-label" for="input-2-41">Input 2</label>'+
				'<input type="text" class="form-control" id="input-2-41" placeholder="Inserisci testo" value="valore 2" >'+
			 '</div>'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-9">'+
				'<label class="control-label" for="input-2-5">Input 3</label>'+
				'<input type="text" class="form-control" id="input-2-5" placeholder="Inserisci testo" value="valore 3" >'+
			 '</div>'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-7">'+
				   '<label for="select-2-1" class="label-select col-xs-12 col-sm-12 col-md-12 col-lg-12 noPaddingLeft">'+
					  'Select 1'+
					  '<select class="form-control" id="select-2-1" disabled>'+
						 '<option value="Opzione 1">Opzione 1</option>'+
						 '<option value="Opzione 2">Opzione 2</option>'+
						 '<option value="Opzione 3">Opzione 3</option>'+
					  '</select>'+
				   '</label>'+
			 '</div>'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-3">'+
				'<label class="control-label" for="input-2-6">Input 4</label>'+
				'<input type="text" class="form-control" id="input-2-6" placeholder="Inserisci testo" value="valore 4" >'+
			 '</div>'+
		  '</div>'+
	   '</fieldset>'+
	'</form>'+

	'<div class="row baseFooter">'+
		'<div class="col-xs-3">'+
			'<a class="" href="#"><em tabindex="-1" class="fa fa-plus col-xs-3" title="Aggiungi elemento"></em> Nuovo</a>'+
		'</div>'+
		'<div class="col-xs-3">'+
			'<button class="" type="submit"><em tabindex="-1" class="fas fa-pencil-alt col-xs-3" title="Modifica elemento"></em> Modifica 1</button>'+
		'</div>'+
		'<div class="col-xs-3">'+
			'<a href="#" onclick="javascript:void(0);"><em tabindex="-1" class="fas fa-pencil-alt col-xs-3" title="Modifica elemento"></em> <span class="footerAction">Modifica 2</span></a>'+
		'</div>'+
		'<div class="col-xs-3">'+
			'<a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><em tabindex="-1" class="fa fa-trash-alt col-xs-3" title="Elimina elemento"></em> Elimina</a>'+
		'</div>'+
	'</div>'+
'</div>';
}

function formatGeneric2 ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 field">'+
                        '<div class="col-xs-4 field">'+
                            '<label for="inputAccordionGeneric2-1">Input 1</label>'+
                            '<input id="inputAccordionGeneric2-1" type="text" value="Lorem ipsum" readonly>'+
                        '</div>'+
                        '<div class="col-xs-3 field">'+
                            '<label for="inputAccordionGeneric2-2">Data 1</label>'+
                            '<input id="inputAccordionGeneric2-2" type="text" value="10/07/2017" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 col-xs-offset-1 field">'+
                            '<label for="inputAccordionGeneric2-3">Input 2</label>'+
                            '<input id="inputAccordionGeneric2-3" type="text" value="Lorem ipsum" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-7 field last">'+
                        '<div class="col-xs-7 field">'+
                            '<label for="inputAccordionGeneric2-4">Input 3</label>'+
                            '<input id="inputAccordionGeneric2-4" type="text" value="Input 3" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="toHide">'+
                        '<span class="col-sx-4">Lorem ipsum dolor sit amet</span>'+
                        '<input title="ruolo" class="col-sx-3 input-subAccordion" type="text" value="Lorem ipsum" readonly>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="spacing fa fa-eye" title="Visualizza dettaglio"></span><span class="footerAction">Dettaglio</span>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="spacing fa fa-download" title="Scarica elemento"></span><span class="footerAction">Scarica</span>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-trash-alt" title="Elimina elemento"></span><a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><span class="footerAction">Elimina</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatGeneric3 ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 field">'+
                        '<div class="col-xs-4 field">'+
                            '<label for="inputAccordionGeneric3-1">Input 1</label>'+
                            '<input id="inputAccordionGeneric3-1" type="text" value="Lorem ipsum" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<label for="inputAccordionGeneric3-2">Input 2</label>'+
                            '<input id="inputAccordionGeneric3-2" type="text" value="Lorem ipsum" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<label for="inputAccordionGeneric3-3">Input 3</label>'+
                            '<input id="inputAccordionGeneric3-3" type="text" value="Lorem ipsum" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="toHide">'+
                        '<span class="col-sx-4">Lorem ipsum dolor sit amet</span>'+
                        '<input title="ruolo" class="col-sx-3 input-subAccordion" type="text" value="Lorem ipsum" readonly>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="noPaddingLeft col-xs-3">'+
                        '<span class="fa fa-eye" title="Visualizza dettaglio"></span><span class="footerAction">Dettaglio</span>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fas fa-pencil-alt" title="Modifica elemento"></span><span class="details-option">Modifica</span>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fa fa-download" title="Scarica elemento"></span><a href=""><span class="footerAction">Scarica</span></a>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fa fa-trash-alt" title="Elimina elemento"></span><a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><span class="footerAction">Elimina</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatGeneric4 ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div>'+
                        '<h4>SOTTOTITOLO</h4>'+
                        '<p class="row"><span class="saveLabel">Lorem Ipsum dolor sit amet</span><select title="Lorem ipsum" class="table-hide-detail-sel saveSelect">'+'<option>Opzione 1</option>'+'</select>'+'</p>'+
                        '<div class="check">'+
                            '<input type="checkbox" checked="checked" id="privacy">'+
                            '<label for="privacy">Checkbox</label>'+
                            '<div class="baseBotton">'+
                                '<button type="button" class="btn btn-primary pull-right" id="associa">Bottone</button>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-3">'+
                        '<span class="fas fa-pencil-alt" title="Modifica elemento">'+'</span>'+'<span class="details-option-noAction">Modifica dati</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatGeneric5 ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
        '<tr class="collapsed-form">'+
            '<td colspan="4" class="pop" id="pop2">'+
                '<div>'+
                    '<form >'+
                    '<div class="row">'+
                        '<div class="col-xs-6">'+
                            '<label for="CodiceFiscale">Codice Fiscale</label>'+
                            '<input id="CodiceFiscale" title="CodiceFiscale" type="text" value="AEPAG712T4756H170" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2">'+
                            '<label for="CodiceAteco">Codice Ateco</label>'+
                            '<input id="CodiceAteco" title="CodiceAteco" type="text" value="123456" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<label for="SedeCompetente">Sede competente INAIL</label>'+
                            '<input id="SedeCompetente" title="SedeCompetente" type="text" value="Modena - 19100" readonly>'+
                        '</div>'+

                        '<div class="col-xs-12">'+
                            '<label for="IndirizzoSede">Indirizzo della sede legale</label>'+
                            '<input id="IndirizzoSede" title="IndirizzoSede" type="text" value="Via Palmiro Togliatti, 2500 00100 Roma (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-3">'+
                            '<label for="DataInizio">Data inizio attività</label>'+
                            '<input id="DataInizio" title="DataInizio" type="text" value="15/01/1987" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 noPaddingRight">'+
                            '<label for="DataSospensione">Data sospensione</label>'+
                            '<input id="DataSospensione" title="DataSospensione" type="text" value="15/04/2013" readonly>'+
                        '</div>'+

                        '<div class="col-xs-4 col-xs-offset-1">'+
                            '<label for="CausaleSospensione">Causale sospensione</label>'+
                            '<input id="CausaleSospensione" title="CausaleSospensione" type="text" value="Sospensione momentanea" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 longLabel">'+
                            '<label for="DataRiattivazione">Data riattivazione</label>'+
                            '<input id="DataRiattivazione" title="DataRiattivazione" type="text" value="15/01/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '</form>'+

                    '<div class="baseFooter">'+
                        '<div class="col-xs-6">'+
                            '<i class="fa fa-eye">'+'</i>'+'<span class="details-option">Visualizza PAT gestite</span>'+
                        '</div>'+

                        '<div class="col-xs-6 pull-right action-right">'+
                            '<i class="fa fa-trash-alt">'+'</i>'+'<span class="details-option" data-toggle="modal" data-target="#myModalAssociazione">Elimina Azienda in Delega</span>'+
                        '</div>'+
                    '</div>'+
                '</div>'+
            '</td>'+
        '</tr>'+
    '</table>';
}

function format ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr id="collapseOne" role="tabpanel" aria-labelledby="headingOne" class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-7 field">'+
                        '<label for="sede">Sede legale azienda</label>'+
                        '<input id="sede" type="text" value="Via Liguria, 38 - Milano 29145 (MI)" readonly>'+
                    '</div>'+
                    '<div class="col-xs-5 field last">'+
                        '<div class="col-xs-7 field">'+
                            '<label for="data-inizio">Data inizio attività</label>'+
                            '<input id="data-inizio" type="text" value="10/10/2012" readonly>'+
                        '</div>'+
                        '<div class="col-xs-5 field last">'+
                            '<label for="data-cesazione">Data cessazione</label>'+
                            '<input id="data-cesazione" type="text" value="" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-7 field">'+
                        '<label for="denominazione">Denominazione Unità Produttiva</label>'+
                        '<input id="denominazione" type="text" value="Laboratorio" readonly>'+
                    '</div>'+
                    '<div class="col-xs-5 field last">'+
                        '<div class="col-xs-7 field">'+
                            '<label for="ateco">Codice Ateco</label>'+
                            '<input id="ateco" type="text" value="123456" readonly>'+
                        '</div>'+
                        '<div class="col-xs-5 field last">'+
                            '<label for="asl">ASL competenza</label>'+
                            '<input id="asl" type="text" value="Roma Nord" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-7 field">'+
                        '<div class="col-xs-6 field">'+
                            '<label for="email">Email</label>'+
                            '<input id="email" type="text" value="info@santagostino.it" readonly>'+
                        '</div>'+
                        '<div class="col-xs-6 field last">'+
                            '<label for="pec">PEC</label>'+
                            '<input id="pec" type="text" value="santagostino@pec.inail.it" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-5 field last">'+
                        '<div class="col-xs-12 field last">'+
                            '<label for="tel">Recapito Telefonico</label>'+
                            '<input id="tel" type="text" value="063455886" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="toHide" aria-hidden="true/false">'+
                        '<span class="col-sx-4">Ruolo associato per questa unità produttiva</span>'+
                        '<input title="ruolo" class="col-sx-3 input-ruolo-associato" type="text" value="Medico Competente Unico" readonly>'+
                    '</div>'+
                    '<div class="save" aria-hidden="true/false">'+
                        '<h4>Modifica ruolo per unità produttiva</h4>'+
                        '<p class="row"><span class="saveLabel">Scegli il ruolo con cui vuoi associare a questa unità produttiva</span><select class="saveSelect" title="medico">'+'<option>Medico Competente Unico</option>'+'</select>'+'</p>'+
                        '<div class="check clearfix">'+
                            '<input type="checkbox" id="privacy">'+
                            '<label for="privacy">Il sottoscritto dichiara, sotto la propria responsabilità, di aver ricevuto incarico da parte del Datore di Lavoro come Medico Competente dellunità Produttiva indicata, e di essere consapevole che lorgano di vigilanza potrà controllare le veridicità della dichiarazione</label>'+
                        '</div>'+
                        '<button disabled type="button" class="col-md-2 btn btn-disabled btn-form-tabella pull-right">SALVA</button>'+
                    '</div>'+
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-3 noPaddingRight">'+
                        '<span class="fa fa-plus"></span><a href="#"><span class="footerAction">Nuova comunicazione</span></a>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fas fa-pencil-alt"></span><span class="details-option"><button>Modifica ruolo</button></span>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fas fa-pencil-alt"></span><a href="#"><span class="footerAction">Modifica dati</span></a>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fa fa-trash-alt"></span><a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><span class="footerAction">Elimina Associazione</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatCaratteristicheTecniche ( d ) {
    // `d` is the original data object for the row

    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div>'+
                        '<label for="caratteristiche">Descrizione</label>'+
                        '<textarea readonly="" maxlength="300" id="caratteristiche" class="col-md-12 textarea" placeholder="placeholder" title="placeholder"></textarea>'+
                    '</div>'+
                '</form>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatDomandeInviate ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr id="collapseOne" role="tabpanel" aria-labelledby="headingOne" class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                   '<div class="row">' +
                        '<div class="col-xs-2">' +
                            '<label for="dataInvio">Data di invio </label>' +
                            '<input type="text" readonly id="dataInvio" value="20/09/2015" />' +
                        '</div>' +
                        '<div class="col-xs-2">' +
                            '<label for="codiceDitta">Codice ditta</label>' +
                            '<input type="text" readonly id="codiceDitta" value="737272" />' +
                        '</div>' +
                        '<div class="col-xs-4">' +
                            '<label for="regione">Regione</label>' +
                            '<input type="text" readonly id="regione" value="LAZIO" />' +
                        '</div>' +

                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6 noPaddingRight">'+
                        '<span class="fa fa-download"></span><a href="#"><span class="footerAction">Scarica il riepilogo (PDF, 100KB)</span></a>'+
                    '</div>'+

                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatPagamenti_associati_alla_prestazione ( d ) {
    // `d` is formatPagamenti_associati_alla_prestazione original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr id="collapseOne" role="tabpanel" aria-labelledby="headingOne" class="collapsed-form">'+
        '<td colspan="6" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                   '<div class="row">' +
                        '<div class="col-md-3">' +
                            '<label for="Datapagamento">Data pagamento </label>' +
                            '<input type="text" readonly id="Datapagamento" value="18/10/2013" />' +
                        '</div>' +
                        '<div class="col-md-9">' +
                            '<label for="Modalitadipagamento">Modalità di pagamento</label>' +
                            '<input type="text" readonly id="Modalitadipagamento" value="Bollettino postale" />' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-md-12 noPaddingRight">'+
                        '<span class="fa fa-download"></span><a href="#"><span class="footerAction">Scarica il riepilogo pagamento (PDF, 100KB)</span></a>'+
                    '</div>'+

                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatConsulenteInviate ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-2">' +
                            '<label for ="">Data Invio</label>' +
                            '<input type="text" value="09/08/2015">' +
                        '</div>' +
                        '<div class="col-xs-4">' +
                            '<label for="">Regione</label>' +
                            '<input type="text" value="PIEMONTE">' +
                        '</div>' +
                    '</div>' +
                    '<div class="row">' +
                        '<div class="col-xs-8">' +
                            '<label for ="">Unità produttiva coinvolta</label>' +
                            '<input type="text" value="VIA GIUSEPPE MAZZINI, 70a - 13836 - COSSATO (BI) - ITALIA">' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatConsulenteInviatePresentata ( d ) {
    // `d` is the original data object for the row
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-2">' +
                            '<label for ="">Data Invio</label>' +
                            '<input type="text" value="09/08/2015">' +
                        '</div>' +
                        '<div class="col-xs-4">' +
                            '<label for="">Regione</label>' +
                            '<input type="text" value="PIEMONTE">' +
                        '</div>' +
                    '</div>' +
                    '<div class="row">' +
                        '<div class="col-xs-8">' +
                            '<label for ="">Unità produttiva coinvolta</label>' +
                            '<input type="text" value="VIA GIUSEPPE MAZZINI, 70a - 13836 - COSSATO (BI) - ITALIA">' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatConsulenteInviateClickDay ( d ) {
    // `d` is the original data object for the row
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-2">' +
                            '<label for ="">Data Invio</label>' +
                            '<input type="text" value="09/08/2015">' +
                        '</div>' +
                        '<div class="col-xs-4">' +
                            '<label for="">Regione</label>' +
                            '<input type="text" value="PIEMONTE">' +
                        '</div>' +
                    '</div>' +
                    '<div class="row">' +
                        '<div class="col-xs-8">' +
                            '<label for ="">Unità produttiva coinvolta</label>' +
                            '<input type="text" value="VIA GIUSEPPE MAZZINI, 70a - 13836 - COSSATO (BI) - ITALIA">' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
                     '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il codice ClickDay</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatConsulenteInviateVerifica ( d ) {
    // `d` is the original data object for the row
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-2">' +
                            '<label for ="">Data Invio</label>' +
                            '<input type="text" value="09/08/2015">' +
                        '</div>' +
                        '<div class="col-xs-4">' +
                            '<label for="">Regione</label>' +
                            '<input type="text" value="PIEMONTE">' +
                        '</div>' +
                    '</div>' +
                    '<div class="row">' +
                        '<div class="col-xs-8">' +
                            '<label for ="">Unità produttiva coinvolta</label>' +
                            '<input type="text" value="VIA GIUSEPPE MAZZINI, 70a - 13836 - COSSATO (BI) - ITALIA">' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
                     '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica i moduli</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatAggiungiDelega ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr id="collapseOne" role="tabpanel" aria-labelledby="headingOne" class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                     '<div class="col-xs-5 field last">'+
                        '<div class="col-xs-8 field">'+
                            '<label for="data-inizio">Codice Fiscale</label>'+
                            '<input id="data-inizio" type="text" value="MA0GAE10ZZ06T9051" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<label for="data-cesazione">Codice Ateco</label>'+
                            '<input id="data-cesazione" type="text" value="123456" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-7 field last">'+
                        '<div class="col-xs-6 field">'+
                            '<label for="data-inizio">Sede competente Inail</label>'+
                            '<input id="data-inizio" type="text" value="Roma - 00198" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-5 field last">'+
                        '<div class="col-xs-12 field">'+
                            '<label for="data-inizio">Indirizzo della sede legale</label>'+
                            '<input id="data-inizio" type="text" value="Via San Giovanni in Laterano, 156" readonly>'+
                        '</div>'+
                    '</div>'+
                     '<div class="col-xs-7 field last">'+
                        '<div class="col-xs-6 field">'+
                            '<label for="data-inizio">Sede competente Inail</label>'+
                            '<input id="data-inizio" type="text" value="Roma - 00198" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<label for="data-inizio">Provincia</label>'+
                            '<input id="data-inizio" type="text" value="RM" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<label for="data-inizio">CAP</label>'+
                            '<input id="data-inizio" type="text" value="00198" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-5 field last">'+
                        '<div class="col-xs-6 field">'+
                            '<label for="data-inizio">Data inizio attività</label>'+
                            '<input id="data-inizio" type="text" value="10/10/2001" readonly>'+
                        '</div>'+
                         '<div class="col-xs-6 field">'+
                            '<label for="data-inizio">Data cessazione</label>'+
                            '<input id="data-inizio" type="text" value="20/10/2009" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-7 field last">'+
                        '<div class="col-xs-6 field">'+
                            '<label for="data-inizio">Sede competente Inail</label>'+
                            '<input id="data-inizio" type="text" value="Roma - 00198" readonly>'+
                        '</div>'+
                        '<div class="col-xs-5 field">'+
                            '<label for="data-inizio">Data riattivazione</label>'+
                            '<input id="data-inizio" type="text" value="20/10/2009" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-8">'+
                        '<span class="fa fa-eye"></span><a href="#"><span class="footerAction">Vai al servizio Anagrafica</span></a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<div class="pull-right">' +
                            '<span class="fa fa-trash-alt"></span><a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><span class="footerAction">Elimina Azienda in delega</span></a>'+
                        '</div>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatUnitaProd ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div>'+
                        '<h4>Associa ruolo per unità produttiva</h4>'+
                        '<p class="row"><span class="saveLabel">Scegli il ruolo con cui vuoi associare a questa unità produttiva</span><select title="medico" class="table-hide-detail-sel saveSelect">'+'<option>Medico Competente Unico</option>'+'</select>'+'</p>'+
                        '<div class="check">'+
                            '<input type="checkbox" checked="checked" id="privacy">'+
                            '<label for="privacy">sottoscritto dichiara, sotto la propria responsabilità, di aver ricevuto incarico da parte del Datore di Lavoro come Medico Competente dellunità Produttiva indicata, e di essere consapevole che lorgano di vigilanza potrà controllare le veridicità della dichiarazione</label>'+
                            '<div class="baseBotton">'+
                                '<button type="button" class="btn btn-primary pull-right" id="associa">Associa</button>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-3">'+
                        '<span class="fas fa-pencil-alt">'+'</span>'+'<span class="details-option-noAction">Modifica dati</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatDettaglioPratica ( d ) {
    // `d` is the original data object for the row
   return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr id="collapseOne" role="tabpanel" aria-labelledby="headingOne" class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-4">'+
                            '<label for="dataPagamento" class="width1">Data Pagamento</label>'+
                            '<input class="col-md-6" id="dataPagamento" type="text" value="12/07/2015" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 ">'+
                            '<label for="esitoPagamento">Esito Pagamento</label>'+
                            '<input id="esitoPagamento" type="text" value="Pagato" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 ">'+
                            '<label for="formaDiPagamento">Forma di Pagamento</label>'+
                            '<input id="formaDiPagamento" type="text" value=" Conto Corrente Bancario" readonly>'+
                        '</div>'+


                        '<div class="col-xs-8">'+
                            '<label for="Beneficiario">Beneficiario</label>'+
                            '<input id="Beneficiario" type="text" value="Alfredo Mario Monterubbianese" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 ">'+
                            '<label for="iban">IBAN</label>'+
                            '<input id="iban" type="text" value="IT40Y0300205085000000999AAA" readonly>'+
                        '</div>'+

                        '<div class="col-xs-12 ">'+
                            '<label for="causalePagamento">Causale Pagamento</label>'+
                            '<input id="causalePagamento" type="text" value="Aumento straordinario su indennizzo in capitale danno biologico dm 27/03/2013" readonly>'+
                        '</div>'+
                    '</div>'+

                 '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download"></span><a href="#"><span class="footerAction">Scarica Provvedimento (PDF, 123KB)</span></a>'+
                    '</div>'+
                    '<div class="col-xs-6">'+
                        '<div>' +
                            '<span class="fa fa-download"></span><a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><span class="footerAction">Scarica altri dettagli pagamento (PDF, 76KB)</span></a>'+
                        '</div>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatUltimeAttivitaAzienda ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-4">' +
                            '<label for="regione">Regione</label>' +
                            '<input type="text" id="regione" readonly value="Piemonte" />' +
                        '</div>' +
                        '<div class="col-xs-2">' +
                            '<label for="pat">PAT</label>' +
                            '<input type="text" readonly value="0123446" id="pat" />' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
        '<div class="col-xs-3 pull-right text-right">'+
                        '<span class="fa fa-trash-alt">'+'</span>'+'<span class="details-option-noAction">Cancella domanda</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatUltimeAttivitaAziendaInviata ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-4">' +
                            '<label for="regione">Regione</label>' +
                            '<input type="text" id="regione" readonly value="Piemonte" />' +
                        '</div>' +
                        '<div class="col-xs-2">' +
                            '<label for="pat">PAT</label>' +
                            '<input type="text" readonly value="0123446" id="pat" />' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
        '<div class="col-xs-3 pull-right text-right">'+
                        '<span class="fa fa-trash-alt">'+'</span>'+'<span class="details-option-noAction">Cancella domanda</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatUltimeAttivitaAziendaClickDay ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-4">' +
                            '<label for="regione">Regione</label>' +
                            '<input type="text" id="regione" readonly value="Piemonte" />' +
                        '</div>' +
                        '<div class="col-xs-2">' +
                            '<label for="pat">PAT</label>' +
                            '<input type="text" readonly value="0123446" id="pat" />' +
                        '</div>' +
                    '</div>' +
                    '<div class="row">' +
                        '<div class="col-xs-8">' +
                            '<label for="codiceClickDay">Codice indentificativo per partecipare al ClicDay</label>' +
                            '<input type="text" id="codiceClickDay" readonly value="-7373whjjkdknhe8e777878b8ye7ejh7uhe8e" />' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
        '<div class="col-xs-6 pull-right text-right">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il codice identificativo per partecipare al Clickday</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatUltimeAttivitaAziendaAmmessaGraduatoria ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-4">' +
                            '<label for="regione">Regione</label>' +
                            '<input type="text" id="regione" readonly value="Piemonte" />' +
                        '</div>' +
                        '<div class="col-xs-2">' +
                            '<label for="pat">PAT</label>' +
                            '<input type="text" readonly value="0123446" id="pat" />' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
        '<div class="col-xs-6 pull-right text-right">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica documenti da inviare alla sede competente</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatUltimeAttivitaAziendaNonAmmessa ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">' +
                        '<div class="col-xs-4">' +
                            '<label for="regione">Regione</label>' +
                            '<input type="text" id="regione" readonly value="Piemonte" />' +
                        '</div>' +
                        '<div class="col-xs-2">' +
                            '<label for="pat">PAT</label>' +
                            '<input type="text" readonly value="0123446" id="pat" />' +
                        '</div>' +
                    '</div>' +
                '</form>'+

                '<div class="baseFooter">'+
                    '<div class="col-xs-6">'+
                        '<span class="fa fa-download">'+'</span>'+'<span class="details-option-noAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatEventiAgenda ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form formGrey">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div  class="box">'+

                    '<div class="box-body">'+
                        '<span class="titleTableCollaspe">INDIRIZZO DELLA SEDE INAIL</span>'+
                        '<span>Via Liguria, 38 - Milano 29145 (MI)</span>'+
                        '<br /><br />'+
                        '<span class="titleTableCollaspe">MOTIVO DELL’APPUNTAMENTO</span>'+
                        '<span>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation.</span>'+
                    '</div>'+
                '</div>'+

                '<div class="baseFooter">'+
                    '<div class="col-md-4 footerAction">'+
                        '<button class="btn">'+
                            '<span class="spacing fa fa-download"></span>'+
                            'Scarica il riepilogo (PDF, 100KB)'+
                        '</button> '+
                    '</div>'+
                    '<div class="col-md-4 footerAction">'+
                        '<button class="btn">'+
                            '<span class="spacing fas fa-pencil-alt"></span>'+
                            'Modifica appuntamento'+
                        '</button>'+
                    '</div>'+
                    '<div class="col-md-4 footerAction">'+
                        '<button class="btn">'+
                            '<span class="spacing fa fa-trash-alt"></span>'+
                            'Cancella appuntamento'+
                        '</button>'+
                    '</div>' +
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
    // modifica ruolo
}

function formatDeleghe ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
        '<tr class="collapsed-form">'+
            '<td colspan="4" class="pop" id="pop2">'+
                '<div>'+
                    '<form >'+
                    '<div class="row">'+
                        '<div class="col-xs-6">'+
                            '<label for="CodiceFiscale">Codice Fiscale</label>'+
                            '<input id="CodiceFiscale" title="CodiceFiscale" type="text" value="AEPAG712T4756H170" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2">'+
                            '<label for="CodiceAteco">Codice Ateco</label>'+
                            '<input id="CodiceAteco" title="CodiceAteco" type="text" value="123456" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<label for="SedeCompetente">Sede competente INAIL</label>'+
                            '<input id="SedeCompetente" title="SedeCompetente" type="text" value="Modena - 19100" readonly>'+
                        '</div>'+

                        '<div class="col-xs-12">'+
                            '<label for="IndirizzoSede">Indirizzo della sede legale</label>'+
                            '<input id="IndirizzoSede" title="IndirizzoSede" type="text" value="Via Palmiro Togliatti, 2500 00100 Roma (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-3">'+
                            '<label for="DataInizio">Data inizio attività</label>'+
                            '<input id="DataInizio" title="DataInizio" type="text" value="15/01/1987" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 noPaddingRight">'+
                            '<label for="DataSospensione">Data sospensione</label>'+
                            '<input id="DataSospensione" title="DataSospensione" type="text" value="15/04/2013" readonly>'+
                        '</div>'+

                        '<div class="col-xs-4 col-xs-offset-1">'+
                            '<label for="CausaleSospensione">Causale sospensione</label>'+
                            '<input id="CausaleSospensione" title="CausaleSospensione" type="text" value="Sospensione momentanea" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 longLabel">'+
                            '<label for="DataRiattivazione">Data riattivazione</label>'+
                            '<input id="DataRiattivazione" title="DataRiattivazione" type="text" value="15/01/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '</form>'+

                    '<div class="baseFooter">'+
                        '<div class="col-xs-6">'+
                            '<i class="fa fa-eye">'+'</i>'+'<span class="details-option">Visualizza PAT gestite</span>'+
                        '</div>'+

                        '<div class="col-xs-6 pull-right action-right">'+
                            '<i class="fa fa-trash-alt">'+'</i>'+'<span class="details-option" data-toggle="modal" data-target="#myModalAssociazione">Elimina Azienda in Delega</span>'+
                        '</div>'+
                    '</div>'+
                '</div>'+
            '</td>'+
        '</tr>'+
    '</table>';
}

function formatDeleghe2 ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
        '<tr class="collapsed-form">'+
            '<td colspan="4" class="pop" id="pop2">'+
                '<div>'+
                    '<form >'+
                    '<div class="row">'+
                        '<div class="col-xs-6">'+
                            '<label for="CodiceFiscale">Codice Fiscale</label>'+
                            '<input id="CodiceFiscale" title="CodiceFiscale" type="text" value="AEPAG712T4756H170" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2">'+
                            '<label for="CodiceAteco">Codice Ateco</label>'+
                            '<input id="CodiceAteco" title="CodiceAteco" type="text" value="123456" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<label for="SedeCompetente">Sede competente INAIL</label>'+
                            '<input id="SedeCompetente" title="SedeCompetente" type="text" value="Modena - 19100" readonly>'+
                        '</div>'+

                        '<div class="col-xs-12">'+
                            '<label for="IndirizzoSede">Indirizzo della sede legale</label>'+
                            '<input id="IndirizzoSede" title="IndirizzoSede" type="text" value="Via Palmiro Togliatti, 2500 00100 Roma (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-3">'+
                            '<label for="DataInizio">Data inizio attività</label>'+
                            '<input id="DataInizio" title="DataInizio" type="text" value="15/01/1987" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 noPaddingRight">'+
                            '<label for="DataSospensione">Data sospensione</label>'+
                            '<input id="DataSospensione" title="DataSospensione" type="text" value="15/04/2013" readonly>'+
                        '</div>'+

                        '<div class="col-xs-4 col-xs-offset-1">'+
                            '<label for="CausaleSospensione">Causale sospensione</label>'+
                            '<input id="CausaleSospensione" title="CausaleSospensione" type="text" value="Sospensione momentanea" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 longLabel">'+
                            '<label for="DataRiattivazione">Data riattivazione</label>'+
                            '<input id="DataRiattivazione" title="DataRiattivazione" type="text" value="15/01/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '</form>'+

                    '<div class="baseFooter">'+
                        '<div class="col-xs-3">'+
                            '<i class="fa fa-download">'+'</i>'+'<span class="details-option">Scarica DURC</span>'+
                        '</div>'+

                        '<div class="col-xs-3">'+
                            '<i class="fa fa-archive">'+'</i>'+'<span class="details-option" data-toggle="modal" data-target="#myModalAssociazione">Pratiche (12)</span>'+
                        '</div>'+

                        '<div class="col-xs-3">'+
                            '<i class="fas fa-pencil-alt">'+'</i>'+'<span class="details-option">Modifica anagrafica</span>'+
                        '</div>'+

                        '<div class="col-xs-3 pull-right action-right">'+
                            '<i class="fa fa-trash-alt">'+'</i>'+'<span class="details-option" data-toggle="modal" data-target="#myModalAssociazione">Elimina Delega</span>'+
                        '</div>'+
                    '</div>'+
                '</div>'+
            '</td>'+
        '</tr>'+
    '</table>';
}

function formatGenerico4 ( d ) {
    // `d` is the original data object for the row
    return '<div>'+
	'<form action="#" class="row form-grey pop" id="form-disabilitato" name="Nome form">'+
	   '<fieldset class="row">'+
		  '<legend class="sr-only">Prima sezione</legend>'+
		  '<div class="row">'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-4">'+
				'<label class="control-label" for="input-2-11">Input 1</label>'+
				'<input type="text" class="form-control" id="input-2-11" placeholder="Inserisci testo" value="valore 1" disabled>'+
			 '</div>'+


			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-3">'+
				'<label class="control-label" for="input-2-14">Input 2</label>'+
				'<input type="text" class="form-control" id="input-2-14" placeholder="Inserisci testo" value="valore 2" disabled>'+
			 '</div>'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-3">'+
				'<label class="control-label" for="input-2-15">Input 3</label>'+
				'<input type="text" class="form-control" id="input-2-15" placeholder="Inserisci testo" value="valore 3" disabled>'+
			 '</div>'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-6">'+
				'<label class="control-label" for="input-22-4">Input 4</label>'+
				'<input type="text" class="form-control" id="input-22-4" placeholder="Inserisci testo" value="valore 4" disabled>'+
			 '</div>'+
			 '<div class="form-group col-xs-6 col-sm-6 col-md-4 col-lg-6">'+
				'<label class="control-label" for="input-2-25">Input 5</label>'+
				'<input type="text" class="form-control" id="input-2-25" placeholder="Inserisci testo" value="valore 5" disabled>'+
			 '</div>'+
			 '<div class="col-xs-12 marginTop">'+
				'<p>Documenti:</p>'+

			 '<div class="col-xs-12">'+
				
				'<a class="btn-link col-xs-10" data-original-title="Scarica allegato" data-toggle="tooltip" href="#"><em class="fa fa-file-pdf pull-left"></em> Esempio di documento allegato (PDF, 150KB)</a>'+
			 '</div>'+

		 '</fieldset>'+

		'</form>'+
		'<div class="col-xs-12 baseFooter">'+
			'<div class="col-xs-6">'+
				'<em class="fa fa-download pull-left">'+'</em>'+'<a href="#" class="details-option col-xs-10" data-original-title="Scarica elemento" data-toggle="tooltip">Scarica il documento (PDF, 10KB)</span>'+
			'</div>'+
		'</div>'+
'</div>';
}

function formatAziendaDeleghe ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
        '<tr class="collapsed-form">'+
            '<td colspan="4" class="pop" id="pop2">'+
                '<div>'+
                    '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-6">'+
                            '<label for="CodiceFiscale">Codice Fiscale</label>'+
                            '<input id="CodiceFiscale" title="CodiceFiscale" type="text" value="AEPAG712T4756H170" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2">'+
                            '<label for="CodiceAteco">Codice Ateco</label>'+
                            '<input id="CodiceAteco" title="CodiceAteco" type="text" value="123456" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<label for="SedeCompetente">Sede competente INAIL</label>'+
                            '<input id="SedeCompetente" title="SedeCompetente" type="text" value="Modena - 19100" readonly>'+
                        '</div>'+

                        '<div class="col-xs-12">'+
                            '<label for="IndirizzoSede">Indirizzo della sede legale</label>'+
                            '<input id="IndirizzoSede" title="IndirizzoSede" type="text" value="Via Palmiro Togliatti, 2500 00100 Roma (RM)" readonly>'+
                        '</div>'+

                        '<div class="col-xs-3">'+
                            '<label for="DataInizio">Data inizio attività</label>'+
                            '<input id="DataInizio" title="DataInizio" type="text" value="15/01/1987" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 noPaddingRight">'+
                            '<label for="DataCessazione">Data sospensione</label>'+
                            '<input id="DataCessazione" title="DataSospensione" type="text" value="15/04/2013" readonly>'+
                        '</div>'+

                        '<div class="col-xs-4 col-xs-offset-1">'+
                            '<label for="CausaleCessazione">Causale sospensione</label>'+
                            '<input id="CausaleCessazione" title="CausaleSospensione" type="text" value="Sospensione momentanea" readonly>'+
                        '</div>'+

                        '<div class="col-xs-2 longLabel">'+
                            '<label for="DataRiattivazione">Data riattivazione</label>'+
                            '<input id="DataRiattivazione" title="DataRiattivazione" type="text" value="15/01/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '</form>'+

         '<div class="baseFooter">'+
                         '<div class="col-xs-4">'+
                            '<input type="checkbox" id="checkboxFavorite">'+'</i>'+'<label for="checkboxFavorite" class="favorite-flag">Aggiungi ai preferiti</label>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<i class="fa fa-eye">'+'</i>'+'<span class="details-option">Vai al servizio Anagrafica</span>'+
                        '</div>'+

                        '<div class="col-xs-4 pull-right action-right">'+
                            '<i class="fa fa-trash-alt">'+'</i>'+'<span class="details-option" data-toggle="modal" data-target="#myModalAssociazione">Elimina Azienda in Delega</span>'+
                        '</div>'+
                    '</div>'+
                '</div>'+
            '</td>'+
        '</tr>'+
    '</table>';
}

function formatMessaggi ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="6" cellspacing="0" border="0" style="padding-left:50px;">'+
        '<tr class="collapsed-form formGrey">'+
            '<td colspan="5" class="pop" id="pop2">'+
                '<div class="box">'+

                        '<div class="box-body">' +
                            '<p>'+
                                'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec consequat nunc. In condimentum, orci sed mattis porta, diam sapien finibus velit, rhoncus laoreet mauris erat dictum erat. Integer id cursus turpis, vitae egestas libero. Pellentesque viverra enim quis massa tristique sodales. Fusce et est sollicitudin quam fermentum viverra sed a dolor. Praesent vitae justo in sapien porta venenatis in eu orci. Nam eu hendrerit libero, id consectetur urna. Fusce ornare enim at magna luctus dignissim.' +
                            '</p>'+
                            '<div class="getAttachment">' +
                                '<p><strong>Allegati:</strong> </p>' +
                                '<div><i class="fa fa-file-pdf blueLink"></i> <a class="blueLink" href="">Esempio di documento allegato (PDF, 150KB)</a></span></div>'+
                                '<div><i class="fa fa-file-pdf blueLink"></i> <a class="blueLink" href="">Esempio di documento allegato (PDF, 150KB)</a></span></div>' +
                            '</div>' +
                        '</div>'+

                '</div>'+
            '</td>'+
        '</tr>'+
    '</table>';
}

function formatAslDettaglioUP ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-4">'+
                            '<label for="codiceCliente">Codice Cliente</label>'+
                            '<input id="codiceCliente" type="text" value="NGTHTT64T63R577H" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<label for="origine">Origine</label>'+
                            '<input id="origine" type="text" value="Online" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr />' +
                    '<div class="toHide">' +
                       '<span class="col-sx-4">Ruolo associato per questa unità produttiva</span> ' +
                       '<input title="ruolo" class="col-sx-3 input-ruolo-associato" type="text" value="Medico Competente Unico" readonly="">' +
                   '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="spacing fa fa-eye"></span><span class="footerAction">Dettaglio Comunicazione</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatAslRicercaUP ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-8 field">'+
                            '<label for="sedeLegaleAzienda">Sede legale azienda</label>'+
                            '<input id="sedeLegaleAzienda" type="text" value="Via Liguria, 38 - Milano 20145 (MI)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<label for="inizioAttivita">Data inizio attività</label>'+
                            '<input id="inizioAttivita" type="text" value="10/07/2013" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<label for="dataCessazione">Data cessazione</label>'+
                            '<input id="dataCessazione" type="text" value="10/07/2013" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="row">'+
                        '<div class="col-xs-8 field">'+
                            '<label for="denominazioneUP">Denominazione Unità Produttiva</label>'+
                            '<input id="denominazioneUP" type="text" value="Laboratorio" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<label for="codiceAteco">Codice Ateco</label>'+
                            '<input id="codiceAteco" type="text" value="459874" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<label for="aslCompetenza">ASL competenza</label>'+
                            '<input id="aslCompetenza" type="text" value="Roma Nord" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="row">'+
                        '<div class="col-xs-4 field">'+
                            '<label for="email">Email</label>'+
                            '<input id="email" type="text" value="nome.cognome@azienda.it" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<label for="pec">PEC</label>'+
                            '<input id="pec" type="text" value="nome.cognome@azienda.it" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<label for="telefono">Telefono</label>'+
                            '<input id="telefono" type="text" value="123456789" readonly>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<label for="cellulare">Cellulare</label>'+
                            '<input id="cellulare" type="text" value="123456789" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="spacing fa fa-eye"></span><span class="footerAction">Comunicazioni Unità Produttiva</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatMessaggiPatronato ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="6" cellspacing="0" border="0" style="padding-left:50px;">'+
        '<tr class="collapsed-form formGrey">'+
            '<td colspan="5" class="pop" id="pop2">'+
                '<div class="box">'+
                        '<div class="box-body">' +
                            '<p>'+
                                'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec nec consequat nunc. In condimentum, orci sed mattis porta, diam sapien finibus velit, rhoncus laoreet mauris erat dictum erat. Integer id cursus turpis, vitae egestas libero. Pellentesque viverra enim quis massa tristique sodales. Fusce et est sollicitudin quam fermentum viverra sed a dolor. Praesent vitae justo in sapien porta venenatis in eu orci. Nam eu hendrerit libero, id consectetur urna. Fusce ornare enim at magna luctus dignissim.' +
                            '</p>'+
                            '<div class="getAttachment">' +
                                '<p><strong>Allegati:</strong> </p>' +
                                '<div><i class="fa fa-file-pdf blueLink"></i> <a class="blueLink" href="">Esempio di documento allegato (PDF, 150KB)</a></span></div>'+
                                '<div><i class="fa fa-file-pdf blueLink"></i> <a class="blueLink" href="">Esempio di documento allegato (PDF, 150KB)</a></span></div>' +
                            '</div>' +
                        '</div>'+
                '</div>'+
            '</td>'+
        '</tr>'+
    '</table>';
}

function formatRisultatiRicercaMedico ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-4 field">'+
                        '<label for="numProtocollo">N° Protocollo</label>'+
                        '<input id="numProtocollo" type="text" value="000254306" readonly>'+
                    '</div>'+
                    '<div class="col-xs-4 field">'+
                        '<label for="codCliente">Ruolo associato</label>'+
                        '<input id="codCliente" type="text" value="Medico Competente Unico" readonly>'+
                    '</div>'+
                    '<div class="col-xs-4 field">'+
                        '<label for="origine">Medico competente coordinato</label>'+
                        '<input id="origine" type="text" value="Andrea Bianchi" readonly>'+
                    '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="spacing fa fa-eye"></span><span class="footerAction">Dettaglio comunicazione</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatGestisciDocumento ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-4">'+
                            '<label for="numProtocollo">Codice Utente</label>'+
                            '<input id="numProtocollo" class="noMargin" type="text" value="000254306" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<label for="dataAnn">Codice Fiscale</label>'+
                            '<input id="dataAnn" class="noMargin" type="text" value="10/07/2013" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<label for="origin">Email</label>'+
                            '<input id="origin" class="noMargin" type="text" value="online" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="toHide">'+
                        '<div class="col-md-8 noPadding">'+
                            '<h2 class="title-modulo">Gestione area</h2>' +
                            '<span class="col-sx-4">Hai inserito tutti i documenti necessari e  vuoi chiudere l\'area?</span>'+
                            '<select class="form-control">'+
                                '<option>SI</option>'+
                                '<option>NO</option>'+
                            '</select>'+
                       '</div>'+
                       '<div class="col-md-4 noPadding">' +
                             '<button class="btn btn-primary col-xs-4 pull-right margin-top-15">CHIUDI</button>' +
                       '</div>' +
                    '</div>'+
                '</form>'+
                '<div class="baseFooter-top">'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatAppuntamentoPrenotato ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="indirizzoSedeInail">Indirizzo sede INAIL dell\'appuntamento</label>'+
                            '<input id="indirizzoSedeInail" type="text" value="ROMA AURELIO - VIA GABRIELE D\'ANNUNZIO, 210 - 00146 ROMA (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="funzionarioInail">Funzionario INAIL</label>'+
                            '<input id="funzionarioInail" type="text" value="Carlo Bianchi" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="argomento">Argomento</label>'+
                            '<input id="argomento" type="text" value="" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="oggetto">Oggetto</label>'+
                            '<input id="oggetto" type="text" value="" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="motivoAppuntamento">Motivo dell\'appuntamento</label>'+
                            '<textarea class="col-md-12 textarea margin-bottom-20" readonly id="motivoAppuntamento">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean  euismod bibendum laoreet. Proin gravida dolor sit amet lacus accumsan et viverra justo commodo. Proin sodales pulvinar tempor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nam fermentum, nulla luctus pharetra vulputate, felis tellus mollis orci, sed rhoncus sapien nunc eget odio.</textarea>'+
                        '</div>' +
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="notificheCellulare">Notifiche via cellulare</label>'+
                            '<input id="notificheCellulare" type="text" value="329784592" readonly>'+
                        '</div>'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="notificheMail">Notifiche via mail</label>'+
                            '<input id="notificheMail" type="text" value="nome.cognome@azienda.it" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="notaInail">Nota INAIL</label>'+
                            '<input id="notaInail" type="text" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="noPaddingLeft col-xs-4">'+
                        '<span class="fa fa-download"></span><a href="#"><span class="footerAction">Scarica Riepilogo (PDF, 100KB)</span></a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fas fa-pencil-alt"></span><a href="#"><span class="footerAction">Modifica appuntamento</span></a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-trash-alt"></span><a href="#"><span class="footerAction">Elimina Appuntamento</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatAppuntamentoPatronatoInApprovazione ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="indirizzoSedeInail">Indirizzo sede INAIL dell\'appuntamento</label>'+
                            '<input id="indirizzoSedeInail" type="text" value="ROMA AURELIO - VIA GABRIELE D\'ANNUNZIO, 210 - 00146 ROMA (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="funzionarioInail">Funzionario INAIL</label>'+
                            '<input id="funzionarioInail" type="text" value="Carlo Bianchi" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="argomento">Argomento</label>'+
                            '<input id="argomento" type="text" value="" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="oggetto">Oggetto</label>'+
                            '<input id="oggetto" type="text" value="" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="oggetto">Oggetto</label>'+
                            '<textarea class="col-md-12 textarea margin-bottom-20" readonly id="oggetto">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean  euismod bibendum laoreet. Proin gravida dolor sit amet lacus accumsan et viverra justo commodo. Proin sodales pulvinar tempor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nam fermentum, nulla luctus pharetra vulputate, felis tellus mollis orci, sed rhoncus sapien nunc eget odio.</textarea>'+
                        '</div>' +
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="notificheCellulare">Notifiche via cellulare</label>'+
                            '<input id="notificheCellulare" type="text" value="329784592" readonly>'+
                        '</div>'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="notificheMail">Notifiche via mail</label>'+
                            '<input id="notificheMail" type="text" value="nome.cognome@azienda.it" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="notaInail">Nota INAIL</label>'+
                            '<input id="notaInail" type="text" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="noPaddingLeft col-xs-4">'+
                        '<span class="fa fa-download"></span><a href="#"><span class="footerAction">Scarica Riepilogo (PDF, 100KB)</span></a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fas fa-pencil-alt"></span><a href="#"><span class="footerAction">Modifica appuntamento</span></a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-trash-alt"></span><a href="#"><span class="footerAction">Elimina Appuntamento</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatAppuntamentoPatronatoRifiutata ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="indirizzoSedeInail">Indirizzo sede INAIL dell\'appuntamento</label>'+
                            '<input id="indirizzoSedeInail" type="text" value="ROMA AURELIO - VIA GABRIELE D\'ANNUNZIO, 210 - 00146 ROMA (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="funzionarioInail">Funzionario INAIL</label>'+
                            '<input id="funzionarioInail" type="text" value="Carlo Bianchi" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="argomento">Argomento</label>'+
                            '<input id="argomento" type="text" value="" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="oggetto">Oggetto</label>'+
                            '<input id="oggetto" type="text" value="" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="numeroPratica">N° Pratica</label>'+
                            '<input id="numeroPratica" type="text" value="12347098" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="oggetto">Oggetto</label>'+
                            '<textarea class="col-md-12 textarea margin-bottom-20" readonly id="oggetto">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean  euismod bibendum laoreet. Proin gravida dolor sit amet lacus accumsan et viverra justo commodo. Proin sodales pulvinar tempor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nam fermentum, nulla luctus pharetra vulputate, felis tellus mollis orci, sed rhoncus sapien nunc eget odio.</textarea>'+
                        '</div>' +
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="notificheCellulare">Notifiche via cellulare</label>'+
                            '<input id="notificheCellulare" type="text" value="329784592" readonly>'+
                        '</div>'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="notificheMail">Notifiche via mail</label>'+
                            '<input id="notificheMail" type="text" value="nome.cognome@azienda.it" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="notaInail">Nota INAIL</label>'+
                            '<input id="notaInail" type="text" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="noPaddingLeft col-xs-4">'+
                        '<span class="fa fa-trash"></span><a href="#"><span class="footerAction">Cancella appuntamento</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatAppuntamentoInApprovazione ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="indirizzoSedeInail">Indirizzo sede INAIL dell\'appuntamento</label>'+
                            '<input id="indirizzoSedeInail" type="text" value="ROMA AURELIO - VIA GABRIELE D\'ANNUNZIO, 210 - 00146 ROMA (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="funzionarioInail">Funzionario INAIL</label>'+
                            '<input id="funzionarioInail" type="text" value="Carlo Bianchi" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="argomento">Argomento</label>'+
                            '<input id="argomento" type="text" value="" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="oggetto">Oggetto</label>'+
                            '<input id="oggetto" type="text" value="" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="oggetto">Motivo dell\'appuntamento</label>'+
                            '<textarea class="col-md-12 textarea margin-bottom-20" readonly id="oggetto">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean  euismod bibendum laoreet. Proin gravida dolor sit amet lacus accumsan et viverra justo commodo. Proin sodales pulvinar tempor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nam fermentum, nulla luctus pharetra vulputate, felis tellus mollis orci, sed rhoncus sapien nunc eget odio.</textarea>'+
                        '</div>' +
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="notificheCellulare">Notifiche via cellulare</label>'+
                            '<input id="notificheCellulare" type="text" value="329784592" readonly>'+
                        '</div>'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="notificheMail">Notifiche via mail</label>'+
                            '<input id="notificheMail" type="text" value="nome.cognome@azienda.it" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="notaInail">Nota INAIL</label>'+
                            '<input id="notaInail" type="text" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="noPaddingLeft col-xs-4">'+
                        '<span class="fa fa-download"></span><a href="#"><span class="footerAction">Scarica Riepilogo (PDF, 100KB)</span></a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fas fa-pencil-alt"></span><a href="#"><span class="footerAction">Modifica appuntamento</span></a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-trash-alt"></span><a href="#"><span class="footerAction">Cancella Appuntamento</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatAppuntamentoRifiutata ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="indirizzoSedeInail">Indirizzo sede INAIL dell\'appuntamento</label>'+
                            '<input id="indirizzoSedeInail" type="text" value="ROMA AURELIO - VIA GABRIELE D\'ANNUNZIO, 210 - 00146 ROMA (RM)" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="funzionarioInail">Funzionario INAIL</label>'+
                            '<input id="funzionarioInail" type="text" value="Carlo Bianchi" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="argomento">Argomento</label>'+
                            '<input id="argomento" type="text" value="" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="oggetto">Oggetto</label>'+
                            '<input id="oggetto" type="text" value="" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="pat">PAT</label>'+
                            '<input id="pat" type="text" value="Lorem Ipsum" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="motivoAppuntamento">Motivo dell\'appuntamento</label>'+
                            '<textarea class="col-md-12 textarea margin-bottom-20" readonly id="motivoAppuntamento">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean  euismod bibendum laoreet. Proin gravida dolor sit amet lacus accumsan et viverra justo commodo. Proin sodales pulvinar tempor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nam fermentum, nulla luctus pharetra vulputate, felis tellus mollis orci, sed rhoncus sapien nunc eget odio.</textarea>'+
                        '</div>' +
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-4 no-padding-left">'+
                            '<label for="notificheCellulare">Notifiche via cellulare</label>'+
                            '<input id="notificheCellulare" type="text" value="329784592" readonly>'+
                        '</div>'+
                        '<div class="col-xs-8 no-padding-left">'+
                            '<label for="notificheMail">Notifiche via mail</label>'+
                            '<input id="notificheMail" type="text" value="nome.cognome@azienda.it" readonly>'+
                        '</div>'+
                    '</div>' +
                    '<div class="col-xs-12 no-padding-left">'+
                        '<div class="col-xs-12 no-padding-left">'+
                            '<label for="notaInail">Nota INAIL</label>'+
                            '<input id="notaInail" type="text" value="Lorem Ipsum sit dolor sit amet" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="noPaddingLeft col-xs-4">'+
                        '<span class="fa fa-trash"></span><a href="#"><span class="footerAction">Cancella appuntamento</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatComunicazioneAnnullata ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 field">'+
                        '<div class="col-xs-4 field">'+
                            '<label for="numProtocollo">N° Protocollo</label>'+
                            '<input id="numProtocollo" type="text" value="000254306" readonly>'+
                        '</div>'+
                        '<div class="col-xs-3 field">'+
                            '<label for="dataAnn">Data Annullam.</label>'+
                            '<input id="dataAnn" type="text" value="10/07/2013" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 col-xs-offset-1 field">'+
                            '<label for="origin">Origine</label>'+
                            '<input id="origin" type="text" value="online" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-7 field last">'+
                        '<div class="col-xs-7 field">'+
                            '<label for="codCliente">Medico Competente Coordinato</label>'+
                            '<input id="tel" type="text" value="Mario Rossi" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="toHide">'+
                        '<span class="col-sx-4">Ruolo associato per questa unità produttiva</span>'+
                        '<input title="ruolo" class="col-sx-3 input-ruolo-associato" type="text" value="Medico Competente Unico" readonly>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="spacing fa fa-eye"></span><span class="footerAction">Dettaglio comunicazione</span>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="spacing fa fa-download"></span><span class="footerAction">Scarica Riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-trash-alt"></span><a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><span class="footerAction">Elimina Comunicazione</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatComunicazioneInviata ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-12 field">'+
                        '<div class="col-xs-4 field">'+
                            '<label for="numProtocollo">N° Protocollo</label>'+
                            '<input id="numProtocollo" type="text" value="000254306" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<label for="origin2">Origine</label>'+
                            '<input id="origin2" type="text" value="online" readonly>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<label for="codCliente">Medico Competente Coordinato</label>'+
                            '<input id="tel" type="text" value="Mario Rossi" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="toHide">'+
                        '<span class="col-sx-4">Ruolo associato per questa unità produttiva</span>'+
                        '<input title="ruolo" class="col-sx-3 input-ruolo-associato" type="text" value="Medico Competente Unico" readonly>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="noPaddingLeft col-xs-3">'+
                        '<span class="fa fa-eye"></span><span class="footerAction">Dettaglio comunicazione</span>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fas fa-pencil-alt"></span><span class="details-option">Modifica ruolo</span>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fa fa-download"></span><a href="associa-up-modifica-dati-azienda.html"><span class="footerAction">Scarica Riepilogo (PDF, 100KB)</span></a>'+
                    '</div>'+
                    '<div class="col-xs-3">'+
                        '<span class="fa fa-trash-alt"></span><a href="#" class="" data-toggle="modal" data-target="#myModalAssociazione"><span class="footerAction">Elimina Comunicazione</span></a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatUltimeAttivitaConsulente ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-3 field">'+
                        '<div class="col-xs-12 field">'+
                            '<label for="dataInvio">Data di invio</label>'+
                            '<input id="dataInvio" type="text" value="08/09/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-3 field">'+
                        '<div class="col-xs-12 field">'+
                            '<label for="codiceDitta">Codice ditta</label>'+
                            '<input id="codiceDitta" type="text" value="8687879" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-6 field">'+
                        '<div class="col-xs-12 field">'+
                            '<label for="statoDomandaInviata">La stato della tua domanda inviata è:</label>'+
                            '<input id="statoDomandaInviata" type="text" value="PRESENTATA" readonly style="width:90%">'+
                            '<span class="fa fa-question-circle"></span>' +
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-download"></span><span class="footerAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatDenunce_online ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="5" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-4 field">'+
                        '<div class="col-xs-9 field">'+
                            '<label for="data">Data dell\'infortunio</label>'+
                            '<input id="data" type="text" value="05/02/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-2 field">'+
                        '<div class="col-xs-12 field">'+
                            '<label for="denuncePAT">PAT</label>'+
                            '<input id="denuncePAT" type="text" value="089015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-6 field">'+
                        '<div class="col-xs-8 field">'+
                            '<label for="statodenuncia">Stato della denuncia</label>'+
                            '<input id="statodenuncia" type="text" value="LIQUIDATA" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-12">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la ricevuta di invio (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la denuncia inviata (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica il modulo per la pubblica sicurezza (PDF, 100KB)</span>'+
                        '</a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatplConsulente ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="4" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-4">'+
                            '<div class="col-xs-12 noPadding">'+
                                '<label for="id001">ID Unità Produttiva</label>'+
                                '<input id="id001" type="text" value="14537" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<div class="col-xs-12 noPadding">'+
                                '<label for="id002">ASL di competenza</label>'+
                                '<input id="id002" type="text" value="Roma B" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<div class="col-xs-6 noPadding">'+
                                '<label for="id003">Data inizio attività</label>'+
                                '<input id="id003" type="text" value="10/10/2012" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                    '<div class="row">'+
                        '<div class="col-xs-4">'+
                            '<div class="col-xs-12 noPadding">'+
                                '<label for="id004">Email</label>'+
                                '<input id="id004" type="text" value="uffici@dominio.it" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<div class="col-xs-12 noPadding">'+
                                '<label for="id005">PEC</label>'+
                                '<input id="id005" type="text" value="ufficidominio@pec.it" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-4">'+
                            '<div class="col-xs-6 noPadding">'+
                                '<label for="id006">Telefono</label>'+
                                '<input id="id006" type="text" value="06 8449 378" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                    '<div class="row">'+
                        '<div class="col-xs-8">'+
                            '<div class="col-xs-12 noPadding">'+
                                '<label for="id007">PAT associate</label>'+
                                '<input id="id007" type="text" value="Via di Torrenova 128, 00172 Roma" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+

                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<a href="#" class="padding">'+
                            '<span class="fas fa-pencil-alt"></span><span class="footerAction">Modifica Unità produttiva</span>'+
                        '</a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-plus"></span><span class="footerAction">Associa una PAT</span>'+
                        '</a>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-plus"></span><span class="footerAction">Aggiungi RLS</span>'+
                        '</a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatDenunce_dafile ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="5" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-4 field">'+
                            '<div class="col-xs-9 field">'+
                                '<label for="data">Data dell\'infortunio</label>'+
                                '<input id="data" type="text" value="05/02/2015" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<div class="col-xs-12 field">'+
                                '<label for="denuncePAT">PAT</label>'+
                                '<input id="denuncePAT" type="text" value="089015" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-6 field">'+
                            '<div class="col-xs-8 field">'+
                                '<label for="statodenuncia">Stato della denuncia</label>'+
                                '<input id="statodenuncia" type="text" value="LIQUIDATA" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                    '<div class="row">'+
                        '<div class="col-xs-4 field">'+
                            '<div class="col-xs-9 field">'+
                                '<label for="N_file">N° file</label>'+
                                '<input id="N_file" type="text" value="10" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-8 field">'+
                            '<div class="col-xs-9 field">'+
                                '<label for="Nomedelfile">Nome del file</label>'+
                                '<input id="Nomedelfile" type="text" value="012345678_10092015_174423.xml" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+

                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-12">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la ricevuta di invio (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la denuncia inviata (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica il modulo per la pubblica sicurezza (PDF, 100KB)</span>'+
                        '</a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatDenunceConsulente_online ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="6" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="6" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-xs-4 field">'+
                        '<div class="col-xs-9 field">'+
                            '<label for="data">Data dell\'infortunio</label>'+
                            '<input id="data" type="text" value="05/02/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-2 field">'+
                        '<div class="col-xs-12 field">'+
                            '<label for="denuncePAT">PAT</label>'+
                            '<input id="denuncePAT" type="text" value="089015" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-xs-6 field">'+
                        '<div class="col-xs-8 field">'+
                            '<label for="statodenuncia">Stato della denuncia</label>'+
                            '<input id="statodenuncia" type="text" value="LIQUIDATA" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-12">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la ricevuta di invio (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la denuncia inviata (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica il modulo per la pubblica sicurezza (PDF, 100KB)</span>'+
                        '</a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatDenunceConsulente_dafile ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="6" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="6" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-xs-4 field">'+
                            '<div class="col-xs-9 field">'+
                                '<label for="data">Data dell\'infortunio</label>'+
                                '<input id="data" type="text" value="05/02/2015" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-2 field">'+
                            '<div class="col-xs-12 field">'+
                                '<label for="denuncePAT">PAT</label>'+
                                '<input id="denuncePAT" type="text" value="089015" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-6 field">'+
                            '<div class="col-xs-8 field">'+
                                '<label for="statodenuncia">Stato della denuncia</label>'+
                                '<input id="statodenuncia" type="text" value="LIQUIDATA" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                    '<div class="row">'+
                        '<div class="col-xs-4 field clearfix">'+
                            '<div class="col-xs-9 field">'+
                                '<label for="N_file">N° file</label>'+
                                '<input id="N_file" type="text" value="10" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-8 field">'+
                            '<div class="col-xs-9 field">'+
                                '<label for="Nomedelfile">Nome del file</label>'+
                                '<input id="Nomedelfile" type="text" value="012345678_10092015_174423.xml" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-12">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la ricevuta di invio (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica la denuncia inviata (PDF, 100KB)</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica il modulo per la pubblica sicurezza (PDF, 100KB)</span>'+
                        '</a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatTuttiCertificati ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="5" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="col-md-4 field">'+
                        '<div class="col-md-12 field">'+
                            '<label for="Origine">Origine</label>'+
                            '<input id="Origine" type="text" value="Online" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<div class="col-md-4 field">'+
                        '<div class="col-md-12 field">'+
                            '<label for="medicocertificatore">Medico Certificatore</label>'+
                            '<input id="medicocertificatore" type="text" value="Mario Rossi" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-12">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-eye "></span><span class="footerAction">Dettaglio Certificato</span>'+
                        '</a>'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-download"></span><span class="footerAction">Scarica riepilogo (PDF, 100KB)</span>'+
                        '</a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatImpianti ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="6" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="6" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row">'+
                        '<div class="col-md-4">'+
                            '<label for="Idprotocollo">Id. protocollo</label>'+
                            '<input id="Idprotocollo" type="text" value="1004-5670" readonly>'+
                        '</div>'+
                        '<div class="col-md-4">'+
                            '<label for="Dataprotocollazione">Data protocollazione</label>'+
                            '<input id="Dataprotocollazione" type="text" value="28/04/2015" readonly>'+
                        '</div>'+
                        '<div class="col-md-4">'+
                            '<label for="Matricolautente">Matricola utente</label>'+
                            '<input id="Matricolautente" type="text" value="12346890" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="row">'+
                        '<div class="col-md-12">'+
                            '<label for="Settore">Settore</label>'+
                            '<input id="Settore" type="text" value="Impianti di messa a terra e protezione scariche atmosferiche" readonly>'+
                        '</div>'+
                        '<div class="col-md-12">'+
                            '<label for="Gruppo">Gruppo</label>'+
                            '<input id="Gruppo" type="text" value="Apparecchi di sollevamento materiali non azionati a mano ed idroestrattori a forza centrifuga" readonly>'+
                        '</div>'+
                        '<div class="col-md-12">'+
                            '<label for="Sottogruppo">Sottogruppo</label>'+
                            '<input id="Sottogruppo" type="text" value="SC.A - Apparecchi mobili di sollevamento materiali di portata superiore a 200 KG s" readonly>'+
                        '</div>  '+
                        '<div class="col-md-12">'+
                            '<label for="Indirizzo">Indirizzo</label>'+
                            '<input id="Indirizzo" type="text" value="via G. Mazzini, 134 - 20132 Cologno Monzese (MI)" readonly>'+
                        '</div>'+
                    '</div>'+
                    '<hr>'+
                    '<div class="row">'+
                        '<div class="col-md-4">'+
                            '<label for="Dataesame">Data esame</label>'+
                            '<input id="Dataesame" type="text" value="01/04/2015" readonly>'+
                        '</div>'+
                        '<div class="col-md-4">'+
                            '<label for="Esitoesame">Esito esame</label>'+
                            '<input id="Esitoesame" type="text" value="Positivo" readonly>'+
                        '</div>'+
                        '<div class="col-md-2">'+
                            '<label for="Datascadenza">Data scadenza</label>'+
                            '<input id="Datascadenza" type="text" value="01/10/2015" readonly>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-12">'+
                        '<a href="#" class="padding">'+
                            '<span class="fa fa-eye "></span><span class="footerAction">Dettaglio Richiesta</span>'+
                        '</a>'+
                    '</div>'+
                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatAgendaGSPAI(d) {
    return '<table cellpadding="6" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="6" class="pop" id="pop2">'+
            '<div>'+
             '   <form>'+
              '      <div class="row">'+
               '         <div class="col-md-2">'+
                '            <label for="Nrichiesta">N° richiesta</label>'+
                 '           <input id="Nrichiesta" type="text" value="48585903" readonly >'+
                  '      </div>'+
                   '     <div class="col-md-2 col-md-offset-2">'+
                    '        <label for="Dataprotocollazione">Data protocollaz.</label>'+
                     '       <input id="Dataprotocollazione" type="text" value="28/04/2015" readonly>'+
                      '  </div>'+
                       ' <div class="col-md-2">'+
                        '    <label for="Dataassegnaz">Data assegnaz.</label>'+
                         '   <input id="Dataassegnaz" type="text" value="28/04/2015" readonly>'+
'                        </div>'+
 '                       <div class="col-md-4">'+
  '                          <label for="Matricolaimpianto">Matricola impianto</label>'+
   '                         <input id="Matricolaimpianto" type="text" value="2011-3-121322-RM" readonly>'+
    '                    </div>'+
     '               </div>'+
      '              <div class="row">'+
       '                 <div class="col-md-2">'+
        '                    <label for="Nfabbrica">N° fabbrica</label>'+
         '                   <input id="Nfabbrica" type="text" value="456792.01" readonly >'+
          '              </div>'+
           '             <div class="col-md-10">'+
            '                <label for="Settore">Settore</label>'+
             '               <input id="Settore" type="text" value="Impianti di messa a terra e protezione scariche atmosferiche" readonly>'+
              '          </div>'+
               '     </div>'+
                '    <div class="row">'+
                 '       <div class="col-md-12">'+
                  '          <label for="Gruppo">Gruppo</label>'+
                   '         <input id="Gruppo" type="text" value="Apparecchi di sollevamento materiali non azionati a mano ed idroestrattori a forza centrifuga" readonly>'+
                    '    </div>    '+
'                    </div>'+
 '                   <div class="row">'+
  '                      <div class="col-md-12">'+
   '                         <label for="Sottogruppo">Sottogruppo</label>'+
    '                        <input id="Sottogruppo" type="text" value="SC.A - Apparecchi mobili di sollevamento materiali di portata superiore a 200 KG s" readonly>'+
     '                   </div>'+
      '              </div>      '+
       '         </form>'+
        '        <div class="baseFooter">'+
         '           <div class="col-xs-12">'+
          '              <a href="#" class="padding">'+
           '                 <span class="fa fa-download "></span><span class="footerAction">Scarica riepilogo (PDF, 12KB)</span>'+
            '            </a>'+
             '       </div>'+
              '  </div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>'
}

function formatrichiesteGSPAI(d) {
    return '<table cellpadding="6" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="6" class="pop" id="pop2">'+
            '<div>'+
             '   <form>'+
              '      <div class="row">'+
               '         <div class="col-md-12">'+
                '            <label for="Settore">Settore</label>'+
                 '           <input id="Settore" type="text" value="Impianti di messa a terra e protezione scariche atmosferiche" readonly >'+
                  '      </div>'+
            '      </div>'+
            '      <div class="row">'+
                   '     <div class="col-md-12">'+
                    '        <label for="Gruppo">Gruppo</label>'+
                     '       <input id="Gruppo" type="text" value="Apparecchi di sollevamento materiali non azionati a mano ed idroestrattori a forza centrifuga" readonly>'+
                      '  </div>'+
            '      </div>'+
            '      <div class="row">'+
                   '     <div class="col-md-12">'+
                    '        <label for="Sottogruppo">Sottogruppo</label>'+
                     '       <input id="Sottogruppo" type="text" value="SC.A - Apparecchi mobili di sollevamento materiali di portata superiore a 200 KG s" readonly>'+
                      '  </div>'+
            '      </div>'+
       '         </form>'+
        '        <div class="baseFooter">'+
         '           <div class="col-xs-12">'+
             '       </div>'+
              '  </div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>'
}

function formatRetribuzioni ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr id="collapseOne" class="collapsed-form">'+
        '<td colspan="4" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="row-flex">'+
                        '<div class="col-xs-4 field">'+
                            '<div class="col-xs-12 field">'+
                                '<label for="totale2013">Totale Regolazione 2013</label>'+
                                '<input id="totale2013" type="text" value="4.292,61 €" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<div class="col-xs-12 field">'+
                                '<label for="totale2014">Totale Rata 2014</label>'+
                                '<input id="totale2014" type="text" value="277,77 €" readonly>'+
                            '</div>'+
                        '</div>'+
                        '<div class="col-xs-4 field">'+
                            '<div class="col-xs-12 field">'+
                                '<label for="importoPremio">Importo Totale del Premio</label>'+
                                '<input id="importoPremio" type="text" value="4.570,38 €" readonly>'+
                            '</div>'+
                        '</div>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-download"></span><span class="footerAction">Scarica il riepilogo (PDF, 100KB)</span>'+
                    '</div>'+

                    '<div class="col-xs-4">'+
                       ' <span class="fa fa-download"></span><span class="footerAction">Scarica la ricevuta di invio (PDF, 100KB)</span>'+
                    '</div>'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-download"></span><span class="footerAction">Scarica lF24 (PDF, 100KB)</span>'+
                    '</div>'+

                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

function formatMalattieAggiunte ( d ) {
    // `d` is the original data object for the row
    return '<table cellpadding="5" cellspacing="0" border="0" style="padding-left:50px;">'+
    '<tr class="collapsed-form">'+
        '<td colspan="5" class="pop" id="pop2">'+
            '<div>'+
                '<form>'+
                    '<div class="field">'+
                            '<label for="lista">Lista</label>'+
                            '<input id="lista" type="text" value="Lista 2" readonly>'+
                    '</div>'+
                    '<div class="field">'+
                            '<span>Agente / Lavorazione / Esposizione correlata alla malattia dell\'elenco ex art. 139 T. U.</span>'+
                            '<br><br>'+
                            '<textarea class="col-md-12 textarea" readonly>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aenean euismod bibendum laoreet. Proin gravida dolor sit amet lacus accumsan et viverra justo commodo. Proin sodales pulvinar tempor. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Nam fermentum, nulla luctus pharetra vulputate, felis tellus mollis orci, sed rhoncus sapien nunc eget odio.</textarea>'+
                    '</div>'+
                '</form>'+
                '<div class="baseFooter">'+
                    '<div class="col-xs-4">'+
                        '<span class="fa fa-trash-alt"></span><span class="footerAction">Elimina malattia</span>'+
                    '</div>'+

                '</div>'+
            '</div>'+
        '</td>'+
    '</tr>'+
'</table>';
}

/* FINE FORMAT TABELLE ACCORDION */