## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave: il Radio Button consente di effettuare una scelta singola esclusiva tra più opzioni.
* Aspetti tecnici rilevanti: il componente può essere utilizzato in combinazione con altri elementi, come etichette e descrizioni, per fornire un'esperienza utente completa.
* Caratteristiche di accessibilità: il Radio Button deve essere progettato per essere accessibile anche per gli utenti con disabilità, ad esempio utilizzando la tastiera per navigare tra le opzioni.

## VARIANTI

* **Opzione 1**: questa variante del Radio Button consente di selezionare una sola opzione tra due o più disponibili.
 + Caso d'uso: utilizzare questo tipo di Radio Button quando si desidera fornire all'utente la possibilità di scegliere tra due o più opzioni esclusive.
* **Opzione 2**: questa variante del Radio Button consente di selezionare una sola opzione tra tre o più disponibili.
 + Caso d'uso: utilizzare questo tipo di Radio Button quando si desidera fornire all'utente la possibilità di scegliere tra tre o più opzioni esclusive.
* **Opzione 3**: questa variante del Radio Button consente di selezionare una sola opzione tra quattro o più disponibili.
 + Caso d'uso: utilizzare questo tipo di Radio Button quando si desidera fornire all'utente la possibilità di scegliere tra quattro o più opzioni esclusive.

## BEST PRACTICES

* Raccomandazioni d'uso: il Radio Button deve essere utilizzato quando si desidera fornire all'utente la possibilità di scegliere tra due o più opzioni esclusive.
* Linee guida implementative: il componente deve essere progettato per essere accessibile e facile da usare, ad esempio utilizzando etichette e descrizioni chiare.
* Pratiche da evitare: non utilizzare il Radio Button quando si desidera fornire all'utente la possibilità di selezionare più opzioni contemporaneamente.

## COMPONENTI CORRELATI

* Etichette: le etichette possono essere utilizzate per descrivere le opzioni disponibili nel Radio Button.
* Descrizioni: le descrizioni possono essere utilizzate per fornire ulteriori informazioni sulle opzioni disponibili nel Radio Button.

## ACCESSIBILITA'
Nel caso dei radio button, passando sulle varie opzioni, lo screen reader non rileggerà l’etichetta del campo. Questo può rappresentare un problema nel caso in cui il contenuto tra un radio button e l’altro sia particolarmente lungo o contenga altri componenti; infatti, al passaggio sui radio button successivi, l’utente potrebbe avere difficoltà a ricollegarlo all’etichetta e dunque a capirne il significato. Può essere particolarmente problematico se vengono inseriti tra un radio button e l’altro dei componenti interattivi come campi di input. Si consiglia dunque di utilizzare i radio button con contenuti corti come da esempi sotto. Nel caso non fosse possibile si consiglia di aggiungere un attributo aria-label in modo che lo screen reader legga, oltre ai contenuti eventualmente inseriti nel tag <label> corrispondente, di nuovo l’etichetta del campo al passaggio sui singoli radio button, o un’altra indicazione che lo aiuti a capire cosa sta per selezionare (esempio: “Seleziona contenuto a seguire”).

Va prestata particolare attenzione nel caso di tabelle con righe selezionabili tramite radio button, perché al passaggio sui radio button lo screen reader non leggerà il contenuto della riga e non sarà possibile per l’utente capire a cosa si riferisce il bottone. Anche in questo caso si consiglia di implementare ogni radio button con un attributo aria-label che renda esplicito il riferimento all’oggetto della riga o di valorizzare il TAG <label> corrispondente ad ogni radio button (per esempio: <label =”Seleziona questa riga”>).

Non è possibile utilizzare radiobutton con opzioni contenenti testo più lungo di una frase (es: accettazione termini). Nel caso di opzioni con testo lungo si raccomanda l'utilizzo del componente checkbox, tab o accordion.
