## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave:
 + Consente di selezionare una sola opzione tra un insieme di possibilità.
 + Può essere utilizzato per creare un gruppo di pulsanti di scelta esclusiva.
* Caratteristiche di accessibilità:
 + Il Radio Button deve avere una descrizione chiara e concisa per ogni opzione.
 + Deve essere possibile navigare tra le opzioni utilizzando la tastiera.

## VARIANTI

* **Default**: La variante predefinita del Radio Button, senza alcuna personalizzazione aggiuntiva.
	+ Caso d'uso: Utilizzare il Radio Button per creare un gruppo di pulsanti di scelta esclusiva in un modulo.
	+ Descrizione breve: Il Radio Button predefinito consente di selezionare una sola opzione tra un insieme di possibilità.
* **Info**: La variante del Radio Button con descrizione aggiuntiva, utilizzata per fornire informazioni supplementari sull'opzione selezionata.
	+ Caso d'uso: Utilizzare il Radio Button con descrizione aggiuntiva per fornire informazioni supplementari sull'opzione selezionata in un modulo.
	+ Descrizione breve: Il Radio Button con descrizione aggiuntiva consente di fornire informazioni supplementari sull'opzione selezionata.

## BEST PRACTICES

* Raccomandazioni d'uso:
 + Utilizzare il Radio Button per creare un gruppo di pulsanti di scelta esclusiva in un modulo.
 + Fornire una descrizione chiara e concisa per ogni opzione.
* Pratiche da evitare:
 + Non utilizzare il Radio Button come sostituto di un pulsante di scelta multipla.
 + Non omettere la descrizione delle opzioni.

## COMPONENTI CORRELATI
N.D.

## ACCESSIBILITA'
Nel caso dei radio button, passando sulle varie opzioni, lo screen reader non rileggerà l’etichetta del campo. Questo può rappresentare un problema nel caso in cui il contenuto tra un radio button e l’altro sia particolarmente lungo o contenga altri componenti; infatti, al passaggio sui radio button successivi, l’utente potrebbe avere difficoltà a ricollegarlo all’etichetta e dunque a capirne il significato. Può essere particolarmente problematico se vengono inseriti tra un radio button e l’altro dei componenti interattivi come campi di input. Si consiglia dunque di utilizzare i radio button con contenuti corti come da esempi sotto. Nel caso non fosse possibile si consiglia di aggiungere un attributo aria-label in modo che lo screen reader legga, oltre ai contenuti eventualmente inseriti nel tag `<label>` corrispondente, di nuovo l’etichetta del campo al passaggio sui singoli radio button, o un’altra indicazione che lo aiuti a capire cosa sta per selezionare (esempio: “Seleziona contenuto a seguire”).

Va prestata particolare attenzione nel caso di tabelle con righe selezionabili tramite radio button, perché al passaggio sui radio button lo screen reader non leggerà il contenuto della riga e non sarà possibile per l’utente capire a cosa si riferisce il bottone. Anche in questo caso si consiglia di implementare ogni radio button con un attributo aria-label che renda esplicito il riferimento all’oggetto della riga o di valorizzare il TAG `<label>` corrispondente ad ogni radio button (per esempio: `<label =”Seleziona questa riga”>`).

Non è possibile utilizzare radiobutton con opzioni contenenti testo più lungo di una frase (es: accettazione termini). Nel caso di opzioni con testo lungo si raccomanda l'utilizzo del componente checkbox, tab o accordion.