## CARATTERISTICHE PRINCIPALI

Le caratteristiche chiave del pulsante di azione includono:

* **Funzionalità**: il pulsante può essere configurato per richiamare una specifica azione o funzionalità all'interno dell'applicazione
* **Aspetti tecnici**: il pulsante è realizzato utilizzando HTML, CSS e JavaScript, ed è compatibile con la maggior parte dei browser moderni
* **Caratteristiche di accessibilità**: il pulsante è progettato per essere accessibile agli utenti con disabilità, grazie alla presenza di attributi ARIA e alla possibilità di personalizzare il testo e le dimensioni del pulsante

## VARIANTI

Il pulsante di azione dispone delle seguenti varianti:

* **Pulsante primario**: utilizzato per richiamare un'azione principale all'interno dell'applicazione
	+ Casi d'uso: registrazione, invio di un modulo, ecc.
	+ Descrizione breve: pulsante di azione principale con stile e layout personalizzabili
* **Pulsante secondario**: utilizzato per richiamare un'azione secondaria all'interno dell'applicazione
	+ Casi d'uso: annullamento, reset, ecc.
	+ Descrizione breve: pulsante di azione secondario con stile e layout personalizzabili
* **Pulsante di conferma**: utilizzato per richiamare un'azione di conferma all'interno dell'applicazione
	+ Casi d'uso: conferma di una transazione, ecc.
	+ Descrizione breve: pulsante di azione di conferma con stile e layout personalizzabili

## BEST PRACTICES

Le raccomandazioni per l'utilizzo del pulsante di azione includono:

* Utilizzare un testo chiaro e conciso sul pulsante
* Personalizzare lo stile e il layout del pulsante per adattarsi alle esigenze dell'applicazione
* Assicurarsi che il pulsante sia accessibile agli utenti con disabilità

Le linee guida implementative includono:

* Utilizzare HTML, CSS e JavaScript per realizzare il pulsante
* Configurare gli attributi ARIA per garantire l'accessibilità del pulsante

Le pratiche da evitare includono:

* Utilizzare un testo troppo lungo o complesso sul pulsante
* Non personalizzare lo stile e il layout del pulsante per adattarsi alle esigenze dell'applicazione

## COMPONENTI CORRELATI

Il pulsante di azione è associato ai seguenti componenti:

* **Modulo**: il pulsante di azione può essere utilizzato all'interno di un modulo per richiamare un'azione specifica
* **Messaggio di conferma**: il pulsante di azione può essere utilizzato in combinazione con un messaggio di conferma per richiamare un'azione di conferma

N.D.