# ActionsField

Documentazione dettagliata del oggetto custom  **ActionsField**, usato nei componenti di Intranet Webkit v17. 
**ActionsField** è un array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> ed è utilizzato per costruire la colonna di azioni nelle tabelle.

## Implementazione
<div class="table-responsive">`import { ActionsField } from '@inail/intranet-webkit'`</div>
<br />

***Struttura:***
`constructor(label: string,
  actions: ActionItem[],
  canActionShowed?: (model: any, action: ActionItem) => boolean,
  size?: any)`

***Esempio d'uso:***
` actionsField = new ActionsField('', [
    new ActionItem(
      'BUTTON.EDIT_STEP',
      (actions: ActionItem, item: any) => {
        action('onEdit')(
          'This is after clicked onEdit ${JSON.stringify(item, null, 2)}'
        );
      },
      ['pencil']
    ),
    new ActionItem(
      'TITLE.DELETE_USER',
      (actions: ActionItem, item: any) => {
        action('onDelete')(
          'This is after clicked onDelete ${JSON.stringify(item, null, 2)}'
        );
      },
      ['trash']
    ),
 ])`

## API
<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>label</code></td>
      <td>
        Campo di tipo string che definisce l'etichetta dell'`ActionsField`.
      </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td>
        Campo di tipo array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>. Crea l'array di pulsanti che verranno visualizzati nella colonna azioni.
      </td>
    </tr>
    <tr>
      <td><code>canActionShowed</code></td>
      <td>
        Funzione che restituisce un booleano e può accettare come argomenti un model e un object di tipo <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a>.
      </td>
    </tr>
  </tbody>
</table>
</div>

## Casi d'utilizzo
<br />
<a href="?path=/story/components-table-simple--simple-table">Simple and Paginated Tables</a>
