## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Upload File includono:

* La gestione degli eventi di upload e di errore
* La personalizzazione delle opzioni di upload (ad esempio, estensioni consentite, dimensione massima)
* La possibilità di integrare il componente con altri elementi dell'interfaccia utente

Gli aspetti tecnici rilevanti del componente Upload File includono:

* L'utilizzo di tecnologie come HTML5 e CSS3 per la gestione degli upload
* La compatibilità con diversi browser e dispositivi

Le caratteristiche di accessibilità del componente Upload File includono:

* La possibilità di utilizzare tastiera e mouse per interagire con il componente
* La conformità ali standard di accessibilità WCAG 2.1

## VARIANTI

Sono disponibili due varianti del componente Upload File:

* **Variante 1: Carica file**: questa variante consente agli utenti di caricare uno o più file sul sistema.
	+ Casi d'uso specifici: upload di documenti, immagini e altri tipi di file.
	+ Descrizione breve: componente di upload di file facile da usare e personalizzabile.
* **Variante 2: Test della descrizione dell' upload file input**: questa variante è una versione di test del componente Upload File che include una descrizione dettagliata delle funzionalità di upload.
	+ Casi d'uso specifici: test e sviluppo dell'applicazione.
	+ Descrizione breve: componente di upload di file con descrizione dettagliata delle funzionalità.

## BEST PRACTICES

Le raccomandazioni d'uso del componente Upload File includono:

* Utilizzare il componente in contesti in cui è necessario caricare file sul sistema.
* Personalizzare le opzioni di upload per adattarsi alle esigenze specifiche dell'applicazione.
* Testare il componente per assicurarsi che funzioni correttamente in diversi browser e dispositivi.

Le linee guida implementative del componente Upload File includono:

* Utilizzare tecnologie come HTML5 e CSS3 per la gestione degli upload.
* Assicurarsi di conformarsi agli standard di accessibilità WCAG 2.1.

Le pratiche da evitare quando si utilizza il componente Upload File includono:

* Non utilizzare il componente in contesti in cui non è necessario caricare file sul sistema.
* Non personalizzare le opzioni di upload in modo eccessivo, poiché ciò può rendere il componente difficile da usare.

## COMPONENTI CORRELATI

Il componente Upload File è correlato ai seguenti componenti:

* **Button**: utilizzato per attivare l'upload del file.
* **Input**: utilizzato per selezionare il file da caricare.
* **Label**: utilizzato per visualizzare il nome e la dimensione del file.

## OVERVIEW
<div class="table-responsive">
	<code>import { UploadFileComponent } from '@inail/internet-webkit/form-controls';</code> <br />
</div>

Il componente Upload File è progettato per consentire agli utenti di caricare facilmente file all'interno di un'interfaccia utente. È ideale per caricare file, come immagini, documenti o video.


## API
<div class="table-responsive">
  <table class="table">
	  <thead>
			<tr>
			  <th><code>Campo</code></th>
			  <th><code>Descrizione</code></th>
			</tr>
	  </thead>
	  <tbody>
	<tr>
	  <td><code>idUpload</code></td>
	  <td>
		`@Input() idUpload = composeUniqueId('upload');` <br />
		Identificatore univoco per il campo di input per il caricamento.
	  </td>
	</tr>
	<tr>
	  <td><code>labelUpload</code></td>
	  <td>
		`@Input() labelUpload!: string;` <br />
		Testo dell'etichetta visualizzato per il campo di input per il caricamento.
	  </td>
	</tr>
	<tr>
	  <td><code>descMaxSize</code></td>
	  <td>
		`@Input() descMaxSize!: string;` <br />
		Testo descrittivo che indica la dimensione massima del file consentita per il caricamento.
	  </td>
	</tr>
	<tr>
	  <td><code>maxSize</code></td>
	  <td>
		`@Input({required: true}) maxSize!: number;` <br />
		Dimensione massima consentita (in byte) per ogni file caricato.	  </td>
	</tr>
	<tr>
	  <td><code>numMaxFile</code></td>
	  <td>
		`@Input() numMaxFile = 1;` <br />
		Numero massimo di file che possono essere caricati contemporaneamente.  </td>
	</tr>
	<tr>
	  <td><code>extensions</code></td>
	  <td>
		`@Input({required: true}) extensions!: string[];` <br />
		Estensioni di file consentite per il caricamento (es. [".jpg", ".png"]).  </td>
	</tr>
	<tr>
	  <td><code>maxNameLength</code></td>
	  <td>
		`@Input() maxNameLength = 250;` <br />
		Lunghezza massima consentita per ogni nome di file.  </td>
	</tr>
	<tr>
	  <td><code>size-label</code></td>
	  <td>
		`@Input() size-label: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		Bootstrap size dell' input label.  </td>
	</tr>
	<tr>
	  <td><code>size-input</code></td>
	  <td>
		`@Input() size-input: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		Bootstrap size dell' input.  </td>
	</tr>
	<tr>
	  <td><code>size-messages</code></td>
	  <td>
		`@Input() size-messages: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
		Bootstrap size degli input message.  </td>
	</tr>
	<tr>
		<td><code>size</code></td>
		<td>
		   `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
			La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
		</td>
	</tr>
	<tr>
	  <td><code>id</code></td>
	  <td>
		`@Input() id @Input() id: string = composeUniqueId('base_page_section');` <br />
		La proprietà `id` nella classe `BasePageSection` rappresenta un identificatore univoco. Questo ID è sovrascritto da BasePageSection.
	  </td>
	</tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
	<table class="table">
	  <thead>
		<tr>
		  <th style="width: 20%"><code>Event</code></th>
		  <th style="width: 80%"><code>Descrizione</code></th>
		</tr>
	  </thead>
	  <tbody>
		<tr>
		  <td><code>addFile</code></td>
		  <td>
			 <code>@Output() addFile = new EventEmitter &lt;File[]&gt;();</code> <br />
			Event emitter che gestisce l'evento addFile.
		  </td>
		</tr>
	  </tbody>
	</table>
</div>