## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente Paginated Table includono:

- Supporto per grandi quantità di dati
- Paginazione dei risultati per migliorare le prestazioni
- Ordinamento delle colonne per organizzare i dati in base a criteri specifici

Gli aspetti tecnici rilevanti del componente Paginated Table includono:

- Utilizzo di algoritmi efficienti per la gestione dei dati
- Supporto per diverse tipologie di dati (ad esempio, testo, numeri, date)

Le caratteristiche di accessibilità del componente Paginated Table includono:

- Supporto per tecnologie assistive, come screen reader e navigazione tramite tastiera
- Utilizzo di colori e contrasti accessibili

## VARIANTI

Le varianti disponibili del componente Paginated Table includono:

Variante 1: Tabella con intestazioni fisse
Questa variante mantiene le intestazioni visibili durante lo scroll verticale della tabella.

Casi d'uso specifici per questa variante includono:

- Visualizzazione di dati che richiedono intestazioni fisse per una migliore comprensione

Breve descrizione: "Tabella con intestazioni fisse per una migliore visualizzazione dei dati"

Variante 2: Tabella con ordinamento delle colonne
Questa variante include la possibilità di ordinare le colonne per organizzare i dati in base a criteri specifici.

Casi d'uso specifici per questa variante includono:

- Visualizzazione di dati che richiedono un ordinamento specifico per una migliore comprensione

Breve descrizione: "Tabella con ordinamento delle colonne per una migliore organizzazione dei dati"

## BEST PRACTICES

Le raccomandazioni d'uso del componente Paginated Table includono:

- Utilizzare il componente per visualizzare grandi quantità di dati in modo efficiente
- Configurare le opzioni di paginazione e ordinamento delle colonne in base alle esigenze specifiche dell'applicazione

Le linee guida implementative del componente Paginated Table includono:

- Utilizzare algoritmi efficienti per la gestione dei dati
- Supportare diverse tipologie di dati

Le pratiche da evitare del componente Paginated Table includono:

- Utilizzare il componente per visualizzare piccole quantità di dati, poiché non sarebbe efficace
- Non configurare le opzioni di paginazione e ordinamento delle colonne, poiché potrebbe compromettere la leggibilità dei dati

## COMPONENTI CORRELATI

I componenti associati al componente  includono:

- Componente di ricerca per filtrare i dati visualizzati nella tabella
- Componente di esportazione per esportare i dati visualizzati nella tabella in formato CSV o Excel

Le relazioni con altri elementi del componente Paginated Table includono:

- Utilizzo di colori e contrasti accessibili per garantire la leggibilità dei dati
- Supporto per tecnologie assistive, come screen reader e navigazione tramite tastiera per garantire l'accessibilità del componente

## OVERVIEW

<div class="table-responsive">`import { TableResultComponent } from '@inail/intranet-webkit/tables';`</div>

Componente custom usato per costruire tabelle. In questo caso, basta usare solo parti del componente del webkit per costruire una variazione semplice della tabella.

## API

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
  <tr>
    <th style="width: 20%"><strong>Campo</strong></th>
    <th style="width: 80%"><strong>Descrizione</strong></th>
  </tr>
  </thead>
  <tbody>
  <tr>
    <td><code>title</code></td>
    <td>
      `@Input() title!: string;` <br />
      Titolo visualizzato sopra la tabella.
    </td>
  </tr>
  <tr>
    <td><code>description</code></td>
    <td>
      `@Input() description!: string;` <br />
      Descrizione della tabella mostrata sotto il titolo.
    </td>
  </tr>
  <tr>
    <td><code>results</code></td>
    <td>
      `@Input('results') set manageResultInput(result: any[]) {}` <br />
      Un array di oggetti che vengono mostrati sulla tabella come elementi. Per informazioni più approfondite fare riferimento alla documentazione di <a href="?path=/docs/resources-models-results--docs">results</a>
    </td>
  </tr>
  <tr>
    <td><code>tableStructure</code></td>
    <td>
      `@Input('structure') tableStructure: any[] = [];` <br />
      Un array che costruisce la struttura della tabella. L' array contiene elementi <a href="?path=/docs/resources-models-tablefield--docs">TableField</a> che rappresentano le colonne, e facoltativamente, si puo aggiungere un ultimo oggetto <a href="?path=/docs/resources-models-actionsfield--docs">ActionsField</a>  che rappresenta la colonna di azioni della tabella.
      `const tableStructure = [
        new TableField('Colonna 1', true, 'NORMAL', 'name', false),
        new TableField('Colonna 2', false, 'NORMAL', 'size', false),
        new ActionsField('', [
          new ActionItem(
            'BUTTON.EDIT_STEP',
            (actions: ActionItem, item: any) => {
              action('onEdit')('');
            },
            ['pencil']
          ),
        ]),
        ];`
    </td>
  </tr>
  <tr>
    <td><code>showPageSize</code></td>
    <td>
      `@Input() showPageSize: true;` <br />
      Booleano usato per mostrare/nascondere il numero di elementi per pagina della tabella.
    </td>
  </tr>
  <tr>
    <td><code>bordered</code></td>
    <td>
      `@Input() bordered: true;` <br />
      Booleano usato per mostrare/nascondere le divisioni delle righe e colonne della tabella.
    </td>
  </tr>
  <tr>
    <td><code>stripped</code></td>
    <td>
      `@Input() stripped: true;` <br />
      Booleano usato per aplicare la classe CSS `table-striped`.
    </td>
  </tr>
  <tr>
    <td><code>bgWhite</code></td>
    <td>
      `@Input() bgWhite: true;` <br />
      Booleano usato per impostare uno sfondo bianco quando è impostato su `true` o transparente quando è impostato su `false`.
    </td>
  </tr>
	<tr>
	  <td><code>loading</code></td>
	  <td>
		  `@Input() loading: false;` <br />
		  Booleano usato per mostrare un stato di caricamento dei dati sulla tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>hover</code></td>
	  <td>
		  `@Input() hover: true;` <br />
		  Booleano usato per abilitare l' effetto del passaggio del mouse sulle righe.
	  </td>
	</tr>
	<tr>
	  <td><code>totalElements</code></td>
	  <td>
		  `@Input() totalElements!: number | undefined;` <br />
		  Campo numerico che imposta e mostra il numero totale di elementi nella tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>numElementsToShow</code></td>
	  <td>
		  `@Input() numElementsToShow!: number | undefined;` <br />
		  Campo numerico che imposta e mostra il numero totale di elementi per pagina nella tabella.
	  </td>
	</tr>
	<tr>
	  <td><code>showPageSize</code></td>
	  <td>
		  `@Input() showPageSize: true;` <br />
		  Booleano che mostra il selettore di dimensione della pagina quando è attivo.
	  </td>
	</tr>
	<tr>
	  <td><code>sortColumn</code></td>
	  <td>
		  `@Input() sortColumn!: string;` <br />
		  Campo che imposta la colonna utilizzata per l'ordinamento.
	  </td>
	</tr>
	<tr>
	  <td><code>sortType</code></td>
	  <td>
		  `@Input() set sortType(value: SortType) {}` <br />
		  Campo che imposta la direzione di ordinamento dei dati della tabella. Puo essere `"asc"` o `"desc"`.
	  </td>
	</tr>
	<tr>
	  <td><code>totalPages</code></td>
	  <td>
		  `@Input() set totalPages(num: number | undefined) {}` <br />
		  Campo numerico che imposta e mostra il numero di pagine in totale nella paginazione.
	  </td>
	</tr>
  </tbody>
</table>
</div>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
    <tr>
      <th style="width: 20%"><strong>Event</strong></th>
      <th style="width: 80%"><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>onPageChanged</code></td>
      <td>
        `@Output('onPageChanged') _onPageChanged: EventEmitter<number> = new EventEmitter<number>();` <br />
        `EventEmitter` tramite il quale si può gestire il cambio della pagina di elementi.
      </td>
    </tr>
    <tr>
      <td><code>onPageSizeChange</code></td>
      <td>
        `@Output('onPageSizeChange') _onPageSizeChange: EventEmitter<number> = new EventEmitter<number>();` <br />
        Evento emesso quando cambia il numero di elementi visibili per pagina.
      </td>
    </tr>
    <tr>
      <td><code>onSortChange</code></td>
      <td>
        `@Output('onSortChange') _onSortChange: EventEmitter<string> = new EventEmitter<string>();` <br />
        Evento emesso quando cambia l'ordinamento degli elementi.
      </td>
    </tr>
  </tbody>
</table>
</div>