## Caratteristiche Principali

Le caratteristiche principali del Form Group includono:

* **Funzionalità chiave**: la possibilità di raggruppare campi di input e altri elementi di forma in modo logico e organizzato
* **Aspetti tecnici rilevanti**: il componente utilizza Bootstrap per la gestione degli stili e del layout
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile e compatibile con gli standard WCAG 2.1

## Varianti

Le varianti disponibili per il Form Group includono:

* **Varianti di dimensione**: il componente può essere utilizzato con diverse dimensioni di input, tra cui small, medium e large
* **Varianti di layout**: il componente può essere utilizzato con diversi layout, tra cui orizzontale e verticale

Le descrizioni per ogni variante sono le seguenti:

* **Small**: varianti di piccole dimensioni, ideali per moduli compatti
* **Medium**: varianti di medie dimensioni, ideali per moduli standard
* **Large**: varianti di grandi dimensioni, ideali per moduli estesi

## Best Practices

Le raccomandazioni d'uso per il Form Group includono:

* Utilizzare il componente per raggruppare campi di input e altri elementi di forma in modo logico e organizzato
* Personalizzare gli stili e il layout del componente per adattarlo alle esigenze specifiche dell'applicazione
* Utilizzare le varianti di dimensione e layout per creare moduli compatti o estesi

Le linee guida implementative includono:

* Utilizzare Bootstrap per la gestione degli stili e del layout
* Utilizzare gli standard WCAG 2.1 per garantire l'accessibilità del componente

Le pratiche da evitare includono:

* Non utilizzare il componente come un semplice contenitore per campi di input, ma piuttosto come un elemento dell' interfaccia utente che fornisce una struttura logica e organizzata per la creazione di moduli complessi

## Componenti Correlati

I componenti associati al Form Group includono:

* **Campo di input**: il componente può essere utilizzato con campi di input per creare moduli complessi
* **Etichetta**: il componente può essere utilizzato con etichette per fornire descrizioni e istruzioni per ogni campo

Le relazioni con altri elementi includono:

* **Modulo**: il Form Group è un elemento chiave nella creazione di moduli complessi
* **Pagina**: il Form Group può essere utilizzato in diverse pagine dell'applicazione per fornire una struttura logica e organizzata per la creazione di moduli complessi


## OVERVIEW
<div class="table-responsive">`import { FormGroupComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente FormGroupComponent presenta un esempio interattivo del componente e consente di configurarne le proprietà principali per osservare come influenzano il suo comportamento e il suo aspetto. Il componente è pensato per essere utilizzato all'interno di form complessi e sfrutta il sistema a griglia di Bootstrap per gestire la larghezza e la disposizione degli elementi.


## API
<div class="table-responsive">
  <table class="table">
   <thead>
      <tr>
         <th><strong>Campo</strong></th>
         <th><strong>Descrizione</strong></th>
      </tr>
   </thead>
   <tbody>
      <tr>
         <td><code>title</code></td>
         <td>
            `@Input() title = 'LABEL.NO_TITLE';` <br />
            Titolo del form group.
         </td>
      </tr>
      <tr>
         <td><code>accordion</code></td>
         <td>
            `@Input() accordion = false;` <br />
            Abilita la modalità accordion per il form group.
         </td>
      </tr>
      <tr>
         <td><code>asteriskRequiredLegend</code></td>
         <td>
            `@Input() asteriskRequiredLegend: boolean = true;` <br />
            Mostra o nasconde l'asterisco per i campi obbligatori in base alla configurazione.
         </td>
      </tr>
      <tr>
         <td><code>size</code></td>
         <td>
            `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
            La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
         </td>
      </tr>
      <tr>
         <td><code>id</code></td>
         <td>
            `@Input() override id = composeUniqueId('form_group');` <br />
            La proprietà `id` nella classe `BasePageSection` rappresenta un identificatore univoco. Questo ID è sovrascritto da BasePageSection.
         </td>
      </tr>
   </tbody>
</table>
</div>