## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente Single Checkbox includono:

* La possibilità di specificare il valore selezionato e deselezionato
* La gestione della visualizzazione del messaggio di supporto
* La possibilità di abilitare o disabilitare la casella di controllo

Gli aspetti tecnici rilevanti includono:

* La struttura HTML del componente
* Le proprietà CSS utilizzate per stilarne l'aspetto
* Le funzionalità JavaScript utilizzate per gestirne il comportamento

Le caratteristiche di accessibilità includono:

* La possibilità di utilizzare la tastiera per selezionare e deselezionare l'opzione
* La visualizzazione di un messaggio di supporto per aiutare gli utenti con disabilità visive

## VARIANTI
Le varianti disponibili per il componente Single Checkbox includono:

* Una variante con un messaggio di supporto visualizzato al di sotto della casella di controllo
* Una variante con un messaggio di supporto visualizzato accanto alla casella di controllo

Per ogni variante, i casi d'uso specifici includono:

* Utilizzare la variante con il messaggio di supporto visualizzato sotto la casella di controllo quando lo spazio è limitato
* Utilizzare la variante con il messaggio di supporto visualizzato accanto alla casella di controllo quando si desidera fornire più informazioni all'utente

## BEST PRACTICES
Le raccomandazioni d'uso per il componente Single Checkbox includono:

* Utilizzare un linguaggio chiaro e conciso per il messaggio di supporto
* Assicurarsi che la casella di controllo sia sufficientemente grande da essere selezionata facilmente

Le linee guida implementative includono:

* Utilizzare le proprietà CSS per stilarne l'aspetto in modo coerente con il resto dell'applicazione
* Utilizzare le funzionalità JavaScript per gestirne il comportamento in modo efficiente

Le pratiche da evitare includono:

* Utilizzare un linguaggio ambiguo o confuso per il messaggio di supporto
* Rendere la casella di controllo troppo piccola da essere selezionata facilmente

## COMPONENTI CORRELATI
I componenti associati al componente Single Checkbox includono:

* Il componente Label, utilizzato per fornire un'etichetta per la casella di controllo
* Il componente Button, utilizzato per fornire un pulsante per confermare la scelta dell'utente

Le relazioni con altri elementi includono:

* La possibilità di utilizzare il componente Single Checkbox all'interno di un modulo o di una tabella
* La possibilità di utilizzare il componente Single Checkbox in combinazione con altri componenti, come ad esempio il componente Select.

## OVERVIEW
<div class="table-responsive">`import { SingleCheckboxComponent } from '@inail/internet-webkit/form-controls';`</div>

Il componente Single Checkbox è progettato per fornire un modo semplice e intuitivo per creare un'opzione selezionabile all'interno di un'interfaccia utente. La singola opzione rappresenta una scelta indipendente che l'utente può abilitare o disabilitare a seconda delle proprie esigenze


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>checked-value</code></td>
      <td>
        `@Input('checked-value') checkedValue: any = true;` <br />
        Specificare lo stato selezionato del checkbox.
      </td>
    </tr>
    <tr>
      <td><code>unchecked-value</code></td>
      <td>
        `@Input('unchecked-value') uncheckedValue: any = false;` <br />
        Specificare lo stato deselezionato del checkbox.
      </td>
    </tr>
    <tr>
      <td><code>line</code></td>
      <td>
        `@Input() line!: false;` <br />
        Controlla il layout del componente checkbox, visualizzandolo come un elemento block-level quando è falso o inline con altri elementi quando è vero.
      </td>
    </tr>
    <tr>
      <td><code>i18n-extra</code></td>
      <td>
        `@Input('i18n-extra') i18nExtra: any;` <br />
        Consente al componente di visualizzare testo tradotto aggiuntivo o informazioni localizzate accanto alla casella di controllo.
      </td>
    </tr>
    <tr>
      <td><code>alignInForm</code></td>
      <td>
        `@Input() alignInForm = false;` <br />
        Allinea la casella di controllo all'interno di una struttura form per adattarla al layout o allo stile generale del form.
      </td>
    </tr>
    <tr>
      <td><code>showMessages</code></td>
      <td>
        `@Input() showMessages = true;` <br />
        Caso particolare in cui i messaggi non devono essere visualizzati.
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class SingleCheckboxComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent.</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
     `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>
