## CARATTERISTICHE PRINCIPALI
Le funzionalità chiave del componente includono:

* La gestione degli eventi di selezione e deselezione
* La compatibilità con le tecnologie di accessibilità

Gli aspetti tecnici rilevanti includono:

* L'utilizzo di HTML, CSS e JavaScript per la creazione del componente
* La possibilità di integrare il componente con altre librerie e framework

Le caratteristiche di accessibilità includono:

* La conformità alle linee guida WCAG 2.1
* La possibilità di utilizzare tasti di scelta rapida per la navigazione

## VARIANTI
Il componente presenta le seguenti varianti:

* **Checkbox disabilitata**: una variante che visualizza un'opzione non selezionabile
* **Checkbox con errore**: una variante che visualizza un messaggio di errore accanto all'opzione
* **Etichetta del campo**: una variante che visualizza un'etichetta descrittiva per l'intero campo

Casi d'uso specifici per ogni variante:

* La variante "Checkbox disabilitata" può essere utilizzata per indicare un'opzione non disponibile
* La variante "Checkbox con errore" può essere utilizzata per segnalare un errore di validazione
* La variante "Etichetta del campo" può essere utilizzata per fornire un contesto aggiuntivo per l'intero campo

## BEST PRACTICES
Raccomandazioni d'uso:

* Utilizzare il componente per selezioni multiple quando le opzioni sono poche e ben definite
* Non utilizzare il componente per selezioni troppo lunghe o complesse. Per esempio, non può essere utilizzata una checkbox per selezionare un paragrafo di testo.
* Utilizzare la variante "Checkbox disabilitata" per indicare opzioni non disponibili

Linee guida implementative:

* Utilizzare HTML semantico per la struttura del componente
* Utilizzare CSS per personalizzare l'aspetto del componente
* Utilizzare JavaScript per gestire gli eventi di selezione e deselezione

Pratiche da evitare:

* Non utilizzare il componente come sostituto di un campo di testo o di una lista a discesa
* Non utilizzare la variante "Checkbox con errore" come unico mezzo per segnalare errori di validazione

## COMPONENTI CORRELATI
Il componente Form Items Checkbox può essere utilizzato in combinazione con altri componenti, come:

* Campo di testo: per fornire un input aggiuntivo per l'utente
* Lista a discesa: per fornire opzioni multiple in un formato più compatto

Relazioni con altri elementi:

* Il componente può essere utilizzato all'interno di un modulo o di una scheda per fornire un contesto aggiuntivo per le opzioni.

## ACCESSIBILITA'
La label deve essere associata all’input tramite l’attributo `for`.
Qualora label e input non siano direttamente collegati nel DOM (es. separati da contenitori), utilizzare `aria-labelledby` per garantire la corretta associazione per le tecnologie assistive.
