## CARATTERISTICHE PRINCIPALI

* **Funzionalità chiave**: il componente consente agli utenti di inserire un range di valori numerici e gestisce gli errori di input.
* **Aspetti tecnici rilevanti**: il componente utilizza una logica di validazione per controllare che i valori inseriti siano numerici e che il range sia valido.
* **Caratteristiche di accessibilità**: il componente è progettato per essere utilizzato da utenti con disabilità, con una struttura HTML semantica e attributi ARIA per migliorare l'accessibilità.

## VARIANTI

Il componente ha le seguenti varianti:

* **Range di input numerico**: questa variante rappresenta la forma base del componente, che consente agli utenti di inserire un range di valori numerici.
* **Range di input numerico disabilitato**: questa variante rappresenta il componente quando è disabilitato e non può essere utilizzato dall'utente.
* **Range di input numerico con errore**: questa variante rappresenta il componente quando si verifica un errore di input, ad esempio se l'utente inserisce un valore non numerico.
* **Range di input numerico di info**: questa variante rappresenta il componente quando è utilizzato per fornire informazioni aggiuntive all'utente.

## BEST PRACTICES

Per utilizzare questo componente in modo efficace, si consiglia di:

* Utilizzare una etichetta chiara e concisa per descrivere lo scopo del componente.
* Fornire un feedback immediato agli utenti quando si verifica un errore di input.
* Utilizzare la variante disabilitata quando il componente non è disponibile.

## COMPONENTI CORRELATI

Il componente Form Items Input Number Range può essere utilizzato in combinazione con altri componenti per creare una interfaccia utente completa. Alcuni esempi di componenti correlati sono:

* **Form**: il componente Form Items Input Number Range può essere utilizzato all'interno di un form per raccogliere dati dall'utente.
* **Button**: il componente Button può essere utilizzato per fornire un modo per l'utente di inviare i dati inseriti nel form.

## ACCESSIBILITA

Nel codice, fieldset serve a raggruppare logicamente i due campi numerici (Da e A) che formano un intervallo.
La legend fornisce il titolo del gruppo ("Intervallo numerico"), utile soprattutto ai lettori di schermo.
Con la classe sr-only, il testo della legend non è visibile ma resta accessibile.

La label deve essere associata all’input tramite l’attributo `for`.
Qualora label e input non siano direttamente collegati nel DOM (es. separati da contenitori), utilizzare `aria-labelledby` per garantire la corretta associazione per le tecnologie assistive.
