## CARATTERISTICHE PRINCIPALI

* Funzionalità chiave: il componente consente di inserire valori numerici, con opzioni per impostare un valore predefinito e gestire gli errori.
* Aspetti tecnici rilevanti: il componente utilizza la proprietà `propertyName` per identificare il campo di input e la proprietà `defaultValue` per impostare un valore predefinito.
* Caratteristiche di accessibilità: il componente è progettato per essere accessibile agli utenti con disabilità, con opzioni per personalizzare l'aspetto e il comportamento del campo di input.

## VARIANTI

* **Campo di Input Numerico**: la variante base del componente, che consente di inserire valori numerici.
	+ Casi d'uso: utilizzare questo componente quando è necessario inserire un valore numerico semplice.
	+ Breve descrizione: il campo di input numerico è un elemento di interfaccia utente semplice e intuitivo per l'inserimento di dati numerici.
* **Campo di Input Numerico Disabilitato**: la variante del componente che consente di disabilitare il campo di input.
	+ Casi d'uso: utilizzare questo componente quando è necessario disabilitare temporaneamente il campo di input.
	+ Breve descrizione: il campo di input numerico disabilitato è un elemento di interfaccia utente che consente di disabilitare temporaneamente l'inserimento di dati numerici.
* **Campo di Input Numerico con Errore**: la variante del componente che consente di gestire gli errori.
	+ Casi d'uso: utilizzare questo componente quando è necessario gestire errori durante l'inserimento di dati numerici.
	+ Breve descrizione: il campo di input numerico con errore è un elemento di interfaccia utente che consente di gestire errori durante l'inserimento di dati numerici.
* **Campo di Input Numerico di Info**: la variante del componente che consente di visualizzare informazioni aggiuntive.
	+ Casi d'uso: utilizzare questo componente quando è necessario visualizzare informazioni aggiuntive relative al campo di input.
	+ Breve descrizione: il campo di input numerico di info è un elemento di interfaccia utente che consente di visualizzare informazioni aggiuntive relative al campo di input.

## BEST PRACTICES

* Raccomandazioni d'uso: utilizzare il componente Campo di Input Numerico quando è necessario inserire valori numerici semplici.
* Linee guida implementative: assicurarsi di impostare un valore predefinito e gestire gli errori per garantire una buona esperienza utente.
* Pratiche da evitare: non utilizzare il componente Campo di Input Numerico quando è necessario inserire valori numerici complessi o con opzioni multiple.

## COMPONENTI CORRELATI

* Componenti associati: il componente Campo di Input Numerico può essere utilizzato in combinazione con altri componenti, come ad esempio il componente Etichetta.
* Relazioni con altri elementi: il componente Campo di Input Numerico è strettamente correlato all'elemento `input` HTML.

## ACCESSIBILITA'
La label deve essere associata all’input tramite l’attributo `for`.
Qualora label e input non siano direttamente collegati nel DOM (es. separati da contenitori), utilizzare `aria-labelledby` per garantire la corretta associazione per le tecnologie assistive.
