## CARATTERISTICHE PRINCIPALI

Le funzionalità chiave del componente "Tabs" includono:

- La possibilità di personalizzare l'aspetto e il comportamento delle tabs mediante l'utilizzo di attributi e classi CSS
- La gestione degli eventi di click e di cambiamento dello stato attivo delle tabs
- La compatibilità con dispositivi mobili e desktop

Gli aspetti tecnici rilevanti del componente "Tabs" includono:

- L'utilizzo di HTML, CSS e JavaScript per la creazione e la gestione delle tabs
- La possibilità di utilizzare librerie e framework come Angular per semplificare lo sviluppo e la gestione del componente

Le caratteristiche di accessibilità del componente "Tabs" includono:

- La conformità agli standard WCAG 2.1 per l'accessibilità web
- La possibilità di utilizzare attributi ARIA per migliorare l'esperienza utente per gli utenti con disabilità

## VARIANTI

Le varianti disponibili del componente "Tabs" includono:

Variante 1: Tabs di base

Questa variante rappresenta la forma più semplice del componente "Tabs", con una sola tab attiva e un contenuto associato.

Casi d'uso specifici per questa variante includono:

- La visualizzazione di informazioni diverse all'interno di un'applicazione web
- La gestione di sezioni di contenuto in una singola pagina

Breve descrizione: "Tabs di base"

Variante 2: Tabs con più sezioni

Questa variante consente di creare più sezioni di contenuto (tabs) con titoli personalizzabili.

Casi d'uso specifici per questa variante includono:

- La gestione di informazioni complesse all'interno di un'applicazione web
- La visualizzazione di dati diversi in una singola pagina

Breve descrizione: "Tabs con più sezioni"

Variante 3: Tabs con stato attivo personalizzato

Questa variante consente di personalizzare l'aspetto e il comportamento dello stato attivo delle tabs.

Casi d'uso specifici per questa variante includono:

- La creazione di un'esperienza utente personalizzata all'interno di un'applicazione web
- La gestione di sezioni di contenuto con stati attivi diversi

Breve descrizione: "Tabs con stato attivo personalizzato"

## BEST PRACTICES

Raccomandazioni d'uso:

- Utilizzare il componente "Tabs" per gestire informazioni diverse all'interno di un'applicazione web
- Personalizzare l'aspetto e il comportamento delle tabs mediante l'utilizzo di attributi e classi CSS

Linee guida implementative:

- Utilizzare librerie e framework come Angular per semplificare lo sviluppo e la gestione del componente
- Conformarsi agli standard WCAG 2.1 per l'accessibilità web

Pratiche da evitare:

- Non utilizzare il componente "Tabs" per gestire informazioni troppo complesse o voluminose
- Evitare una personalizzazione eccessiva dell’aspetto e del comportamento delle tabs, poiché potrebbe compromettere l’esperienza utente.

## COMPONENTI CORRELATI

I componenti associati al componente "Tabs" includono:

- Il componente "Accordion", che consente di visualizzare e gestire sezioni di contenuto in una singola pagina
- Il componente "Collapse", che consente di visualizzare e gestire sezioni di contenuto con stati attivi diversi

Relazioni con altri elementi:

- Il componente "Tabs" può essere combinato con altri elementi, come "Accordion" e "Collapse", per offrire un’esperienza utente più completa.

## OVERVIEW

<div class="table-responsive">`import { TabsComponent } from '@inail/intranet-webkit/tabs';`</div>

Il TabsComponent rappresenta un sistema di navigazione a schede (tabs) che permette di visualizzare contenuti diversi in base alla scheda selezionata. Ogni scheda può avere un template personalizzato, mentre il componente gestisce lo stato della scheda attiva tramite l'input activeTab e l'output onTabChanged. È progettato per essere configurabile con un array di schede e relativi template, supportando funzionalità avanzate come tipi di schede e creazione dinamica dei contenuti.

## API

<div class="table-responsive">
  <table class="table table-documentation">
   <thead>
	  <tr>
		 <th style="width: 20%"><strong>Campo</strong></th>
		 <th style="width: 80%"><strong>Descrizione</strong></th>
	  </tr>
   </thead>
   <tbody>
	  <tr>
		 <td><code>id</code></td>
		 <td> <code> @Input() id = composeUniqueId('tabs');</code><br /> Identificativo univoco per il Tabs. Può essere utilizzato per riferirsi al componente in modo specifico. </td>
	  </tr>
	  <tr>
		 <td><code>createAll</code></td>
		 <td>
			`@Input() createAll = false;` <br />
			Boolean che gestisce la generazione dei templates.
		 </td>
	  </tr>
	   <tr>
		 <td><code>tabs</code></td>
		 <td>
			`@Input() tabs: (AdvancedTab)[] = [];` <br />
		   Un array di oggetti di tipo <a href="?path=/docs/resources-models-advancedtab--docs"> AdvancedTab</a> che rappresentano tutti i tab disponibili nella pagina. 
		 </td>
	  </tr>
        <tr>
		 <td><code>activeTab</code></td>
		 <td>
			`@Input() activeTab!: AdvancedTab;` <br />
		    Rappresenta il tab attualmente attivo (espanso).
		 </td>
	  </tr>
      <tr>
		 <td><code>templates</code></td>
		 <td>
			`@Input() templates: TemplateRef<any>[] = [];` <br />
		    Array dei templates children dei tab.
		 </td>
	  </tr>
   </tbody>
</table>
</div>

<br/>

<div class="table-responsive">
  <table class="table table-documentation">
  <thead>
	<tr>
	  <th style="width: 20%"><strong>Campo</strong></th>
	  <th style="width: 80%"><strong>Descrizione</strong></th>
	</tr>
  </thead>
  <tbody>
	<tr>
	  <td><code>onTabChanged</code></td>
	  <td>
		`@Output() onTabChanged: EventEmitter<AdvancedTab> = new EventEmitter();` <br />
		Event emitter che gestisce l'evento onChangeTab($event).
	  </td>
	</tr>
  </tbody>
</table>
</div>