## CARATTERISTICHE PRINCIPALI
* Funzionalità chiave:
 + Titolo personalizzabile
 + Messaggio personalizzabile
 + Azioni personalizzabili
* Aspetti tecnici rilevanti:
 + Il componente utilizza un array di azioni per gestire le risposte dell'utente
 + La proprietà "body" è true quando l'array di azioni non è vuoto, il che apre la sezione body del feedback
* Caratteristiche di accessibilità: N.D.

## VARIANTI
Il componente Feedback ha una sola variante disponibile:

* Variante 1: Feedback standard
 + Descrizione: mostra un titolo e un messaggio personalizzato
 + Casi d'uso specifici:
 - Mostrare un messaggio di conferma dopo l'esecuzione di un'azione
 - Mostrare un messaggio di errore in caso di fallimento di un'azione
 + Breve descrizione: il componente Feedback standard può essere utilizzato per mostrare messaggi di conferma o errore in risposta alle azioni dell'utente

## BEST PRACTICES
* Raccomandazioni d'uso:
 + Utilizzare il componente Feedback per mostrare messaggi di conferma o errore in risposta alle azioni dell'utente
 + Personalizzare il titolo e il messaggio del feedback per adattarsi alle esigenze specifiche dell'applicazione
* Linee guida implementative:
 + Assicurarsi che il componente Feedback sia accessibile per gli utenti con disabilità
 + Utilizzare un design coerente per il componente Feedback in tutta l'applicazione
* Pratiche da evitare: N.D.

## COMPONENTI CORRELATI
Il componente Feedback è associato ai seguenti componenti:

* Button: può essere utilizzato per eseguire azioni specifiche in risposta al feedback
* Dialog: può essere utilizzato per mostrare il componente Feedback in una finestra di dialogo

## OVERVIEW
<div class="table-responsive">`import { FeedbackComponent } from '@inail/internet-webkit/elements';`</div>
Un componente custom utilizzato per creare messaggi o contenuti di supporto all'interno di una pagina web.

## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>id</code></td>
      <td>
        `@Input() override id: string = composeUniqueId('feedback');` <br />
        Id univoco del feedback.
      </td>
    </tr>
    <tr>
      <td><code>type</code></td>
      <td>
          `@Input() type: FeedbackType = 'default';` <br />
          Tipo di feedback che determina anche lo stile. <br />
          `type FeedbackType = 'success' | 'danger' | 'warning' | 'info' | 'primary' | 'default';`
      </td>
    </tr>
    <tr>
      <td><code>title</code></td>
      <td>
          `@Input() title = 'LABEL.TITLE';` <br />
          Input di tipo string che assegna il titolo al feedback.
      </td>
    </tr>
    <tr>
      <td><code>actions</code></td>
      <td>
          `@Input() actions: any[] = [];` <br />
          Input di tipo any che assegna un array di <a href="?path=/docs/resources-models-actionitem--docs">ActionItem</a> al feedback.
      </td>
    </tr>
    <tr>
      <td><code>body</code></td>
      <td>
          `@Input() body = false;` <br />
          Input di tipo `boolean` che mostra contenuto condizionale.
      </td>
    </tr>
    <tr>
      <td><code>i18nParams</code></td>
      <td>
          `@Input() i18nParams = {};` <br />
          Oggetto che imposta i parametri di traduzione. <br />
          `{{ title | translate: i18nParams }}`
      </td>
    </tr>
    <tr>
      <td><code>result</code></td>
      <td>
          `@Input() result : null | number = null;`
          Input numerico che valorizza i risultati mostrati nel componente feedback.
      </td>
    </tr>
  </tbody>
</table>
</div>