## CARATTERISTICHE PRINCIPALI


Il componente Double Date presenta le seguenti caratteristiche chiave:

* **Funzionalità chiave**: la selezione di due date separate
* **Aspetti tecnici rilevanti**: il componente utilizza una logica di selezione della data per gestire la selezione delle due date
* **Caratteristiche di accessibilità**: il componente è progettato per essere accessibile agli utenti con disabilità, con una struttura HTML semantica e attributi ARIA per migliorare l'esperienza degli utenti che utilizzano tecnologie assistive

## VARIANTI


Il componente Double Date presenta le seguenti varianti:

* **Test della descrizione dell' input Double Date INAIL**: questa variante include una descrizione dettagliata dell'input e delle sue funzionalità
* **Double Date**: questa variante rappresenta la versione standard del componente, senza descrizioni aggiuntive

Per ogni variante, i casi d'uso specifici includono:

* La selezione di due date separate per una data specifica (ad esempio, una data di inizio e una data di fine)
* L'utilizzo del componente in diverse applicazioni web per fornire una funzionalità di selezione della data

## BEST PRACTICES


Per utilizzare al meglio il componente Double Date, si consiglia di:

* Utilizzare il componente in contesti dove la selezione di due date separate è necessaria
* Fornire una descrizione chiara e concisa delle funzionalità del componente per gli utenti
* Utilizzare attributi ARIA per migliorare l'accessibilità del componente

## COMPONENTI CORRELATI


Il componente Double Date può essere utilizzato in combinazione con altri componenti dell' interfaccia utente, come ad esempio:

* **Calendario**: un componente che consente all'utente di visualizzare e selezionare date in formato calendario
* **Form**: un componente che consente all'utente di inserire dati in un modulo web

In questo caso, non ci sono componenti correlati specifici menzionati nel testo.


## OVERVIEW
<div class="table-responsive">`import { InputDoubleDateComponent } from '@inail/internet-webkit/form-controls';`</div>
Questo componente rappresenta un campo di input doppio per date, che permette agli utenti di inserire una data di inizio e una data di fine. È completamente configurabile attraverso diverse proprietà come etichette, placeholder, validazioni e dimensioni. 


## API
<div class="table-responsive">
  <table class="table">
  <thead>
    <tr>
      <th><strong>Campo</strong></th>
      <th><strong>Descrizione</strong></th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><code>fromLabel</code></td>
      <td>
        `@Input() fromLabel = 'INPUT.DDATE.FROM';` <br />
        Etichetta per il campo input della data di inizio.
      </td>
    </tr>
    <tr>
      <td><code>toLabel</code></td>
      <td>
        `@Input() toLabel = 'INPUT.DDATE.TO';` <br />
        Etichetta per il campo input della date di fine.
      </td>
    </tr>
    <tr>
      <td><code>disableFrom</code></td>
      <td>
        `@Input() disableFrom: boolean;` <br />
        Disabilita l'input della data di inizio.
      </td>
    </tr>
     <tr>
      <td><code>disableTo</code></td>
      <td>
        `@Input() disableTo: boolean;` <br />
        Disabilita l'input della data di fine.
      </td>
    </tr>
    <tr>
      <td><code>regex</code></td>
      <td>
        `@Input() regex!: RegExp | string | string[];` <br />
        Modello regex per convalidare l'input della data.
       <ul>
            <li>
              Se il valore è un oggetto `RegExp`, significa che si sta passando un' espressione regolare JavaScript. Le espressioni regolari sono utilizzate per cercare e fare il matching di pattern all'interno di stringhe.
              `regex = /^[a-zA-Z]+$/;`
            </li>
            <li>
              Se il valore è una stringa, questa verrà trattata come una rappresentazione di un pattern. Quando la stringa viene utilizzata come regex, viene convertita internamente in una `RegExp` per eseguire operazioni di matching. 
              `regex = "^abc";`
            </li>
             <li>
              Se il valore è un array di stringhe, ciascun elemento dell'array rappresenta un pattern di stringa da utilizzare separatamente per il matching.
              `regex = ["^abc", "xyz$"];`
            </li>
       </ul>  
      </td>
    </tr>
    <tr>
      <td><code>BaseInputComponent controls</code></td>
      <td>
        `class InputComboboxComponent extends BaseInputComponent` <br />
        Fare riferimento a <a href="?path=/docs/resources-models-baseinputcomponent--docs">BaseInputComponent</a>
      </td>
    </tr>
    <tr>
      <td><code>size</code></td>
      <td>
      `@Input() size: BootstrapSize = new BootstrapSize(12, 12, 12);` <br />
      La proprietà `size` nella classe `BasePageSection`, di tipo <a href="?path=/docs/resources-models-bootstrapsize--docs">BootstrapSize </a> , rappresenta la configurazione delle colonne del sistema a griglia di Bootstrap per il componente. Questa proprietà consente di controllare la larghezza del componente su diverse dimensioni dello schermo, utilizzando i principi di progettazione responsiva di Bootstrap.
      </td>
    </tr>
  </tbody>
</table>
</div>